/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.script.miniscript.exec;

import com.kingdee.bos.ctrl.script.miniscript.exec.objs.Null;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class OperationUtil {
    private static final int TYPE_NON_NUMBER = 100;
    private static final int TYPE_INT = 3;
    private static final int TYPE_LONG = 4;
    private static final int TYPE_FLOAT = 5;
    private static final int TYPE_DOUBLE = 6;
    private static final int TYPE_BIGDECIMAL = 7;
    private static final int OP_PLUS = 0;
    private static final int OP_SUB = 1;
    private static final int OP_MULTI = 2;
    private static final int OP_DIV = 3;
    private static final int OP_PER = 4;
    private static final int OP_AND = 5;
    private static final int OP_OR = 6;
    private static final int OP_SINGLEAND = 7;
    private static final int OP_SINGLEOR = 8;
    private static final int OP_EXCLUSIVE = 9;
    private static final int OP_GT = 10;
    private static final int OP_LT = 11;
    private static final int OP_GE = 12;
    private static final int OP_LE = 13;
    private static final int OP_EQ = 14;
    private static final int OP_NE = 15;
    private static final int OP_RSHIFT = 16;
    private static final int OP_LSHIFT = 17;
    private static final int OP_UNSIGNRSHIFT = 18;
    private static final int OP_NOR = 19;
    private static final int OP_ANTI = 20;
    private static final Map numberTypeValueMap = new HashMap();
    private static final Map opMap = new HashMap();

    private OperationUtil() {
    }

    public static Object op(String op, Object op1, Object op2) {
        Integer iv = (Integer)opMap.get(op);
        if (iv == null) {
            throw new IllegalArgumentException("Unsupport operator: " + op);
        }
        if (op1 instanceof Null) {
            throw new IllegalArgumentException("op1 can't be null.");
        }
        if (op2 instanceof Null) {
            throw new IllegalArgumentException("op2 can't be null.");
        }
        int v = iv;
        switch (v) {
            case 20: {
                switch (OperationUtil.getNumberTypeValue(op2.getClass())) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Integer(~OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op2) ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    case 5: {
                        throw new RuntimeException("Operator " + op + " can not with float operand.");
                    }
                    case 6: {
                        throw new RuntimeException("Operator " + op + " can not with double operand.");
                    }
                    case 7: {
                        throw new RuntimeException("Operator " + op + " can not with bigdecimal operand.");
                    }
                }
            }
            case 19: {
                if (op2 instanceof Boolean) {
                    return !OperationUtil.getBooleanValue(op2);
                }
                throw new RuntimeException("Operator " + op + " can not with non-boolean operand.");
            }
        }
        int maxType = OperationUtil.getMaxNumberType(op1, op2);
        switch (v) {
            case 0: {
                switch (maxType) {
                    case 100: {
                        return String.valueOf(op1) + String.valueOf(op2);
                    }
                    case 3: {
                        return new Integer(OperationUtil.getIntValue(op1) + OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op1) + OperationUtil.getLongValue(op2));
                    }
                    case 5: {
                        return new Float(OperationUtil.getFloatValue(op1) + OperationUtil.getFloatValue(op2));
                    }
                    case 6: {
                        return new Double(OperationUtil.getDoubleValue(op1) + OperationUtil.getDoubleValue(op2));
                    }
                    case 7: {
                        return OperationUtil.getBigDecimal(op1).add(OperationUtil.getBigDecimal(op2));
                    }
                }
            }
            case 1: {
                switch (maxType) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Integer(OperationUtil.getIntValue(op1) - OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op1) - OperationUtil.getLongValue(op2));
                    }
                    case 5: {
                        return new Float(OperationUtil.getFloatValue(op1) - OperationUtil.getFloatValue(op2));
                    }
                    case 6: {
                        return new Double(OperationUtil.getDoubleValue(op1) - OperationUtil.getDoubleValue(op2));
                    }
                    case 7: {
                        return OperationUtil.getBigDecimal(op1).subtract(OperationUtil.getBigDecimal(op2));
                    }
                }
            }
            case 2: {
                switch (maxType) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Integer(OperationUtil.getIntValue(op1) * OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op1) * OperationUtil.getLongValue(op2));
                    }
                    case 5: {
                        return new Float(OperationUtil.getFloatValue(op1) * OperationUtil.getFloatValue(op2));
                    }
                    case 6: {
                        return new Double(OperationUtil.getDoubleValue(op1) * OperationUtil.getDoubleValue(op2));
                    }
                    case 7: {
                        return OperationUtil.getBigDecimal(op1).multiply(OperationUtil.getBigDecimal(op2));
                    }
                }
            }
            case 3: {
                switch (maxType) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Float((float)OperationUtil.getIntValue(op1) / OperationUtil.getFloatValue(op2));
                    }
                    case 4: {
                        return new Double((double)OperationUtil.getLongValue(op1) / OperationUtil.getDoubleValue(op2));
                    }
                    case 5: {
                        return new Float(OperationUtil.getFloatValue(op1) / OperationUtil.getFloatValue(op2));
                    }
                    case 6: {
                        return new Double(OperationUtil.getDoubleValue(op1) / OperationUtil.getDoubleValue(op2));
                    }
                    case 7: {
                        return OperationUtil.getBigDecimal(op1).divide(OperationUtil.getBigDecimal(op2), 16, 4);
                    }
                }
            }
            case 4: {
                switch (maxType) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Integer(OperationUtil.getIntValue(op1) % OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op1) % OperationUtil.getLongValue(op2));
                    }
                    case 5: {
                        return new Float(OperationUtil.getFloatValue(op1) % OperationUtil.getFloatValue(op2));
                    }
                    case 6: {
                        return new Double(OperationUtil.getDoubleValue(op1) % OperationUtil.getDoubleValue(op2));
                    }
                    case 7: {
                        return OperationUtil.createBigDecimal(OperationUtil.getDoubleValue(op1) % OperationUtil.getDoubleValue(op2));
                    }
                }
            }
            case 7: {
                switch (maxType) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Integer(OperationUtil.getIntValue(op1) & OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op1) & OperationUtil.getLongValue(op2));
                    }
                    case 5: {
                        throw new RuntimeException("Operator " + op + " can not with float operand.");
                    }
                    case 6: {
                        throw new RuntimeException("Operator " + op + " can not with double operand.");
                    }
                    case 7: {
                        throw new RuntimeException("Operator " + op + " can not with bigdecimal operand.");
                    }
                }
            }
            case 8: {
                switch (maxType) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Integer(OperationUtil.getIntValue(op1) | OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op1) | OperationUtil.getLongValue(op2));
                    }
                    case 5: {
                        throw new RuntimeException("Operator " + op + " can not with float operand.");
                    }
                    case 6: {
                        throw new RuntimeException("Operator " + op + " can not with double operand.");
                    }
                    case 7: {
                        throw new RuntimeException("Operator " + op + " can not with bigdecimal operand.");
                    }
                }
            }
            case 9: {
                switch (maxType) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Integer(OperationUtil.getIntValue(op1) ^ OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op1) ^ OperationUtil.getLongValue(op2));
                    }
                    case 5: {
                        throw new RuntimeException("Operator " + op + " can not with float operand.");
                    }
                    case 6: {
                        throw new RuntimeException("Operator " + op + " can not with double operand.");
                    }
                    case 7: {
                        throw new RuntimeException("Operator " + op + " can not with bigdecimal operand.");
                    }
                }
            }
            case 16: {
                switch (maxType) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Integer(OperationUtil.getIntValue(op1) >> OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op1) >> (int)OperationUtil.getLongValue(op2));
                    }
                    case 5: {
                        throw new RuntimeException("Operator " + op + " can not with float operand.");
                    }
                    case 6: {
                        throw new RuntimeException("Operator " + op + " can not with double operand.");
                    }
                    case 7: {
                        throw new RuntimeException("Operator " + op + " can not with bigdecimal operand.");
                    }
                }
            }
            case 17: {
                switch (maxType) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Integer(OperationUtil.getIntValue(op1) << OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op1) << (int)OperationUtil.getLongValue(op2));
                    }
                    case 5: {
                        throw new RuntimeException("Operator " + op + " can not with float operand.");
                    }
                    case 6: {
                        throw new RuntimeException("Operator " + op + " can not with double operand.");
                    }
                    case 7: {
                        throw new RuntimeException("Operator " + op + " can not with bigdecimal operand.");
                    }
                }
            }
            case 18: {
                switch (maxType) {
                    case 100: {
                        throw new RuntimeException("Operator " + op + " can not with non-number operand.");
                    }
                    case 3: {
                        return new Integer(OperationUtil.getIntValue(op1) >>> OperationUtil.getIntValue(op2));
                    }
                    case 4: {
                        return new Long(OperationUtil.getLongValue(op1) >>> (int)OperationUtil.getLongValue(op2));
                    }
                    case 5: {
                        throw new RuntimeException("Operator " + op + " can not with float operand.");
                    }
                    case 6: {
                        throw new RuntimeException("Operator " + op + " can not with double operand.");
                    }
                    case 7: {
                        throw new RuntimeException("Operator " + op + " can not with bigdecimal operand.");
                    }
                }
            }
            case 5: {
                if (OperationUtil.isBothBoolean(op1, op2)) {
                    return OperationUtil.getBooleanValue(op1) && OperationUtil.getBooleanValue(op2);
                }
                throw new RuntimeException("Operator " + op + " can not with non-boolean operand.");
            }
            case 6: {
                if (OperationUtil.isBothBoolean(op1, op2)) {
                    return OperationUtil.getBooleanValue(op1) || OperationUtil.getBooleanValue(op2);
                }
                throw new RuntimeException("Operator " + op + " can not with non-boolean operand.");
            }
            case 10: {
                switch (maxType) {
                    case 100: {
                        return OperationUtil.compare(op1, op2) > 0;
                    }
                    case 3: {
                        return OperationUtil.getIntValue(op1) > OperationUtil.getIntValue(op2);
                    }
                    case 4: {
                        return OperationUtil.getLongValue(op1) > OperationUtil.getLongValue(op2);
                    }
                    case 5: {
                        return OperationUtil.getFloatValue(op1) > OperationUtil.getFloatValue(op2);
                    }
                    case 6: {
                        return OperationUtil.getDoubleValue(op1) > OperationUtil.getDoubleValue(op2);
                    }
                    case 7: {
                        return OperationUtil.getDoubleValue(op1) > OperationUtil.getDoubleValue(op2);
                    }
                }
            }
            case 11: {
                switch (maxType) {
                    case 100: {
                        return OperationUtil.compare(op1, op2) < 0;
                    }
                    case 3: {
                        return OperationUtil.getIntValue(op1) < OperationUtil.getIntValue(op2);
                    }
                    case 4: {
                        return OperationUtil.getLongValue(op1) < OperationUtil.getLongValue(op2);
                    }
                    case 5: {
                        return OperationUtil.getFloatValue(op1) < OperationUtil.getFloatValue(op2);
                    }
                    case 6: {
                        return OperationUtil.getDoubleValue(op1) < OperationUtil.getDoubleValue(op2);
                    }
                    case 7: {
                        return OperationUtil.getDoubleValue(op1) < OperationUtil.getDoubleValue(op2);
                    }
                }
            }
            case 12: {
                switch (maxType) {
                    case 100: {
                        return OperationUtil.compare(op1, op2) >= 0;
                    }
                    case 3: {
                        return OperationUtil.getIntValue(op1) >= OperationUtil.getIntValue(op2);
                    }
                    case 4: {
                        return OperationUtil.getLongValue(op1) >= OperationUtil.getLongValue(op2);
                    }
                    case 5: {
                        return OperationUtil.getFloatValue(op1) >= OperationUtil.getFloatValue(op2);
                    }
                    case 6: {
                        return OperationUtil.getDoubleValue(op1) >= OperationUtil.getDoubleValue(op2);
                    }
                    case 7: {
                        return OperationUtil.getDoubleValue(op1) >= OperationUtil.getDoubleValue(op2);
                    }
                }
            }
            case 13: {
                switch (maxType) {
                    case 100: {
                        return OperationUtil.compare(op1, op2) <= 0;
                    }
                    case 3: {
                        return OperationUtil.getIntValue(op1) <= OperationUtil.getIntValue(op2);
                    }
                    case 4: {
                        return OperationUtil.getLongValue(op1) <= OperationUtil.getLongValue(op2);
                    }
                    case 5: {
                        return OperationUtil.getFloatValue(op1) <= OperationUtil.getFloatValue(op2);
                    }
                    case 6: {
                        return OperationUtil.getDoubleValue(op1) <= OperationUtil.getDoubleValue(op2);
                    }
                    case 7: {
                        return OperationUtil.getDoubleValue(op1) <= OperationUtil.getDoubleValue(op2);
                    }
                }
            }
            case 14: {
                switch (maxType) {
                    case 100: {
                        if (op1 == null && op2 == null) {
                            return Boolean.TRUE;
                        }
                        if (op1 == null || op2 == null) {
                            return Boolean.FALSE;
                        }
                        if (op1.equals(op2)) {
                            return Boolean.TRUE;
                        }
                        return OperationUtil.compare(op1, op2) == 0;
                    }
                    case 3: {
                        return OperationUtil.getIntValue(op1) == OperationUtil.getIntValue(op2);
                    }
                    case 4: {
                        return OperationUtil.getLongValue(op1) == OperationUtil.getLongValue(op2);
                    }
                    case 5: {
                        return OperationUtil.getFloatValue(op1) == OperationUtil.getFloatValue(op2);
                    }
                    case 6: {
                        return OperationUtil.getDoubleValue(op1) == OperationUtil.getDoubleValue(op2);
                    }
                    case 7: {
                        return OperationUtil.getDoubleValue(op1) == OperationUtil.getDoubleValue(op2);
                    }
                }
            }
            case 15: {
                switch (maxType) {
                    case 100: {
                        return OperationUtil.compare(op1, op2) != 0;
                    }
                    case 3: {
                        return OperationUtil.getIntValue(op1) != OperationUtil.getIntValue(op2);
                    }
                    case 4: {
                        return OperationUtil.getLongValue(op1) != OperationUtil.getLongValue(op2);
                    }
                    case 5: {
                        return OperationUtil.getFloatValue(op1) != OperationUtil.getFloatValue(op2);
                    }
                    case 6: {
                        return OperationUtil.getDoubleValue(op1) != OperationUtil.getDoubleValue(op2);
                    }
                    case 7: {
                        return OperationUtil.getDoubleValue(op1) != OperationUtil.getDoubleValue(op2);
                    }
                }
            }
        }
        throw new RuntimeException("Unsupport operator: " + op);
    }

    private static int compare(Object op1, Object op2) {
        if (op1 instanceof Comparable && op2 instanceof Comparable) {
            return ((Comparable)op1).compareTo(op2);
        }
        return String.valueOf(op1).compareTo(String.valueOf(op2));
    }

    private static boolean getBooleanValue(Object obj) {
        return (Boolean)obj;
    }

    private static int getIntValue(Object obj) {
        return ((Number)obj).intValue();
    }

    private static long getLongValue(Object obj) {
        return ((Number)obj).longValue();
    }

    private static float getFloatValue(Object obj) {
        return ((Number)obj).floatValue();
    }

    private static double getDoubleValue(Object obj) {
        return ((Number)obj).doubleValue();
    }

    private static BigDecimal getBigDecimal(Object obj) {
        return new BigDecimal(((Number)obj).toString());
    }

    private static boolean isBothBoolean(Object op1, Object op2) {
        return op1 instanceof Boolean && op2 instanceof Boolean;
    }

    private static int getMaxNumberType(Object op1, Object op2) {
        if (op1 == null || op2 == null) {
            return 100;
        }
        return Math.max(OperationUtil.getNumberTypeValue(op1.getClass()), OperationUtil.getNumberTypeValue(op2.getClass()));
    }

    private static int getNumberTypeValue(Class cl) {
        Integer v = (Integer)numberTypeValueMap.get(cl);
        if (v == null) {
            return 100;
        }
        return v;
    }

    private static BigDecimal createBigDecimal(double v) {
        String s = String.valueOf(v);
        return new BigDecimal(s);
    }

    static {
        numberTypeValueMap.put(Integer.TYPE, new Integer(3));
        numberTypeValueMap.put(Integer.class, new Integer(3));
        numberTypeValueMap.put(Long.TYPE, new Integer(4));
        numberTypeValueMap.put(Long.class, new Integer(4));
        numberTypeValueMap.put(Float.TYPE, new Integer(5));
        numberTypeValueMap.put(Float.class, new Integer(5));
        numberTypeValueMap.put(Double.TYPE, new Integer(6));
        numberTypeValueMap.put(Double.class, new Integer(6));
        numberTypeValueMap.put(BigDecimal.class, new Integer(7));
        opMap.put("+", new Integer(0));
        opMap.put("-", new Integer(1));
        opMap.put("*", new Integer(2));
        opMap.put("/", new Integer(3));
        opMap.put("%", new Integer(4));
        opMap.put("&&", new Integer(5));
        opMap.put("||", new Integer(6));
        opMap.put("&", new Integer(7));
        opMap.put("|", new Integer(8));
        opMap.put("^", new Integer(9));
        opMap.put(">", new Integer(10));
        opMap.put("<", new Integer(11));
        opMap.put(">=", new Integer(12));
        opMap.put("<=", new Integer(13));
        opMap.put("==", new Integer(14));
        opMap.put("!=", new Integer(15));
        opMap.put(">>", new Integer(16));
        opMap.put("<<", new Integer(17));
        opMap.put(">>>", new Integer(18));
        opMap.put("!", new Integer(19));
        opMap.put("~", new Integer(20));
    }
}

