/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.tabbedpane;

import com.kingdee.bos.ctrl.common.ui.tabbedpane.ILazyPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LazyTabbedPane
extends KDTabbedPane {
    public LazyTabbedPane() {
        this.installListener();
    }

    private void installListener() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LazyPanePacking lpp;
                Component c = LazyTabbedPane.this.getSelectedComponent();
                if (c instanceof LazyPanePacking && (lpp = (LazyPanePacking)((Object)c)).isEmpty()) {
                    lpp.loadPane();
                }
                LazyTabbedPane.this.onTabbedChanged(e);
            }
        });
    }

    protected void onTabbedChanged(ChangeEvent e) {
    }

    public KDPanel addLazyPane(ILazyPane lazyPane) {
        LazyPanePacking packing = new LazyPanePacking(lazyPane);
        this.add(lazyPane.getTabbedTitle(), (Component)((Object)packing));
        return packing;
    }

    public ILazyPane getLazyPane(int index) {
        LazyPanePacking packing = (LazyPanePacking)((Object)this.getComponentAt(index));
        return packing.getLazyPane();
    }

    class LazyPanePacking
    extends KDPanel {
        private ILazyPane _lazyPane;

        public LazyPanePacking(ILazyPane lazyPane) {
            this.setLazyPane(lazyPane);
        }

        private void setLazyPane(ILazyPane pane) {
            this._lazyPane = pane;
        }

        public ILazyPane getLazyPane() {
            return this._lazyPane;
        }

        public boolean isEmpty() {
            return this.getComponentCount() == 0;
        }

        public void loadPane() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.getLazyPane().getPanel(), "Center");
        }
    }
}

