/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.dataprocess;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.wizard.WizardResource;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.WizardDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class WizardPane
extends KDPanel {
    private WizardDialog window;
    protected KDTabbedPane tabbedPane;
    private int selIdx = -1;
    protected List lostTableList;

    public WizardPane() {
        this.setOpaque(false);
        this.tabbedPane = new KDTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (WizardPane.this.selIdx >= 0) {
                    WizardPane.this.onTabbedChanged(WizardPane.this.selIdx, WizardPane.this.tabbedPane.getSelectedIndex());
                }
                WizardPane.this.selIdx = WizardPane.this.tabbedPane.getSelectedIndex();
            }
        });
    }

    public void setToFirstTab() {
        this.tabbedPane.setSelectedIndex(0);
    }

    public WizardDialog getWindow() {
        return this.window;
    }

    public void setWindow(WizardDialog wnd) {
        this.window = wnd;
        this.window.setWizardPane(this);
        this.window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                String errorInfo = WizardPane.this.getInitErr();
                if (errorInfo != null && errorInfo.length() > 0) {
                    WindowUtil.msgboxError((Object)errorInfo.toString(), (String)WizardPane.this.getTitle(), (Component)((Object)WizardPane.this));
                    WizardPane.this.removeLostTable();
                }
                WizardPane.this.window.removeComponentListener(this);
            }
        });
    }

    public WizardDialog createWindow(Component parent) {
        this.setWindow((WizardDialog)((Object)WindowUtil.createWindow(WizardDialog.class, (Component)parent)));
        return this.window;
    }

    public boolean verify() {
        this.updateChange();
        return true;
    }

    public abstract Object getDataObject();

    public abstract void setDataObject(Object var1);

    protected void updateChange() {
        this.onTabbedChanged(this.tabbedPane.getSelectedIndex(), this.tabbedPane.getSelectedIndex());
    }

    protected abstract void onTabbedChanged(int var1, int var2);

    protected abstract void showValue();

    public abstract void setMeta(MetaLibrary var1);

    public static CustomPane createCustomPane(JComponent comp) {
        return new CustomPane(comp);
    }

    protected String getErrTitle() {
        return null;
    }

    public String getInitErr() {
        if (this.lostTableList == null) {
            return null;
        }
        if (this.lostTableList.size() == 0) {
            return null;
        }
        StringBuffer initErrPrompt = new StringBuffer();
        for (int i = 0; i < this.lostTableList.size(); ++i) {
            if (initErrPrompt.length() == 0) {
                initErrPrompt.append((String)this.lostTableList.get(i));
                continue;
            }
            initErrPrompt.append(", " + (String)this.lostTableList.get(i));
        }
        String errTitle = this.getErrTitle();
        if (errTitle == null) {
            errTitle = WizardResource.getString("res_18");
        }
        return errTitle + "\r\n" + initErrPrompt.toString();
    }

    public void removeLostTable() {
        this.lostTableList = new ArrayList();
    }

    public JComponent getCtrl() {
        return this;
    }

    public abstract String getTitle();

    protected static class CustomPane
    extends KDPanel {
        public CustomPane(JComponent comp) {
            this.setCustomInsets(new Insets(8, 8, 8, 8));
            this.setLayout(new BorderLayout());
            this.add(comp, "Center");
        }
    }
}

