/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine.rows.impl;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.ArrayWrapper;
import com.kingdee.bos.ctrl.common.util.WrapableArray;
import com.kingdee.bos.ctrl.common.util.list.ArrayBasedList;
import com.kingdee.bos.ctrl.common.util.list.BasicList;
import com.kingdee.bos.ctrl.common.util.list.exception.OutOfCapacityException;
import com.kingdee.bos.ctrl.data.engine.rows.RowsException;
import com.kingdee.bos.ctrl.data.engine.rows.impl.FileStoredRowList;
import com.kingdee.bos.ctrl.data.engine.rows.impl.IRowList;
import com.kingdee.bos.ctrl.data.engine.rows.impl.PlaceholderRow;
import com.kingdee.bos.ctrl.data.engine.rows.impl.Row;
import com.kingdee.bos.ctrl.data.engine.rows.impl.SimpleRowsMetaData;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class FileCachedRowList
implements IRowList {
    private SimpleRowsMetaData meta;
    private FileStoredRowList fileCache;
    private ArrayBasedList memoryCache;
    private int cacheRows;

    public FileCachedRowList(String filePath, int cacheRows, SimpleRowsMetaData colsInfo) throws RowsException {
        this(filePath, cacheRows, colsInfo, null);
    }

    public FileCachedRowList(String filePath, int cacheRows, SimpleRowsMetaData colsInfo, ResultSet rs) throws RowsException {
        this.meta = colsInfo;
        if (cacheRows != 0) {
            this.memoryCache = new ArrayBasedList(-1);
        }
        this.cacheRows = cacheRows;
        if (cacheRows >= 0) {
            try {
                this.fileCache = new FileStoredRowList(filePath, this.meta);
            }
            catch (IOException ex) {
                throw new RowsException("Create disk cache file failed,exception:" + ex.toString());
            }
        }
        if (rs != null) {
            try {
                this.loadResultSet(rs);
            }
            catch (IOException ioex) {
                throw new RowsException("Write disk cache file failed,exception:" + ioex.toString());
            }
            catch (SQLException sqlex) {
                throw new RowsException("Load resultset failed,exception:" + sqlex.toString());
            }
        }
    }

    private void loadResultSet(ResultSet rs) throws IOException, SQLException {
        Object[] temp;
        int memoryCaches = this.cacheRows < 0 ? -1 : (int)(0.5 * (double)this.cacheRows);
        ArrayList<Row> tmp = new ArrayList<Row>();
        BasicList[] lists = new BasicList[]{memoryCaches == 0 ? this.fileCache : this.memoryCache, memoryCaches == 0 ? this.memoryCache : this.fileCache};
        int batches = 200;
        int use = 0;
        while (rs.next()) {
            int i;
            Row row = new Row(this.meta);
            tmp.add(row);
            for (i = 0; i < this.meta.getColumnCount(); ++i) {
                row.setValue(i + 1, rs.getObject(i + 1));
            }
            if (tmp.size() != batches && (--memoryCaches != 0 || lists[use] != this.memoryCache)) continue;
            try {
                temp = tmp.toArray();
                lists[use].addBatch(temp);
                if (lists[(use + 1) % 2] != null) {
                    for (i = 0; i < temp.length; ++i) {
                        temp[i] = PlaceholderRow.instance;
                    }
                    lists[(use + 1) % 2].addBatch(temp);
                }
                tmp.clear();
            }
            catch (OutOfCapacityException outOfCapacityException) {
                // empty catch block
            }
            if (memoryCaches != 0) continue;
            use = 1;
        }
        if (tmp.size() > 0) {
            try {
                temp = tmp.toArray();
                lists[use].addBatch(temp);
                if (lists[(use + 1) % 2] != null) {
                    for (int i = 0; i < temp.length; ++i) {
                        temp[i] = PlaceholderRow.instance;
                    }
                    lists[(use + 1) % 2].addBatch(temp);
                }
                tmp.clear();
            }
            catch (OutOfCapacityException outOfCapacityException) {
                // empty catch block
            }
        }
    }

    @Override
    public int addColumn(int column, String name, DataType colType, HashMap extProps) throws RowsException {
        if (column == -1) {
            column = this.meta.getColumnCount() + 1;
        }
        ArrayWrapper oldWrapper = (ArrayWrapper)this.meta.getArrayWrapper().clone();
        this.meta.addColumn(column, name, colType, extProps);
        Object[] rows = new Object[this.count()];
        this.memoryCache.getBatch(0, rows, 0, rows.length);
        WrapableArray[] arries = new WrapableArray[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            arries[i] = ((Row)rows[i]).values;
        }
        oldWrapper.wrap(new WrapableArray(rows)).batchAdd(arries, column, null);
        return column;
    }

    @Override
    public void deleteColumn(int column) throws RowsException {
        ArrayWrapper oldWrapper = (ArrayWrapper)this.meta.getArrayWrapper().clone();
        this.meta.deleteColumn(column);
        Object[] rows = new Object[this.count()];
        this.memoryCache.getBatch(0, rows, 0, rows.length);
        WrapableArray[] arries = new WrapableArray[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            arries[i] = ((Row)rows[i]).values;
        }
        oldWrapper.wrap(new WrapableArray(rows)).batchRemove(arries, column);
    }

    @Override
    public int addRow(int rowIndex, Row row) throws RowsException {
        if (rowIndex == -1) {
            rowIndex = this.count();
        }
        try {
            this.memoryCache.add(rowIndex, (Object)row);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowIndex;
    }

    @Override
    public int count() throws RowsException {
        return this.memoryCache == null ? this.fileCache.size() : this.memoryCache.size();
    }

    @Override
    public void deleteRow(int row) throws RowsException {
        this.memoryCache.remove(row);
    }

    @Override
    public void deleteRows(int rowFrom, int len) throws RowsException {
        this.memoryCache.removeBatch(rowFrom, len);
    }

    @Override
    public Row getRow(int row) throws RowsException {
        Row rowObj = (Row)this.memoryCache.get(row);
        if (rowObj == PlaceholderRow.instance) {
            // empty if block
        }
        return rowObj;
    }

    @Override
    public void destroy() throws RowsException {
        if (this.fileCache != null) {
            this.fileCache.destroy();
            this.fileCache = null;
        }
        if (this.memoryCache != null) {
            this.memoryCache.clear();
            this.memoryCache = null;
        }
    }

    private void printList(BasicList list) {
        System.out.println("\r\n" + list);
        if (list != null) {
            for (int j = 0; j < list.size(); ++j) {
                System.out.println("[index " + j + "]   " + list.get(j));
            }
        }
    }
}

