/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.database;

import com.kingdee.bos.ctrl.etl.database.BaseDatabaseMeta;
import com.kingdee.bos.ctrl.etl.database.DatabaseInterface;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.Value;

public class KSQLDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public KSQLDatabaseMeta(String name, String access, String host, String db, int port, String user, String pass) {
        super(name, access, host, db, port, user, pass);
    }

    public KSQLDatabaseMeta() {
    }

    @Override
    public int getDatabaseType() {
        return 64;
    }

    @Override
    public String getDatabaseTypeDesc() {
        return "CONTEXT";
    }

    @Override
    public String getDatabaseTypeDescLong() {
        return "CONTEXT";
    }

    @Override
    public String getFieldDefinition(Value v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATETIME";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval = retval + "BIGINT PRIMARY KEY IDENTITY(0,1)";
                        break;
                    }
                    retval = retval + "BIGINT PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 18) {
                        retval = retval + "DECIMAL(" + length + ",0)";
                        break;
                    }
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    retval = retval + "INT";
                    break;
                }
                if (precision > 0) {
                    if (length <= 0) break;
                    retval = retval + "DECIMAL(" + length + "," + precision + ")";
                    break;
                }
                retval = retval + "FLOAT(53)";
                break;
            }
            case 2: {
                if (length < 8000) {
                    if (length > 0) {
                        retval = retval + "VARCHAR(" + length + ")";
                        break;
                    }
                    retval = retval + "VARCHAR(100)";
                    break;
                }
                retval = retval + "TEXT";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public int[] getAccessTypeList() {
        return null;
    }

    @Override
    public String getDriverClass() {
        return null;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public String getAddColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }
}

