/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.repository;

import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.repository.RepositoryMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RepositoriesMeta {
    private LogWriter log;
    private ArrayList databases;
    private ArrayList repositories;

    public RepositoriesMeta(LogWriter log) {
        this.log = log;
        this.clear();
    }

    public void clear() {
        this.databases = new ArrayList();
        this.repositories = new ArrayList();
    }

    public void addDatabase(DatabaseMeta ci) {
        this.databases.add(ci);
    }

    public void addRepository(RepositoryMeta ri) {
        this.repositories.add(ri);
    }

    public void addDatabase(int p, DatabaseMeta ci) {
        this.databases.add(p, ci);
    }

    public void addRepository(int p, RepositoryMeta ri) {
        this.repositories.add(p, ri);
    }

    public DatabaseMeta getDatabase(int i) {
        return (DatabaseMeta)this.databases.get(i);
    }

    public RepositoryMeta getRepository(int i) {
        return (RepositoryMeta)this.repositories.get(i);
    }

    public void removeDatabase(int i) {
        if (i < 0 || i >= this.databases.size()) {
            return;
        }
        this.databases.remove(i);
    }

    public void removeRepository(int i) {
        if (i < 0 || i >= this.repositories.size()) {
            return;
        }
        this.repositories.remove(i);
    }

    public int nrDatabases() {
        return this.databases.size();
    }

    public int nrRepositories() {
        return this.repositories.size();
    }

    public DatabaseMeta searchDatabase(String name) {
        for (int i = 0; i < this.nrDatabases(); ++i) {
            if (!this.getDatabase(i).getName().equalsIgnoreCase(name)) continue;
            return this.getDatabase(i);
        }
        return null;
    }

    public RepositoryMeta searchRepository(String name) {
        for (int i = 0; i < this.nrRepositories(); ++i) {
            if (!this.getRepository(i).getName().equalsIgnoreCase(name)) continue;
            return this.getRepository(i);
        }
        return null;
    }

    public int indexOfDatabase(DatabaseMeta di) {
        return this.databases.indexOf(di);
    }

    public int indexOfRepository(RepositoryMeta ri) {
        return this.repositories.indexOf(ri);
    }

    public RepositoryMeta findRepository(String name) {
        for (int i = 0; i < this.nrRepositories(); ++i) {
            RepositoryMeta ri = this.getRepository(i);
            if (!ri.getName().equalsIgnoreCase(name)) continue;
            return ri;
        }
        return null;
    }

    public boolean readData() {
        File file = new File(FilenameUtils.normalize((String)Const.getETLLocalRepositoriesFile()));
        if (!file.exists() || !file.isFile()) {
            this.log.logDetailed(this.toString(), "No repositories file found in the local directory: " + file.getAbsolutePath());
            file = new File(FilenameUtils.normalize((String)Const.getETLUserRepositoriesFile()));
        }
        this.log.logBasic(this.toString(), "Reading repositories XML file: " + file.getAbsoluteFile());
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                doc = db.parse(file);
            }
            catch (FileNotFoundException ef) {
                InputStream is = this.getClass().getResourceAsStream("/be/ibridge/kettle/repository/repositories.xml");
                if (is != null) {
                    doc = db.parse(is);
                }
                this.log.logError(this.toString(), "Error opening file: " + file.getAbsoluteFile() + " : " + ef.toString());
                return false;
            }
            this.clear();
            Node repsnode = XMLHandler.getSubNode(doc, "repositories");
            int nrconn = XMLHandler.countNodes(repsnode, "connection");
            this.log.logDebug(this.toString(), "We have " + nrconn + " connections...");
            for (int i = 0; i < nrconn; ++i) {
                this.log.logDebug(this.toString(), "Looking at connection #" + i);
                Node dbnode = XMLHandler.getSubNodeByNr(repsnode, "connection", i);
                DatabaseMeta dbcon = new DatabaseMeta(dbnode);
                this.addDatabase(dbcon);
                this.log.logDebug(this.toString(), "Read connection : " + dbcon.getName());
            }
            int nrreps = XMLHandler.countNodes(repsnode, "repository");
            this.log.logDebug(this.toString(), "We have " + nrreps + " repositories...");
            for (int i = 0; i < nrreps; ++i) {
                Node repnode = XMLHandler.getSubNodeByNr(repsnode, "repository", i);
                this.log.logDebug(this.toString(), "Looking at repository #" + i);
                RepositoryMeta repinfo = new RepositoryMeta();
                if (!repinfo.loadXML(repnode, this.databases)) continue;
                this.addRepository(repinfo);
                this.log.logDebug(this.toString(), "Read repository : " + repinfo.getName());
            }
        }
        catch (Exception e) {
            this.log.logError(this.toString(), "Error reading information from file : " + e.toString());
            e.printStackTrace();
            this.clear();
            return false;
        }
        return true;
    }

    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + Const.CR;
        retval = retval + "<repositories>" + Const.CR;
        for (i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta conn = this.getDatabase(i);
            retval = retval + conn.getXML();
        }
        for (i = 0; i < this.nrRepositories(); ++i) {
            RepositoryMeta ri = this.getRepository(i);
            retval = retval + ri.getXML();
        }
        retval = retval + "  </repositories>" + Const.CR;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean writeData() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(FilenameUtils.normalize((String)Const.getETLUserRepositoriesFile())));
            fos.write(this.getXML().getBytes());
        }
        catch (FileNotFoundException e) {
            this.log.logError("Repository", "Writing repository we got error : " + e.toString());
            boolean bl = false;
            CloseUtil.close((Closeable[])new Closeable[]{fos});
            return bl;
        }
        catch (IOException ie) {
            this.log.logError("Repository", "Writing repository we got IO error : " + ie.toString());
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{fos});
                    throw throwable;
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{fos});
            return bl;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fos});
        return true;
    }

    public String toString() {
        return "ETL";
    }
}

