/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule.entry.cron;

import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLScheduleException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryBase;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryInterface;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.CronExpression;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.CronExpressionUtil;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.quartz.ETLScheduler;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.quartz.ETLSchedulerFactory;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import org.quartz.SchedulerException;
import org.w3c.dom.Node;

public class ScheduleEntryCron
extends ScheduleEntryBase
implements ScheduleEntryInterface {
    private String cronExpression = "";
    private ETLScheduler etlSchedule = null;

    @Override
    public void execute(Repository rep) throws ETLScheduleException {
        CronExpression en = CronExpressionUtil.parseSchedule(this.cronExpression);
        if (en != null) {
            String realCron = en.getRealCronString();
            this.etlSchedule = ETLSchedulerFactory.createETLScheduler(this.getJob(), realCron, this.getName());
            this.etlSchedule.run();
        }
    }

    @Override
    public void stop() throws ETLScheduleException {
        try {
            if (this.etlSchedule != null) {
                this.etlSchedule.destroy();
            }
        }
        catch (SchedulerException e) {
            throw new ETLScheduleException("unable to step schedule.", e);
        }
    }

    @Override
    public void loadXML(Node entryNode, Connection ctxConnection, Job job, String scheduleName) throws ETLXMLException {
        try {
            super.loadXML(entryNode, ctxConnection, job, scheduleName);
            this.cronExpression = XMLHandler.getTagValue(entryNode, "cronexpression");
        }
        catch (ETLException e) {
            throw new ETLXMLException("Unable to load SQL job entry from XML node", e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_schedule, Job job) throws ETLException {
        try {
            super.loadRep(rep, id_schedule, job);
            this.cronExpression = rep.getScheduleAttributeString(id_schedule, "cronExpression");
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("unable to load schedule entry of type cron to the repository with id_schedule_entry=" + id_schedule, dbe);
        }
    }

    @Override
    public String getScheduleExpression() {
        return this.cronExpression;
    }
}

