/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule.ui;

import com.kingdee.bos.ctrl.etl.schedule.entry.cron.CronExpression;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.CronExpressionUtil;
import com.kingdee.bos.ctrl.etl.schedule.ui.AbstractEveryDay;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.awt.Component;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EveryDay
extends AbstractEveryDay {
    private static final long serialVersionUID = 1L;
    public static final String EVERYDAY = "everyday";
    public static final String EVERYWORKINGDAY = "everyworkingday";
    public static final String RANGE = "range";

    public EveryDay() throws Exception {
        this.initializeUI();
    }

    public String getSchedule() {
        String returnValue = "";
        Date beginTime = (Date)this.beginTimekDTimePicker.getValue();
        GregorianCalendar beginTimeC = new GregorianCalendar();
        beginTimeC.setTime(beginTime);
        returnValue = returnValue + String.valueOf(beginTimeC.get(13));
        returnValue = returnValue + " " + String.valueOf(beginTimeC.get(12));
        returnValue = returnValue + " " + String.valueOf(beginTimeC.get(11));
        if (this.everyDaykDRadioButton.isSelected()) {
            returnValue = returnValue + " *";
            returnValue = returnValue + " *";
            returnValue = returnValue + " ?";
        } else if (this.everyWorkingDaykDRadioButton.isSelected()) {
            returnValue = returnValue + " ?";
            returnValue = returnValue + " *";
            returnValue = returnValue + " 2-6";
        } else if (this.rangekDRadioButton.isSelected()) {
            returnValue = returnValue + " 1/" + String.valueOf((Integer)this.rangekDSpinner.getValue());
            returnValue = returnValue + " *";
            returnValue = returnValue + " ?";
        }
        return returnValue;
    }

    public void setSchedule(String value, boolean readOnly) {
        CronExpression se = CronExpressionUtil.parseSchedule(value);
        if (se != null) {
            this.beginTimekDTimePicker.setValue((Object)se.getBeginTime());
            String dayofmonth = se.getDayofmonth();
            if (dayofmonth.equalsIgnoreCase("*")) {
                this.everyDaykDRadioButton.setSelected(true);
            } else if (dayofmonth.equalsIgnoreCase("?")) {
                this.everyWorkingDaykDRadioButton.setSelected(true);
            } else {
                this.rangekDRadioButton.setSelected(true);
                String dayRange = dayofmonth.substring(se.getDayofmonth().indexOf("/") + 1);
                this.rangekDSpinner.setValue((Object)Integer.valueOf(dayRange));
            }
        }
        this.setEnable(!readOnly);
    }

    private void setEnable(boolean enable) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i <= componentArray.length - 1; ++i) {
            Component destComponent = componentArray[i];
            if (destComponent instanceof KDLabel) continue;
            destComponent.setEnabled(enable);
        }
    }

    private void initializeUI() {
        this.everyDaykDRadioButton.setSelected(true);
        this.setEveryDayState();
        this.setEveryWorkingDayState();
        this.setRangeState();
        this.rangekDSpinner.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 365, 1));
        this.rangekDSpinner.setEditable(false);
        this.everyDaykDRadioButton.addChangeListener((ChangeListener)new CommonChangeListener());
        this.everyWorkingDaykDRadioButton.addChangeListener((ChangeListener)new CommonChangeListener());
        this.rangekDRadioButton.addChangeListener((ChangeListener)new CommonChangeListener());
    }

    private void setEveryDayState() {
    }

    private void setEveryWorkingDayState() {
    }

    private void setRangeState() {
        this.rangekDSpinner.setEnabled(this.rangekDRadioButton.isSelected());
    }

    private class CommonChangeListener
    implements ChangeListener {
        private CommonChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                String tempRBAC = ((KDRadioButton)e.getSource()).getActionCommand();
                if (EveryDay.EVERYDAY.equalsIgnoreCase(tempRBAC)) {
                    EveryDay.this.setEveryDayState();
                }
                if (EveryDay.EVERYWORKINGDAY.equalsIgnoreCase(tempRBAC)) {
                    EveryDay.this.setEveryWorkingDayState();
                }
                if (EveryDay.RANGE.equalsIgnoreCase(tempRBAC)) {
                    EveryDay.this.setRangeState();
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }
}

