/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.server;

import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.server.Server;
import com.kingdee.bos.ctrl.etl.server.ServerMeta;
import com.kingdee.bos.ctrl.etl.transformation.StepLoader;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import java.io.File;
import java.sql.Connection;

public class ServerFactory {
    private static final String DEFAULT_LOG_FILENAME = "w:" + File.separator + "etlServer.log";
    private static final int DEFAULT_LOG_LEVEL = 4;

    public static Server createServer(String configFilename, String logFilename, int logLevel, Connection ctxConnection) throws ETLException {
        if (ctxConnection == null) {
            return null;
        }
        LogWriter log = LogWriter.getInstance(logFilename, true, logLevel);
        StepLoader stloader = StepLoader.getInstance();
        if (!stloader.read()) {
            throw new ETLException("Error loading ETL steps & plugins..");
        }
        ServerMeta sm = new ServerMeta(log, configFilename, ctxConnection);
        Server server = new Server(sm);
        return server;
    }

    public static Server createServer(Connection ctxConnection) throws ETLException {
        if (ctxConnection == null) {
            return null;
        }
        LogWriter log = LogWriter.getInstance(DEFAULT_LOG_FILENAME, true, 4);
        StepLoader stloader = StepLoader.getInstance();
        if (!stloader.read()) {
            throw new ETLException("Error loading ETL steps & plugins..");
        }
        ServerMeta sm = new ServerMeta(log, ctxConnection);
        Server server = new Server(sm);
        return server;
    }
}

