/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.server.config;

import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.schedule.Schedule;
import com.kingdee.bos.ctrl.etl.server.config.ServerConfigCopy;
import com.kingdee.bos.ctrl.etl.server.config.ServerConfigInterface;
import com.kingdee.bos.ctrl.etl.server.config.rep.ServerConfigRep;
import com.kingdee.bos.ctrl.etl.server.config.xml.ServerConfigXml;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class ServerConfigBase {
    private int type = 0;
    private ArrayList scheduleList = null;
    private ArrayList jobList = null;

    public static final ServerConfigInterface newServerConfigInterface(int type) throws ETLException {
        ServerConfigBase sci = null;
        switch (type) {
            case 1: {
                sci = new ServerConfigRep();
                break;
            }
            case 2: {
                sci = new ServerConfigXml();
                break;
            }
            default: {
                throw new ETLException("Unknown server config type : " + type);
            }
        }
        return sci;
    }

    public void loadXML(Node entrynode, List databases) throws ETLXMLException {
        try {
            String stype = XMLHandler.getTagValue(entrynode, "type");
            this.setType(ServerConfigCopy.getType(stype));
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load base info for job entry", e);
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public List getSchedules() {
        return this.scheduleList;
    }

    public List getJobs() {
        return this.jobList;
    }

    public void updateSchedule(Schedule schedule) {
        if (schedule == null) {
            return;
        }
        this.removeSchedule(schedule.getName());
        this.addSchedule(schedule);
    }

    public void updateJob(Job job) {
        if (job == null) {
            return;
        }
        this.removeJob(job.getJobname());
        this.addJob(job);
    }

    public void removeSchedule(String scheduleName) {
        if (this.scheduleList != null) {
            Iterator it = this.scheduleList.iterator();
            while (it.hasNext()) {
                Schedule s = (Schedule)it.next();
                if (!s.getName().equalsIgnoreCase(scheduleName)) continue;
                it.remove();
            }
        }
    }

    public void removeJob(String jobName) {
        if (this.jobList != null) {
            Iterator it = this.jobList.iterator();
            while (it.hasNext()) {
                Job s = (Job)it.next();
                if (!s.getJobname().equalsIgnoreCase(jobName)) continue;
                it.remove();
            }
        }
    }

    protected void addSchedule(Schedule schedule) {
        if (schedule == null) {
            return;
        }
        if (this.scheduleList == null) {
            this.scheduleList = new ArrayList();
        }
        this.scheduleList.add(schedule);
    }

    protected Job findJob(long id_job) {
        if (this.jobList != null) {
            for (Job job : this.jobList) {
                if (job.getID() != id_job) continue;
                return job;
            }
        }
        return null;
    }

    protected void addJob(Job job) {
        if (job == null) {
            return;
        }
        if (this.jobList == null) {
            this.jobList = new ArrayList();
        }
        this.jobList.add(job);
    }
}

