/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.normaliser;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.normaliser.NormaliserData;
import com.kingdee.bos.ctrl.etl.transformation.step.normaliser.NormaliserMeta;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;

public class Normaliser
extends BaseStep
implements StepInterface {
    private NormaliserMeta meta;
    private NormaliserData data;

    public Normaliser(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (NormaliserMeta)smi;
        this.data = (NormaliserData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.data.type_occ = new ArrayList();
            this.data.maxlen = 0;
            for (i = 0; i < this.meta.getFieldValue().length; ++i) {
                boolean found = false;
                for (int j = 0; j < this.data.type_occ.size(); ++j) {
                    if (!((String)this.data.type_occ.get(j)).equalsIgnoreCase(this.meta.getFieldValue()[i])) continue;
                    found = true;
                }
                if (!found) {
                    this.data.type_occ.add(this.meta.getFieldValue()[i]);
                }
                if (this.meta.getFieldValue()[i].length() <= this.data.maxlen) continue;
                this.data.maxlen = this.meta.getFieldValue()[i].length();
            }
            this.data.copy_fieldnrs = new ArrayList();
            for (i = 0; i < r.size(); ++i) {
                Value v = r.getValue(i);
                boolean found = false;
                for (int j = 0; j < this.meta.getFieldName().length && !found; ++j) {
                    if (!v.getName().equalsIgnoreCase(this.meta.getFieldName()[j])) continue;
                    found = true;
                }
                if (found) continue;
                this.data.copy_fieldnrs.add(new Integer(i));
            }
            this.data.fieldnrs = new int[this.meta.getFieldName().length];
            for (i = 0; i < this.meta.getFieldName().length; ++i) {
                this.data.fieldnrs[i] = r.searchValueIndex(this.meta.getFieldName()[i]);
                if (this.data.fieldnrs[i] >= 0) continue;
                this.logError("Couldn't find field [" + this.meta.getFieldName()[i] + " in row!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        for (int e = 0; e < this.data.type_occ.size(); ++e) {
            Value v;
            String typevalue = (String)this.data.type_occ.get(e);
            Row newrow = new Row();
            for (int i = 0; i < this.data.copy_fieldnrs.size(); ++i) {
                int nr = (Integer)this.data.copy_fieldnrs.get(i);
                v = r.getValue(nr);
                newrow.addValue(new Value(v));
            }
            Value typefield_value = new Value(this.meta.getTypeField(), typevalue);
            typefield_value.setLength(this.data.maxlen);
            newrow.addValue(typefield_value);
            for (int i = 0; i < this.data.fieldnrs.length; ++i) {
                v = r.getValue(this.data.fieldnrs[i]);
                if (!this.meta.getFieldValue()[i].equalsIgnoreCase(typevalue)) continue;
                v.setName(this.meta.getFieldNorm()[i]);
                newrow.addValue(v);
            }
            this.putRow(newrow);
        }
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (NormaliserMeta)smi;
        this.data = (NormaliserData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

