/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.normaliser;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.normaliser.Normaliser;
import com.kingdee.bos.ctrl.etl.transformation.step.normaliser.NormaliserData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class NormaliserMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String typeField;
    private String[] fieldName;
    private String[] fieldValue;
    private String[] fieldNorm;

    public String getTypeField() {
        return this.typeField;
    }

    public void setTypeField(String typeField) {
        this.typeField = typeField;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String[] fieldValue) {
        this.fieldValue = fieldValue;
    }

    public String[] getFieldNorm() {
        return this.fieldNorm;
    }

    public void setFieldNorm(String[] fieldNorm) {
        this.fieldNorm = fieldNorm;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldValue = new String[nrfields];
        this.fieldNorm = new String[nrfields];
    }

    @Override
    public Object clone() {
        NormaliserMeta retval = (NormaliserMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldValue[i] = this.fieldValue[i];
            retval.fieldNorm[i] = this.fieldNorm[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            this.typeField = XMLHandler.getTagValue(stepnode, "typefield");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.fieldName[i] = XMLHandler.getTagValue(fnode, "name");
                this.fieldValue[i] = XMLHandler.getTagValue(fnode, "value");
                this.fieldNorm[i] = XMLHandler.getTagValue(fnode, "norm");
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.typeField = "typefield";
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldValue[i] = "value" + i;
            this.fieldNorm[i] = "value" + i;
        }
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row;
        if (r == null) {
            row = new Row();
        } else {
            int j;
            int i;
            row = r;
            ArrayList<String> norm_occ = new ArrayList<String>();
            ArrayList<String> field_occ = new ArrayList<String>();
            int maxlen = 0;
            for (i = 0; i < this.fieldNorm.length; ++i) {
                boolean found = false;
                for (j = 0; j < norm_occ.size(); ++j) {
                    if (!((String)norm_occ.get(j)).equalsIgnoreCase(this.fieldNorm[i])) continue;
                    found = true;
                }
                if (!found) {
                    norm_occ.add(this.fieldNorm[i]);
                    field_occ.add(this.fieldName[i]);
                }
                if (this.fieldValue[i].length() <= maxlen) continue;
                maxlen = this.fieldValue[i].length();
            }
            int rowsize = r.size();
            for (i = 0; i < rowsize; ++i) {
                Value v = r.getValue(i);
                boolean found = false;
                for (j = 0; j < this.fieldName.length; ++j) {
                    if (!v.getName().equalsIgnoreCase(this.fieldName[j])) continue;
                    found = true;
                }
                if (found) continue;
                row.addValue(v);
            }
            Value typefield_value = new Value(this.typeField, 2);
            typefield_value.setOrigin(name);
            typefield_value.setLength(maxlen);
            row.addValue(typefield_value);
            for (i = 0; i < norm_occ.size(); ++i) {
                String normname = (String)norm_occ.get(i);
                String fieldname = (String)field_occ.get(i);
                Value v = r.searchValue(fieldname);
                v.setName(normname);
                v.setOrigin(name);
                row.addValue(v);
            }
            for (i = 0; i < rowsize; ++i) {
                row.removeValue(0);
            }
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "   " + XMLHandler.addTagValue("typefield", this.typeField);
        retval = retval + "    <fields>";
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval = retval + "      <field>";
            retval = retval + "        " + XMLHandler.addTagValue("name", this.fieldName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("value", this.fieldValue[i]);
            retval = retval + "        " + XMLHandler.addTagValue("norm", this.fieldNorm[i]);
            retval = retval + "        </field>";
        }
        retval = retval + "      </fields>";
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            this.typeField = rep.getStepAttributeString(id_step, "typefield");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldValue[i] = rep.getStepAttributeString(id_step, i, "field_value");
                this.fieldNorm[i] = rep.getStepAttributeString(id_step, i, "field_norm");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "typefield", this.typeField);
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_value", this.fieldValue[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_norm", this.fieldNorm[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        String error_message = "";
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepinfo);
            remarks.add(cr);
            boolean first = true;
            error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                String lufield = this.fieldName[i];
                Value v = prev.searchValue(lufield);
                if (v != null) continue;
                if (first) {
                    first = false;
                    error_message = error_message + "Fields to normalise, not found in input stream:" + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + lufield + Const.CR;
            }
            cr = error_found ? new CheckResult(4, error_message, stepinfo) : new CheckResult(1, "All fields to normalise are found in the input stream.", stepinfo);
            remarks.add(cr);
        } else {
            error_message = "Couldn't read fields from the previous step." + Const.CR;
            cr = new CheckResult(4, error_message, stepinfo);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Normaliser(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new NormaliserData();
    }
}

