/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.nullif;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.nullif.NullIfData;
import com.kingdee.bos.ctrl.etl.transformation.step.nullif.NullIfMeta;
import com.kingdee.bos.ctrl.etl.value.Value;

public class NullIf
extends BaseStep
implements StepInterface {
    private NullIfMeta meta;
    private NullIfData data;

    public NullIf(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        int i;
        this.meta = (NullIfMeta)smi;
        this.data = (NullIfData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.logRowlevel("Convert field values to NULL for row: " + r);
        if (this.first) {
            this.first = false;
            this.data.keynr = new int[this.meta.getFieldValue().length];
            this.data.nullValue = new Value[this.meta.getFieldValue().length];
            for (i = 0; i < this.meta.getFieldValue().length; ++i) {
                this.data.keynr[i] = r.searchValueIndex(this.meta.getFieldName()[i]);
                if (this.data.keynr[i] < 0) {
                    this.logError("Couldn't find field '" + this.meta.getFieldValue()[i] + "' in row!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.data.nullValue[i] = new Value(this.meta.getFieldName()[i], this.meta.getFieldValue()[i]);
                this.data.nullValue[i].setType(r.getValue(this.data.keynr[i]).getType());
            }
        }
        for (i = 0; i < this.meta.getFieldValue().length; ++i) {
            Value field = r.getValue(this.data.keynr[i]);
            if (field == null || !field.equals(this.data.nullValue[i])) continue;
            field.setNull();
        }
        this.putRow(r);
        return true;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (NullIfMeta)smi;
        this.data = (NullIfData)sdi;
        super.dispose(smi, sdi);
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (NullIfMeta)smi;
        this.data = (NullIfData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

