/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.sortrows;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLFileException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.sortrows.SortRowsData;
import com.kingdee.bos.ctrl.etl.transformation.step.sortrows.SortRowsMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;

public class SortRows
extends BaseStep
implements StepInterface {
    private SortRowsMeta meta = (SortRowsMeta)this.getStepMeta().getStepMetaInterface();
    private SortRowsData data;

    public SortRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (SortRowsData)stepDataInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addBuffer(Row r) {
        block7: {
            if (r != null) {
                this.data.buffer.add(r);
            }
            if (this.data.files.size() == 0 && r == null) {
                this.quickSort(this.data.buffer);
            }
            if (this.data.buffer.size() != 5000 && (this.data.files.size() <= 0 || r != null || this.data.buffer.size() <= 0)) break block7;
            this.quickSort(this.data.buffer);
            FileOutputStream fos = null;
            DataOutputStream dos = null;
            try {
                File fil = File.createTempFile(this.meta.getPrefix(), ".tmp", new File(FilenameUtils.normalize((String)Const.replEnv(this.meta.getDirectory()))));
                fil.deleteOnExit();
                this.data.files.add(fil);
                fos = new FileOutputStream(fil);
                dos = new DataOutputStream(fos);
                dos.writeInt(this.data.buffer.size());
                for (int p = 0; p < this.data.buffer.size(); ++p) {
                    ((Row)this.data.buffer.get(p)).write(dos);
                }
            }
            catch (Exception e) {
                boolean bl;
                try {
                    this.logError("Error processing temp-file: " + e.toString());
                    bl = false;
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{dos, fos});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{dos, fos});
                return bl;
            }
            CloseUtil.close((Closeable[])new Closeable[]{dos, fos});
            this.data.buffer.removeAllElements();
        }
        return true;
    }

    private Row getBuffer() {
        Row retval;
        DataInputStream di;
        int f;
        this.debug = "start";
        if (this.data.files.size() > 0 && (this.data.dis.size() == 0 || this.data.fis.size() == 0)) {
            this.debug = "initialize";
            this.logBasic("Opening " + this.data.files.size() + " tmp-files...");
            try {
                for (f = 0; f < this.data.files.size(); ++f) {
                    String filename = ((File)this.data.files.get(f)).toString();
                    this.debug = "opening file " + filename;
                    this.logDetailed("Opening tmp-file: [" + filename + "]");
                    FileInputStream fi = new FileInputStream((File)this.data.files.get(f));
                    di = new DataInputStream(fi);
                    this.data.fis.add(fi);
                    this.data.dis.add(di);
                    int buffersize = di.readInt();
                    this.debug = "buffersize = " + buffersize;
                    this.logDetailed("[" + filename + "] expecting " + buffersize + " rows...");
                    if (buffersize <= 0) continue;
                    this.data.rowbuffer.add(new Row(di));
                }
            }
            catch (Exception e) {
                this.logError("Error reading back tmp-files in step [" + this.debug + "] : " + e.toString());
            }
        }
        if (this.data.files.size() == 0) {
            if (this.data.buffer.size() > 0) {
                retval = (Row)this.data.buffer.get(0);
                this.data.buffer.remove(0);
            } else {
                retval = null;
            }
        } else if (this.data.rowbuffer.size() == 0) {
            retval = null;
        } else {
            for (int i = 0; i < this.data.rowbuffer.size(); ++i) {
                Row b = (Row)this.data.rowbuffer.get(i);
                this.logRowlevel("--BR#" + i + ": " + b.toString());
            }
            int smallest = 0;
            Row r1 = (Row)this.data.rowbuffer.get(smallest);
            for (f = 1; f < this.data.rowbuffer.size(); ++f) {
                Row r2 = (Row)this.data.rowbuffer.get(f);
                if (r2 == null || r2.compare(r1, this.data.fieldnrs, this.meta.getAscending()) >= 0) continue;
                smallest = f;
                r1 = (Row)this.data.rowbuffer.get(smallest);
            }
            retval = r1;
            this.data.rowbuffer.remove(smallest);
            this.logRowlevel("Smallest row selected on [" + smallest + "] : " + retval);
            File file = (File)this.data.files.get(smallest);
            di = (DataInputStream)this.data.dis.get(smallest);
            FileInputStream fi = (FileInputStream)this.data.fis.get(smallest);
            try {
                this.data.rowbuffer.add(smallest, new Row(di));
            }
            catch (ETLFileException fe) {
                try {
                    di.close();
                    fi.close();
                    file.delete();
                }
                catch (IOException e) {
                    this.logError("Unable to close/delete file #" + smallest + " --> " + file.toString());
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
                this.data.files.remove(smallest);
                this.data.dis.remove(smallest);
                this.data.fis.remove(smallest);
            }
        }
        return retval;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        Row r = null;
        boolean err = true;
        r = this.getRow();
        if (this.first && r != null) {
            this.first = false;
            this.data.fieldnrs = new int[this.meta.getFieldName().length];
            for (int i = 0; i < this.meta.getFieldName().length; ++i) {
                this.data.fieldnrs[i] = r.searchValueIndex(this.meta.getFieldName()[i]);
                if (this.data.fieldnrs[i] >= 0) continue;
                this.logError("Sort field [" + this.meta.getFieldName()[i] + "] not found!");
                this.setOutputDone();
                return false;
            }
        }
        if (!(err = this.addBuffer(r))) {
            this.setOutputDone();
            return false;
        }
        if (r == null) {
            r = this.getBuffer();
            while (r != null) {
                this.logRowlevel("Read row: " + r.toString());
                this.putRow(r);
                r = this.getBuffer();
            }
            this.setOutputDone();
            return false;
        }
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("Linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SortRowsMeta)smi;
        this.data = (SortRowsData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }

    public synchronized void quickSort(Vector elements) {
        this.logDetailed("Starting quickSort algorithm...");
        if (!elements.isEmpty()) {
            this.quickSort(elements, 0, elements.size() - 1);
        }
        this.logDetailed("QuickSort algorithm has finished.");
    }

    private synchronized void quickSort(Vector elements, int lowIndex, int highIndex) {
        int lowToHighIndex = lowIndex;
        int highToLowIndex = highIndex;
        int pivotIndex = (lowToHighIndex + highToLowIndex) / 2;
        Row pivotValue = (Row)elements.elementAt(pivotIndex);
        int newLowIndex = highIndex + 1;
        int newHighIndex = lowIndex - 1;
        while (newHighIndex + 1 < newLowIndex) {
            int compareResult;
            Row lowToHighValue = (Row)elements.elementAt(lowToHighIndex);
            while (lowToHighIndex < newLowIndex & lowToHighValue.compare(pivotValue, this.data.fieldnrs, this.meta.getAscending()) < 0) {
                newHighIndex = lowToHighIndex++;
                lowToHighValue = (Row)elements.elementAt(lowToHighIndex);
            }
            Row highToLowValue = (Row)elements.elementAt(highToLowIndex);
            while (newHighIndex <= highToLowIndex & highToLowValue.compare(pivotValue, this.data.fieldnrs, this.meta.getAscending()) > 0) {
                newLowIndex = highToLowIndex--;
                highToLowValue = (Row)elements.elementAt(highToLowIndex);
            }
            if (lowToHighIndex == highToLowIndex) {
                newHighIndex = lowToHighIndex;
                continue;
            }
            if (lowToHighIndex >= highToLowIndex || (compareResult = lowToHighValue.compare(highToLowValue, this.data.fieldnrs, this.meta.getAscending())) < 0) continue;
            Row parking = lowToHighValue;
            elements.setElementAt(highToLowValue, lowToHighIndex);
            elements.setElementAt(parking, highToLowIndex);
            newLowIndex = highToLowIndex--;
            newHighIndex = lowToHighIndex++;
        }
        if (lowIndex < newHighIndex) {
            this.quickSort(elements, lowIndex, newHighIndex);
        }
        if (newLowIndex < highIndex) {
            this.quickSort(elements, newLowIndex, highIndex);
        }
    }
}

