/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.systemdata;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.systemdata.SystemData;
import com.kingdee.bos.ctrl.etl.transformation.step.systemdata.SystemDataData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class SystemDataMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final int TYPE_SYSTEM_INFO_NONE = 0;
    public static final int TYPE_SYSTEM_INFO_SYSTEM_DATE = 1;
    public static final int TYPE_SYSTEM_INFO_SYSTEM_START = 2;
    public static final int TYPE_SYSTEM_INFO_DATE_FROM = 3;
    public static final int TYPE_SYSTEM_INFO_DATE_TO = 4;
    public static final int TYPE_SYSTEM_INFO_PREV_DAY_START = 5;
    public static final int TYPE_SYSTEM_INFO_PREV_DAY_END = 6;
    public static final int TYPE_SYSTEM_INFO_THIS_DAY_START = 7;
    public static final int TYPE_SYSTEM_INFO_THIS_DAY_END = 8;
    public static final int TYPE_SYSTEM_INFO_NEXT_DAY_START = 9;
    public static final int TYPE_SYSTEM_INFO_NEXT_DAY_END = 10;
    public static final int TYPE_SYSTEM_INFO_PREV_MONTH_START = 11;
    public static final int TYPE_SYSTEM_INFO_PREV_MONTH_END = 12;
    public static final int TYPE_SYSTEM_INFO_THIS_MONTH_START = 13;
    public static final int TYPE_SYSTEM_INFO_THIS_MONTH_END = 14;
    public static final int TYPE_SYSTEM_INFO_NEXT_MONTH_START = 15;
    public static final int TYPE_SYSTEM_INFO_NEXT_MONTH_END = 16;
    public static final int TYPE_SYSTEM_INFO_COPYNR = 17;
    public static final int TYPE_SYSTEM_INFO_TRANS_NAME = 18;
    public static final int TYPE_SYSTEM_INFO_FILENAME = 19;
    public static final int TYPE_SYSTEM_INFO_MODIFIED_USER = 20;
    public static final int TYPE_SYSTEM_INFO_MODIFIED_DATE = 21;
    public static final int TYPE_SYSTEM_INFO_BATCH_ID = 22;
    public static final int TYPE_SYSTEM_INFO_HOSTNAME = 23;
    public static final int TYPE_SYSTEM_INFO_IP_ADDRESS = 24;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_01 = 25;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_02 = 26;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_03 = 27;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_04 = 28;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_05 = 29;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_06 = 30;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_07 = 31;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_08 = 32;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_09 = 33;
    public static final int TYPE_SYSTEM_INFO_ARGUMENT_10 = 34;
    public static final String[] type_desc = new String[]{"-", "system date (variable)", "system date (fixed)", "start date range", "end date range", "yesterday start", "yesterday end", "today start", "today end", "tomorrow start", "tomorrow end", "last month start", "last month end", "this month start", "this month end", "next month start", "next month end", "copy of step", "transformation name", "transformation file name", "User modified", "Date modified", "batch ID", "Hostname", "IP address", "command line argument 1", "command line argument 2", "command line argument 3", "command line argument 4", "command line argument 5", "command line argument 6", "command line argument 7", "command line argument 8", "command line argument 9", "command line argument 10"};
    public static final String[] typeLongDesc = new String[]{"-", "system date (variable)", "system date (fixed)", "start date range", "end date range", "Yesterday 00:00:00", "Yesterday 23:59:59", "Today 00:00:00", "Today 23:59:59", "Tomorrow 00:00:00", "Tomorrow 23:59:59", "First day of last month 00:00:00", "Last day of last month 23:59:59", "First day of this month 00:00:00", "Last day of this month 23:59:59", "First day of next month 00:00:00", "Last day of next month 23:59:59", "copy of step", "transformation name", "transformation file name", "User that modified the transformation last", "Date when the transformation was modified last", "transformation batch ID", "Hostname", "IP address", "command line argument 1", "command line argument 2", "command line argument 3", "command line argument 4", "command line argument 5", "command line argument 6", "command line argument 7", "command line argument 8", "command line argument 9", "command line argument 10"};
    private String[] fieldName;
    private int[] fieldType;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.fieldType = new int[count];
    }

    @Override
    public Object clone() {
        SystemDataMeta retval = (SystemDataMeta)super.clone();
        int count = this.fieldName.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldType[i] = this.fieldType[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int count = XMLHandler.countNodes(fields, "field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.fieldName[i] = XMLHandler.getTagValue(fnode, "name");
                String type = XMLHandler.getTagValue(fnode, "type");
                this.fieldType[i] = SystemDataMeta.getType(type);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to read step information from XML", e);
        }
    }

    public static final int getType(String type) {
        for (int i = 0; i < type_desc.length; ++i) {
            if (type_desc[i].equalsIgnoreCase(type)) {
                return i;
            }
            if (!typeLongDesc[i].equalsIgnoreCase(type)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int t) {
        if (t < 0 || t >= type_desc.length) {
            return null;
        }
        return type_desc[t];
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = 1;
        }
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row = r == null ? new Row() : r;
        for (int i = 0; i < this.fieldName.length; ++i) {
            Value v;
            switch (this.fieldType[i]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 21: {
                    v = new Value(this.fieldName[i], 3);
                    break;
                }
                case 17: 
                case 22: {
                    v = new Value(this.fieldName[i], 5);
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    v = new Value(this.fieldName[i], 2);
                    break;
                }
                default: {
                    v = new Value(this.fieldName[i], 0);
                }
            }
            v.setOrigin(name);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    <fields>" + Const.CR;
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval = retval + "      <field>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.fieldName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", type_desc[this.fieldType[i]]);
            retval = retval + "        </field>" + Const.CR;
        }
        retval = retval + "      </fields>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = SystemDataMeta.getType(rep.getStepAttributeString(id_step, i, "field_type"));
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", SystemDataMeta.getTypeDesc(this.fieldType[i]));
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(4, "Step is expecting nor reading info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            CheckResult cr = new CheckResult(1, "No input received from other steps.", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public Row getUsedArguments() {
        Row row = new Row();
        for (int argNr = 0; argNr < 10; ++argNr) {
            boolean found = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldType[i] != 25 + argNr) continue;
                found = true;
            }
            if (!found) continue;
            Value value = new Value("" + (argNr + 1), 2);
            row.addValue(value);
        }
        return row;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SystemData(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SystemDataData();
    }
}

