/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.tableinput;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.tableinput.TableInputData;
import com.kingdee.bos.ctrl.etl.transformation.step.tableinput.TableInputMeta;
import com.kingdee.bos.ctrl.etl.value.Value;

public class TableInput
extends BaseStep
implements StepInterface {
    private TableInputMeta meta;
    private TableInputData data;

    public TableInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized Row readStartDate() {
        this.logDetailed("Reading from step [" + this.meta.getLookupStepname() + "]");
        Row parameters = new Row();
        Row r = this.getRowFrom(this.meta.getLookupStepname());
        for (int i = 0; i < r.size(); ++i) {
            Value val = r.getValue(i);
            parameters.addValue(val);
        }
        r = this.getRowFrom(this.meta.getLookupStepname());
        return parameters;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        if (this.first) {
            Row parameters;
            this.first = false;
            if (this.meta.getInfoSteps() != null) {
                if (this.meta.isExecuteEachInputRow()) {
                    this.logDetailed("Reading single row from stream [" + this.meta.getLookupStepname() + "]");
                    parameters = this.getRowFrom(this.meta.getLookupStepname());
                    this.logDetailed("Query parameters found = " + parameters.toString());
                } else {
                    this.logDetailed("Reading query parameters from stream [" + this.meta.getLookupStepname() + "]");
                    parameters = this.readStartDate();
                    this.logDetailed("Query parameters found = " + parameters.toString());
                }
            } else {
                parameters = new Row();
            }
            boolean success = this.doQuery(parameters);
            if (!success) {
                return false;
            }
        } else if (this.data.thisrow != null) {
            this.data.nextrow = this.data.db.getRow(this.data.rs);
            if (this.data.nextrow != null) {
                ++this.linesInput;
            }
        }
        if (this.data.thisrow == null) {
            boolean done = false;
            if (this.meta.isExecuteEachInputRow()) {
                Row nextRow = this.getRowFrom(this.meta.getLookupStepname());
                if (nextRow == null) {
                    done = true;
                } else {
                    boolean success = this.doQuery(nextRow);
                    if (!success) {
                        return false;
                    }
                }
            } else {
                done = true;
            }
            if (done) {
                this.setOutputDone();
                return false;
            }
        }
        if (this.data.thisrow != null) {
            this.putRow(this.data.thisrow);
            this.data.thisrow = this.data.nextrow;
            if (this.linesInput > 0L && this.linesInput % 5000L == 0L) {
                this.logBasic("linenr " + this.linesInput);
            }
        }
        return true;
    }

    private boolean doQuery(Row parameters) throws ETLDatabaseException {
        boolean success = true;
        this.data.rs = this.data.db.openQuery(this.meta.getSQL(), parameters);
        if (this.data.rs == null) {
            this.logError("Couldn't open Query [" + this.meta.getSQL() + "]");
            this.setErrors(1L);
            this.stopAll();
            success = false;
        } else {
            this.data.thisrow = this.data.db.getRow(this.data.rs);
            if (this.data.thisrow != null) {
                ++this.linesInput;
                this.data.nextrow = this.data.db.getRow(this.data.rs);
                if (this.data.nextrow != null) {
                    ++this.linesInput;
                }
            }
        }
        return success;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.logBasic("Finished reading query, closing connection.");
        try {
            this.data.db.closeQuery(this.data.rs);
        }
        catch (ETLException e) {
            this.logError("Unexpected error closing query : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        this.data.db.disconnect();
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning() {
        try {
            if (this.data.db != null) {
                this.data.db.cancelQuery();
            }
        }
        catch (ETLDatabaseException eTLDatabaseException) {
            // empty catch block
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TableInputMeta)smi;
        this.data = (TableInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.db = new Database(this.meta.getDatabaseMeta());
            this.data.db.setQueryLimit(this.meta.getRowLimit());
            try {
                this.data.db.connect();
                this.logDetailed("Connected to database...");
                return true;
            }
            catch (ETLException e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (!this.isStopped() && this.processRow(this.meta, this.data)) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

