/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2;

import com.kingdee.bos.ctrl.common.util.ScaleUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.fd2.Location;
import com.kingdee.bos.ctrl.kdf.fd2.SerialNo;
import com.kingdee.bos.ctrl.kdf.fd2.SideLocation;
import com.kingdee.bos.ctrl.kdf.fd2.TableLocation;
import com.kingdee.bos.ctrl.kdf.fd2.data.DefaultDataManager;
import com.kingdee.bos.ctrl.kdf.fd2.data.IDataManager;
import com.kingdee.bos.ctrl.kdf.fd2.gui.FormDesigner;
import com.kingdee.bos.ctrl.kdf.fd2.gui.KDFFrame;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractGroup;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ChartElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.FieldElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.FormulaElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Group;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.HeadFooter;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ImageElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.LineElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.LoopArea;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.StaticTextElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Table;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.VariantElement;
import com.kingdee.bos.ctrl.kdf.form.Area;
import com.kingdee.bos.ctrl.kdf.form.Cell;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.form.Data;
import com.kingdee.bos.ctrl.kdf.form.EntityInfo;
import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.form.PageCollection;
import com.kingdee.bos.ctrl.kdf.form.Panel;
import com.kingdee.bos.ctrl.kdf.form.Property;
import com.kingdee.bos.ctrl.kdf.printprovider.PrintInfo;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class KDF {
    public static final float VERSION = 4.0f;
    public static final Namespace NS_FORM = Namespace.getNamespace((String)"f", (String)"http://www.kingdee.com/Form");
    private boolean modified = true;
    private String name = "";
    private ArrayList pages;
    private String filename = "";
    private String orientation = "PORTRAIT";
    private long loadTime = 0L;
    private KDFFrame reportFrame;
    private String reportFormat;
    private int dirty = 1;
    private boolean haveHeader;
    private boolean haveFooter;
    private ArrayList invalidGroups;
    private com.kingdee.bos.ctrl.kdf.util.file.KDF kdfDom;
    private IDataManager dataManager;
    private int saveWhere = 0;
    public static final int SAVE_UNSURE = 0;
    public static final int SAVE_LOCAL = 1;
    public static final int SAVE_STORAGE = 2;
    private int pureHeightLom;
    private int height = 0;
    private int width = 0;
    private int leftMargin = 0;
    private int rightMargin = 0;
    private int topMargin = 0;
    private int bottomMargin = 0;
    boolean heightLimitless = false;
    boolean widthLimitless = false;
    private SerialNo sn;
    private HashMap allElementsNameMap = new HashMap();
    private HashMap allElementsAliasNameMap = new HashMap();
    private HeadFooter header = null;
    private HeadFooter footer = null;
    private boolean isDynamicPaper;
    private boolean isEconomizePaper;

    public KDF() {
        this.kdfDom = new com.kingdee.bos.ctrl.kdf.util.file.KDF();
        this.pages = new ArrayList();
        this.sn = new SerialNo(this);
        this.setHaveHeader(false);
        this.setHaveFooter(false);
    }

    public KDF(String xmlFile) throws KDFException {
        this();
        try {
            this.kdfDom = new com.kingdee.bos.ctrl.kdf.util.file.KDF(xmlFile, true);
        }
        catch (KDFException e1) {
            e1.printStackTrace();
        }
        this.setFilename(xmlFile);
        this.load(this.kdfDom);
        this.setDirty(false);
    }

    public KDF(com.kingdee.bos.ctrl.kdf.util.file.KDF kdfDom) throws KDFException {
        this();
        this.load(kdfDom);
        this.setDirty(false);
    }

    public void load(String xmlFile) throws KDFException {
        try {
            this.kdfDom = new com.kingdee.bos.ctrl.kdf.util.file.KDF(xmlFile, true);
        }
        catch (KDFException e1) {
            e1.printStackTrace();
        }
        this.setFilename(xmlFile);
        this.load(this.kdfDom);
    }

    public void load(com.kingdee.bos.ctrl.kdf.util.file.KDF kdfDom) throws KDFException {
        this.pages = new ArrayList();
        this.kdfDom = kdfDom;
        if ("1.1".equals(kdfDom.getVersion())) {
            // empty if block
        }
        this.getDataManager().loadData(kdfDom);
        this.traverse(kdfDom);
        this.traverseLoop(kdfDom);
        this.calcAllElementPosition();
        this.endLoading();
        this.setDirty(false);
    }

    public com.kingdee.bos.ctrl.kdf.util.file.KDF getKDFDom() {
        return this.kdfDom;
    }

    private void endLoading() {
        Iterator it = this.getPages().iterator();
        while (it.hasNext()) {
            this.endLoadingLoop((Page)it.next());
        }
        this.endLoadingLoop(this.getHeader());
        this.endLoadingLoop(this.getFooter());
    }

    private void endLoadingLoop(IElement elm) {
        elm.setIsLoading(false);
        if (elm instanceof AbstractContainer) {
            for (IElement child : ((AbstractContainer)elm).getChildren()) {
                this.endLoadingLoop(child);
            }
        }
    }

    public void calcAllElementPosition() {
        for (Page page : this.pages) {
            page.firstBuildQuean();
            page.recalcAllPos();
        }
        this.header.firstBuildQuean();
        this.header.recalcAllPos();
        this.footer.firstBuildQuean();
        this.footer.recalcAllPos();
    }

    private void traverse(com.kingdee.bos.ctrl.kdf.util.file.KDF kdfdom) {
        if (!kdfdom.getForms().isEmpty()) {
            PrintInfo printinfo = kdfdom.getPrintInfo();
            this.bottomMargin = printinfo.getBottomMargin();
            this.topMargin = printinfo.getTopMargin();
            this.leftMargin = printinfo.getLeftMargin();
            this.rightMargin = printinfo.getRightMargin();
            this.orientation = printinfo.getOrientation();
            if (printinfo.isCustomizedPaperSize()) {
                this.reportFormat = "Custom";
                this.isDynamicPaper = printinfo.getCustomizePaperHeight() == -1;
            } else {
                this.reportFormat = printinfo.getNamedPaperSize();
            }
            if ("LANDSCAPE".equalsIgnoreCase(this.orientation)) {
                this.width = printinfo.getPaperHeight();
                this.height = printinfo.getPaperWidth();
            } else {
                this.height = printinfo.getPaperHeight();
                this.width = printinfo.getPaperWidth();
            }
            this.setEconomizePaper(printinfo.isEconomizePaper());
            Iterator itform = kdfdom.getForms().iterator();
            Form form = (Form)itform.next();
            if (form.getUserAlias() != null && !form.getUserAlias().equals("")) {
                this.setName(form.getUserAlias());
            }
            PageCollection pagedoms = form.getPages();
            for (com.kingdee.bos.ctrl.kdf.form.Page pagedom : pagedoms) {
                Page page = new Page(this, pagedom.getId(), 0, 0);
                page.setAliasName(pagedom.getUserAlias());
                page.setStyleAttribute(Styles.getSA((ShareStyleAttributes)pagedom.getStyles()));
                page.setField(pagedom.group().getField());
                page.setDataSource(pagedom.group().getDataSource());
                this.allElementsNameMap.put(page.getName(), page);
                this.traversePage(page, pagedom);
                this.parsePageDesignInfo(pagedom, page);
                this.addPage(page);
            }
            if (this.pages.size() > 0 && this.reportFrame != null) {
                this.reportFrame.setCurrentpage((Page)this.pages.get(0));
            }
            this.paresHeadFooter(kdfdom, form);
        }
    }

    private void traverseLoop(com.kingdee.bos.ctrl.kdf.util.file.KDF kdfdom) {
        if (!kdfdom.getForms().isEmpty()) {
            Iterator itform = kdfdom.getForms().iterator();
            Form form = (Form)itform.next();
            PageCollection pagedoms = form.getPages();
            for (com.kingdee.bos.ctrl.kdf.form.Page pagedom : pagedoms) {
                this.traverseLoop((Container)pagedom);
            }
            if (this.pages.size() > 0 && this.reportFrame != null) {
                this.reportFrame.setCurrentpage((Page)this.pages.get(0));
            }
        }
    }

    private void traverseLoop(Container ele) {
        Area kdfArea;
        if (ele instanceof Area && (kdfArea = (Area)ele).getNext() != null) {
            LoopArea area = (LoopArea)this.allElementsNameMap.get(kdfArea.getId());
            LoopArea nextArea = (LoopArea)this.allElementsNameMap.get(kdfArea.getNext().getId());
            area.setNextLoopArea(nextArea);
        }
        if (!(ele instanceof Cell)) {
            for (Container kdfobject : ele) {
                this.traverseLoop(kdfobject);
            }
        }
    }

    private void paresHeadFooter(com.kingdee.bos.ctrl.kdf.util.file.KDF kdfdom, Form form) {
        if (form.getHeaderID() == null || kdfdom.getHeader(form.getHeaderID()) == null) {
            this.setHaveHeader(false);
        } else {
            this.setHaveHeader(true);
        }
        com.kingdee.bos.ctrl.kdf.form.Page header = null;
        if (kdfdom.getHeaders().length > 0) {
            header = kdfdom.getHeaders()[0];
        }
        if (header == null) {
            this.setHeader(new HeadFooter(this, true, this.getPureWidth(), this.getPureHeight() / 3));
        } else {
            HeadFooter tempheader = new HeadFooter(this, true, 0, 0);
            tempheader.setStyleAttribute(Styles.getSA((ShareStyleAttributes)header.getStyles()));
            tempheader.setName(header.getId());
            this.parseHeaderFooterDesigner(header, tempheader);
            for (Container element : header) {
                this.traversKDFObject(tempheader, element);
            }
            this.setHeader(tempheader);
        }
        if (form.getFooterID() == null || kdfdom.getFooter(form.getFooterID()) == null) {
            this.setHaveFooter(false);
        } else {
            this.setHaveFooter(true);
        }
        com.kingdee.bos.ctrl.kdf.form.Page footer = null;
        if (kdfdom.getFooters().length > 0) {
            footer = kdfdom.getFooters()[0];
        }
        if (footer == null) {
            this.setFooter(new HeadFooter(this, false, this.getPureWidth(), this.getPureHeight() / 3));
        } else {
            HeadFooter tempfooter = new HeadFooter(this, false, 0, 0);
            tempfooter.setStyleAttribute(Styles.getSA((ShareStyleAttributes)footer.getStyles()));
            tempfooter.setName(footer.getId());
            this.parseHeaderFooterDesigner(footer, tempfooter);
            for (Container element : footer) {
                this.traversKDFObject(tempfooter, element);
            }
            this.setFooter(tempfooter);
        }
        PrintInfo pi = kdfdom.getPrintInfo();
        this.getHeader().setMargin(pi.getHeaderMargin());
        this.getFooter().setMargin(pi.getFooterMargin());
    }

    private void parsePageDesignInfo(com.kingdee.bos.ctrl.kdf.form.Page page, Page kdfpage) {
        Element pagenode = (Element)page.getUserObject();
        if (pagenode != null) {
            this.widthLimitless = Boolean.valueOf(pagenode.getAttributeValue("widthLimitless"));
            this.heightLimitless = Boolean.valueOf(pagenode.getAttributeValue("heightLimitless"));
            this.pureHeightLom = Integer.parseInt(pagenode.getAttributeValue("objHeight"));
            kdfpage.setWidthLom(this.getPureWidthLom());
            kdfpage.setHeightLom(this.getPureHeightLom());
            kdfpage.setRepeat(page.getRepeat());
        }
    }

    private void parseHeaderFooterDesigner(com.kingdee.bos.ctrl.kdf.form.Page headFooter, Page kdfHeadFooter) {
        Element pagenode = (Element)headFooter.getUserObject();
        if (pagenode != null) {
            int headfooterHeight = Integer.parseInt(pagenode.getAttributeValue("objHeight"));
            kdfHeadFooter.setWidthLom(this.getPureWidthLom());
            kdfHeadFooter.setHeightLom(headfooterHeight);
        }
    }

    private void traversePage(Page page, com.kingdee.bos.ctrl.kdf.form.Page pagedom) {
        for (Container element : pagedom) {
            this.traversKDFObject(page, element);
        }
    }

    private void traversKDFObject(IContainer container, Container ele) {
        if (ele instanceof Area) {
            Area kdfArea = (Area)ele;
            LoopArea area = new LoopArea(kdfArea.getId(), 0, 0, 0, 0);
            container.addElement(area);
            area.setParent(container);
            this.parseAreaDesignInfo(container, area, ele);
            area.setVerticalSpacing(Float.parseFloat(kdfArea.getVerticalSpacing() == null ? "0" : kdfArea.getVerticalSpacing()));
            area.setHorizontalSpacing(Float.parseFloat(kdfArea.getHorizontalSpacing() == null ? "0" : kdfArea.getHorizontalSpacing()));
            area.setMaxLoopCount(kdfArea.getMaxLoopCount());
            area.setMinLoopCount(kdfArea.getMinLoopCount());
            this.readKDFOtherProps((Container)kdfArea, area);
            for (Container kdfobject : ele) {
                this.traversKDFObject(area, kdfobject);
            }
        } else if (ele instanceof com.kingdee.bos.ctrl.kdf.form.Table) {
            com.kingdee.bos.ctrl.kdf.form.Table kdftable = (com.kingdee.bos.ctrl.kdf.form.Table)ele;
            Table table = new Table(kdftable.getId(), 0, 0, 0, 0);
            table.setParent(container);
            container.addElement(table);
            this.parseTableDesignInfo(container, table, ele);
            this.readKDFOtherProps(ele, table);
            table.setCols(kdftable.getCols());
            table.setRows(kdftable.getRows());
            table.setField(kdftable.group().getField());
            table.setDataSource(kdftable.group().getDataSource());
            for (Container kdfobject : ele) {
                this.traversKDFObject(table, kdfobject);
            }
        } else if (ele instanceof Panel) {
            Panel panel = (Panel)ele;
            Group group = new Group(panel.getId(), 0, 0, 0, 0);
            container.addElement(group);
            group.setParent(container);
            group.setField(panel.group().getField());
            group.setDataSource(panel.group().getDataSource());
            this.parseGroupDesignInfo(container, group, ele);
            this.readKDFOtherProps(ele, group);
            for (Container kdfobject : ele) {
                this.traversKDFObject(group, kdfobject);
            }
        } else if (ele instanceof Cell) {
            Cell cell = (Cell)ele;
            this.getCellFromKDF(container, cell);
        }
    }

    private void readKDFOtherProps(Container kdfdom, IElement ele) {
        ele.setName(kdfdom.getId());
        ele.setAliasName(kdfdom.getUserAlias());
        this.allElementsNameMap.put(ele.getName(), ele);
        this.allElementsAliasNameMap.put(ele.getAliasName(), ele);
        ele.setLayer(kdfdom.getLayer());
        ele.setPostSteps(kdfdom.getPostSteps());
        ele.setPreSteps(kdfdom.getPreSteps());
        ele.setPriority(kdfdom.getPriority());
        if (kdfdom.getHoldPlace() != null) {
            ele.setHoldPlace(kdfdom.getHoldPlace().getString());
        }
        if (kdfdom.getVisibility() != null) {
            ele.setVisibility(kdfdom.getVisibility().getString());
        }
        ele.setStyleAttribute(Styles.getSA((ShareStyleAttributes)kdfdom.getStyles()));
    }

    private void getCellFromKDF(IElement ele, Cell cell) {
        IContainer container = (IContainer)ele;
        ReportElement addEle = null;
        String cellType = cell.getType();
        if (cellType.equals("constant")) {
            addEle = this.parseKDFCellConstant(cell);
        } else if (cellType.equals("field") || cellType.equals("groupField") || cellType.equals("areaTotal") || cellType.equals("groupTotal")) {
            addEle = new FieldElement(cell.getId(), 0, 0, 0, 0);
            Element designedNode = (Element)cell.getUserObject();
            String text = designedNode.getAttributeValue("text");
            if (StringUtil.isEmptyString((String)text)) {
                ((FieldElement)addEle).setFieldAlias(cell.getData().getFormat());
            } else {
                ((FieldElement)addEle).setFieldAlias(text);
            }
            ((FieldElement)addEle).setFieldID(cell.getData().getFormat());
            ((FieldElement)addEle).setFormat(cell.getDataFormat());
            if (cell.getProperties().get("contentType") != null && cell.getProperties().get("contentType").getFormat().equals("image")) {
                ((FieldElement)addEle).setPhoto(true);
            }
            if (cellType.equals("field")) {
                ((FieldElement)addEle).setFieldType(0);
                this.parseScaleInfo(cell, addEle);
            } else if (cellType.equals("groupField")) {
                ((FieldElement)addEle).setFieldType(1);
            } else if (cellType.equals("groupTotal")) {
                ((FieldElement)addEle).setFieldType(2);
            } else if (cellType.equals("areaTotal")) {
                ((FieldElement)addEle).setFieldType(3);
            }
        } else if (cellType.equals("formula")) {
            addEle = new FormulaElement(cell.getId(), 0, 0, 0, 0);
            ((FormulaElement)addEle).setFormula(cell.getData().getFormat());
            ((FormulaElement)addEle).setFormat(cell.getDataFormat());
        } else if (cellType.equals("variant")) {
            addEle = new VariantElement(cell.getId(), 0, 0, 0, 0);
            ((VariantElement)addEle).setVariant(cell.getData().getFormat());
            ((VariantElement)addEle).setFormat(cell.getDataFormat());
        } else if (cellType.equals("chart")) {
            addEle = new ChartElement(cell.getId(), 0, 0, 0, 0);
            ((ChartElement)addEle).translateSavingString(this.getDataManager().getDataForBind(), cell.getData().getFormat());
        }
        if (addEle != null) {
            if ("system_background".equals(cell.getId()) && addEle instanceof ImageElement && container instanceof Page) {
                ImageElement imgEle = (ImageElement)addEle;
                Page.Backgroud backgroud = new Page.Backgroud(imgEle.getImg());
                backgroud.setOffsetX(Integer.parseInt(cell.getLeft().getOriginString()));
                backgroud.setOffsetY(Integer.parseInt(cell.getTop().getOriginString()));
                ((Page)container).setBackgroud(backgroud);
                return;
            }
            Element elenode = (Element)cell.getUserObject();
            addEle.setLocked(Boolean.valueOf(elenode.getAttributeValue("locked")));
            addEle.setParent(container);
            if (!(container instanceof Table)) {
                this.pasrseLoaction(addEle, (Container)cell);
            } else {
                this.pasrseTableCellLoaction(addEle, (Container)cell);
            }
            this.readKDFOtherProps((Container)cell, addEle);
            container.addElement(addEle);
            addEle.setDivideCharacter(cell.getDivideCharacter());
        }
    }

    private ReportElement parseKDFCellConstant(Cell cont) {
        ReportElement addEle = null;
        String type = null;
        String string = type = cont.getProperties().get("contentType") != null ? cont.getProperties().get("contentType").getFormat() : null;
        if (type == null && cont.getData() != null) {
            type = cont.getData().getType();
        }
        if (type == null || type.equalsIgnoreCase("string")) {
            addEle = new StaticTextElement(cont.getId(), 0, 0, 0, 0);
            if (cont.getData() != null) {
                addEle.setText(cont.getData().getFormat());
            } else {
                addEle.setText("");
            }
        } else if (type.equalsIgnoreCase("line")) {
            addEle = new LineElement(cont.getId(), 0, 0, 0, 0);
            try {
                int value;
                Element node = (Element)cont.getUserObject();
                String strvalue = node.getAttributeValue("direction");
                if (strvalue != null && (value = Integer.parseInt(strvalue)) == 1) {
                    ((LineElement)addEle).setDirection(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (type.equalsIgnoreCase("embeddedImage")) {
            addEle = new ImageElement(cont.getId(), 0, 0, 0, 0);
            byte[] imageData = Base64.decode((String)cont.getData().getFormat());
            Image image = new ImageIcon(imageData).getImage();
            ((ImageElement)addEle).setImg(image);
            ((ImageElement)addEle).setLinked(false);
            this.parseScaleInfo(cont, addEle);
        } else if (type.equalsIgnoreCase("linkedImage")) {
            addEle = new ImageElement(cont.getId(), 0, 0, 0, 0);
            ((ImageElement)addEle).setImageExpression(cont.getData().getFormat());
            this.parseScaleInfo(cont, addEle);
        }
        return addEle;
    }

    private void parseScaleInfo(Cell cont, ReportElement addEle) {
        int scaleMode = 0;
        Property scaleProp = cont.getProperties().get("scale");
        if (scaleProp != null) {
            scaleMode = ScaleUtil.toScaleEnum((String)scaleProp.getFormat());
        }
        if (addEle instanceof ImageElement) {
            ((ImageElement)addEle).setScale(scaleMode);
        } else if (addEle instanceof FieldElement) {
            ((FieldElement)addEle).setScale(scaleMode);
        }
    }

    private void parseAreaDesignInfo(IContainer container, LoopArea area, Container kdfEle) {
        Element elenode;
        if (container instanceof Table) {
            this.pasrseTableCellLoaction(area, kdfEle);
        }
        if ((elenode = (Element)kdfEle.getUserObject()) != null) {
            if (!(container instanceof Table)) {
                this.pasrseLoaction(area, kdfEle);
            }
            area.setLocked(Boolean.valueOf(elenode.getAttributeValue("locked")));
        }
    }

    private void pasrseTableCellLoaction(ReportElement ele, Container container) {
        ele.getTableLocation().setEndCol(Integer.parseInt(container.getRight().getString()));
        ele.getTableLocation().setStartCol(Integer.parseInt(container.getLeft().getString()) - 1);
        ele.getTableLocation().setEndRow(Integer.parseInt(container.getBottom().getString()));
        ele.getTableLocation().setStartRow(Integer.parseInt(container.getTop().getString()) - 1);
    }

    private void pasrseLocationOneSide(SideLocation side, String strType, String strObjectID, String strRelaSide, String strValue, String strFormula) {
        if (strType.equalsIgnoreCase("selfAdapt")) {
            side.setType(3);
        } else if (strType.equalsIgnoreCase("relative")) {
            side.setType(0);
        } else if (strType.equalsIgnoreCase("alignment")) {
            side.setType(1);
        } else if (strType.equalsIgnoreCase("custom")) {
            side.setType(2);
            side.setStrFormula(strFormula);
        }
        side.setRelativeObjectID(strObjectID);
        if (side.getType() == 1) {
            if (strRelaSide.equalsIgnoreCase("left")) {
                side.setContextValue(0);
            } else if (strRelaSide.equalsIgnoreCase("right")) {
                side.setContextValue(2);
            } else if (strRelaSide.equalsIgnoreCase("center")) {
                side.setContextValue(1);
            } else if (strRelaSide.equalsIgnoreCase("top")) {
                side.setContextValue(3);
            } else if (strRelaSide.equalsIgnoreCase("bottom")) {
                side.setContextValue(5);
            } else if (strRelaSide.equalsIgnoreCase("middle")) {
                side.setContextValue(4);
            }
        } else if (strRelaSide.equalsIgnoreCase("left")) {
            side.setContextValue(0);
        } else if (strRelaSide.equalsIgnoreCase("right")) {
            side.setContextValue(1);
        } else if (strRelaSide.equalsIgnoreCase("top")) {
            side.setContextValue(2);
        } else if (strRelaSide.equalsIgnoreCase("bottom")) {
            side.setContextValue(3);
        }
        side.setValue((int)Double.parseDouble(strValue));
    }

    private void pasrseLoaction(IElement ele, Container container) {
        Element elenode = (Element)container.getUserObject();
        if (elenode != null) {
            try {
                ele.setIsLoading(true);
                Location location = ele.getLocation();
                SideLocation side = location.getSideLocation(0);
                String strtype = elenode.getAttributeValue("leftLocationType");
                String strObjectID = elenode.getAttributeValue("leftRelativeObjID");
                String strenum = elenode.getAttributeValue("leftRelativeBorder");
                String strValue = elenode.getAttributeValue("leftRelativeOffset");
                String formula = container.getLeft().getOriginString();
                this.pasrseLocationOneSide(side, strtype, strObjectID, strenum, strValue, formula);
                side = location.getSideLocation(1);
                strtype = elenode.getAttributeValue("rightLocationType");
                strObjectID = elenode.getAttributeValue("rightRelativeObjID");
                strenum = elenode.getAttributeValue("rightRelativeBorder");
                strValue = elenode.getAttributeValue("rightRelativeOffset");
                formula = container.getRight().getOriginString();
                this.pasrseLocationOneSide(side, strtype, strObjectID, strenum, strValue, formula);
                side = location.getSideLocation(2);
                strtype = elenode.getAttributeValue("topLocationType");
                strObjectID = elenode.getAttributeValue("topRelativeObjID");
                strenum = elenode.getAttributeValue("topRelativeBorder");
                strValue = elenode.getAttributeValue("topRelativeOffset");
                formula = container.getTop().getOriginString();
                this.pasrseLocationOneSide(side, strtype, strObjectID, strenum, strValue, formula);
                side = location.getSideLocation(3);
                strtype = elenode.getAttributeValue("bottomLocationType");
                strObjectID = elenode.getAttributeValue("bottomRelativeObjID");
                strenum = elenode.getAttributeValue("bottomRelativeBorder");
                strValue = elenode.getAttributeValue("bottomRelativeOffset");
                formula = container.getBottom().getOriginString();
                this.pasrseLocationOneSide(side, strtype, strObjectID, strenum, strValue, formula);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parseGroupDesignInfo(IContainer container, Group group, Container kdfEle) {
        Element elenode;
        if (container instanceof Table) {
            this.pasrseTableCellLoaction(group, kdfEle);
        }
        if ((elenode = (Element)kdfEle.getUserObject()) != null) {
            if (!(container instanceof Table)) {
                this.pasrseLoaction(group, kdfEle);
            }
            group.setLocked(Boolean.valueOf(elenode.getAttributeValue("locked")));
        }
    }

    private void parseTableDesignInfo(IContainer container, Table table, Container kdfEle) {
        Element elenode;
        if (container instanceof Table) {
            this.pasrseTableCellLoaction(table, kdfEle);
        }
        if ((elenode = (Element)kdfEle.getUserObject()) != null) {
            if (!(container instanceof Table)) {
                this.pasrseLoaction(table, kdfEle);
            }
            table.setLocked(Boolean.valueOf(elenode.getAttributeValue("locked")));
            String layout = elenode.getAttributeValue("layout");
            if ("nonAuto".equalsIgnoreCase(layout)) {
                table.initSameHeight(false);
                table.initSameWidth(false);
            } else if ("heightAuto".equalsIgnoreCase(layout)) {
                table.initSameHeight(true);
                table.initSameWidth(false);
            } else if ("widthAuto".equalsIgnoreCase(layout)) {
                table.initSameHeight(false);
                table.initSameWidth(true);
            } else if ("auto".equalsIgnoreCase(layout)) {
                table.initSameHeight(true);
                table.initSameWidth(true);
            } else {
                boolean isSameSise = ((com.kingdee.bos.ctrl.kdf.form.Table)kdfEle).getLayoutMode() == 0;
                table.initSameWidth(isSameSise);
                table.initSameWidth(isSameSise);
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public KDFFrame getKDFFrame() {
        return this.reportFrame;
    }

    public void setKDFFrame(KDFFrame reportFrame) {
        this.reportFrame = reportFrame;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public void saveKdfFile() {
        this.saveKdfFile(this.getFilename());
    }

    public void saveKdfFile(String fileName) {
        this.buildKDFDom();
        this.getKDFDom().saveToFile(fileName);
        if (!this.getFilename().equals(fileName)) {
            this.setFilename(fileName);
        }
    }

    public void buildKDFDom() {
        this.kdfDom.setVersion(String.valueOf(4.0f));
        this.invalidGroups = new ArrayList();
        this.kdfDom.clearDataSources();
        this.kdfDom.clearDataObjects();
        this.kdfDom.clearForms();
        this.kdfDom.clearHeaders();
        this.kdfDom.clearFooters();
        this.kdfDom.clearStyleAttributes();
        this.savePrintInfo(this.kdfDom);
        this.saveForm(this.kdfDom);
        this.saveDataSource(this.kdfDom);
    }

    private void saveDataSource(com.kingdee.bos.ctrl.kdf.util.file.KDF kdfdom) {
        this.getDataManager().saveData(kdfdom);
    }

    private void savePrintInfo(com.kingdee.bos.ctrl.kdf.util.file.KDF kdfdom) {
        PrintInfo pi = kdfdom.getPrintInfo();
        pi.setBottomMargin(this.bottomMargin);
        pi.setLeftMargin(this.leftMargin);
        pi.setRightMargin(this.rightMargin);
        pi.setTopMargin(this.topMargin);
        pi.setOrientation(this.orientation);
        if (this.reportFormat.equalsIgnoreCase("Custom")) {
            pi.setCustomizedPaperSize(true);
            pi.setCustomizePaperWidth(this.orientation.equals("PORTRAIT") ? this.width : this.height);
            if (this.isDynamicPaper) {
                pi.setCustomizePaperHeight(-1);
            } else {
                pi.setCustomizePaperHeight(this.orientation.equals("PORTRAIT") ? this.height : this.width);
            }
            if (this.heightLimitless) {
                pi.setCustomizePageBottom(-1);
            } else {
                pi.setCustomizePageBottom(this.height);
            }
        } else {
            pi.setNamedMediaSize(this.reportFormat);
            pi.setCustomizedPaperSize(false);
        }
        pi.setEconomizePaper(this.isEconomizePaper);
        if (this.isHaveHeader()) {
            pi.setHeaderPreferHeight(this.getHeader().getHeightLom());
            pi.setHeaderMargin(this.getHeader().getMargin());
        }
        if (this.isHaveFooter()) {
            pi.setFooterPreferHeight(this.getFooter().getHeightLom());
            pi.setFooterMargin(this.getFooter().getMargin());
        }
    }

    private void saveForm(com.kingdee.bos.ctrl.kdf.util.file.KDF kdfdom) {
        Form form = new Form("form1");
        form.setUserAlias(this.getName());
        PageCollection ps = form.getPages();
        ArrayList pages = this.getPages();
        Iterator it = pages.iterator();
        while (it.hasNext()) {
            com.kingdee.bos.ctrl.kdf.form.Page page = new com.kingdee.bos.ctrl.kdf.form.Page();
            Page kdfpage = (Page)it.next();
            this.savePage(page, kdfpage);
            ps.add(page);
        }
        kdfdom.addForm(form);
        if (this.isHaveHeader()) {
            com.kingdee.bos.ctrl.kdf.form.Page headerDom = new com.kingdee.bos.ctrl.kdf.form.Page();
            this.saveHeadFooter(headerDom, this.header);
            kdfdom.addHeader(headerDom);
            form.setHeaderID(this.header.getName());
        }
        if (this.isHaveFooter()) {
            com.kingdee.bos.ctrl.kdf.form.Page footerDom = new com.kingdee.bos.ctrl.kdf.form.Page();
            this.saveHeadFooter(footerDom, this.footer);
            kdfdom.addFooter(footerDom);
            form.setFooterID(this.footer.getName());
        }
    }

    private void sortReportElement(ArrayList array) {
        if (array.size() > 0) {
            for (int i = 0; i < array.size(); ++i) {
                for (int j = i + 1; j < array.size(); ++j) {
                    if (!this.compareReportElement(array.get(i), array.get(j))) continue;
                    this.swapReportElement(array, i, j);
                }
            }
        }
        for (Object ob : array) {
            if (!(ob instanceof AbstractContainer)) continue;
            this.sortReportElement(((AbstractContainer)ob).allChildren);
        }
    }

    private boolean compareReportElement(Object ob1, Object ob2) {
        ReportElement re1 = (ReportElement)ob1;
        ReportElement re2 = (ReportElement)ob2;
        if (re1.posLom.y > re2.posLom.y) {
            return true;
        }
        return re1.posLom.y == re2.posLom.y && re1.posLom.x > re2.posLom.x;
    }

    private void swapReportElement(ArrayList array, int i, int j) {
        Object obtemp = array.remove(j);
        array.add(i, obtemp);
        obtemp = array.remove(i + 1);
        array.add(j, obtemp);
    }

    private void savePage(com.kingdee.bos.ctrl.kdf.form.Page page, Page kdfpage) {
        if (kdfpage.getRepeat() > -1) {
            page.setRepeat(kdfpage.getRepeat());
        }
        if (!StringUtil.isEmptyString((String)kdfpage.getDataSource())) {
            page.group().setDataSource(kdfpage.getDataSource());
        }
        Element pageDesign = new Element("DesignedPage", KDFXmlReader.NS_FORM);
        pageDesign.setAttribute("paperSize", this.reportFormat);
        pageDesign.setAttribute("objWidth", String.valueOf(kdfpage.getWidthLom()));
        pageDesign.setAttribute("objHeight", String.valueOf(kdfpage.getHeightLom()));
        pageDesign.setAttribute("widthLimitless", String.valueOf(this.widthLimitless));
        pageDesign.setAttribute("heightLimitless", String.valueOf(this.heightLimitless));
        page.setUserObject((Object)pageDesign);
        page.setRepeat(kdfpage.getRepeat());
        Page.Backgroud backgroud = kdfpage.getBackgroud();
        if (backgroud != null) {
            pageDesign.setAttribute("background", "true");
            Cell cell = new Cell();
            page.addChild((Container)cell);
            Data data = new Data();
            cell.setData(data);
            cell.setId("system_background");
            cell.setType("constant");
            data.setType("embeddedImage");
            cell.getLeft().setOriginString(String.valueOf(backgroud.getOffsetX()));
            cell.getTop().setOriginString(String.valueOf(backgroud.getOffsetY()));
            cell.getRight().setOriginString(String.valueOf(kdfpage.getWidthLom()));
            cell.getBottom().setOriginString(String.valueOf(kdfpage.getHeightLom()));
            StyleAttributes sa = Styles.getDefaultSA();
            sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            sa.setVerticalAlign(Styles.VerticalAlignment.TOP);
            cell.setStyles((ShareStyleAttributes)sa);
            cell.setLayer(String.valueOf(1));
            Image img = backgroud.getImage();
            byte[] datas = this.getImageData(img);
            if (datas != null) {
                cell.getData().setFormat(Base64.encodeBytes((byte[])datas));
            }
            cell.setPriority(Integer.MAX_VALUE);
        }
        this.saveCommonProps((Container)page, kdfpage);
        page.setParent((Container)page);
        page.getIdTable().put(page.getId(), page);
        ArrayList array = new ArrayList();
        Iterator it = kdfpage.allChildren.iterator();
        while (it.hasNext()) {
            array.add(it.next());
        }
        this.sortReportElement(array);
        it = array.iterator();
        while (it.hasNext()) {
            this.saveElement((ReportElement)it.next(), (Container)page);
        }
    }

    private void saveHeadFooter(com.kingdee.bos.ctrl.kdf.form.Page headfooter, Page kdfheadfooter) {
        Element pageDesign = new Element("DesignedPage", KDFXmlReader.NS_FORM);
        pageDesign.setAttribute("objHeight", String.valueOf(kdfheadfooter.getHeightLom()));
        headfooter.setUserObject((Object)pageDesign);
        this.saveCommonProps((Container)headfooter, kdfheadfooter);
        headfooter.setParent((Container)headfooter);
        headfooter.getIdTable().put(headfooter.getId(), headfooter);
        Iterator it = kdfheadfooter.allChildren.iterator();
        while (it.hasNext()) {
            this.saveElement((ReportElement)it.next(), (Container)headfooter);
        }
    }

    private void saveCommonProps(Container ele, ReportElement re) {
        ele.setStyles(re.getShareStyleAttribute());
        ele.setUserAlias(re.getAliasName());
        ele.setId(re.getName());
        if (re.getLayer() != null && re.getLayer().length() != 0) {
            ele.setLayer(re.getLayer());
        }
        if (re.getHoldPlace() != null && re.getHoldPlace().length() != 0) {
            ele.getHoldPlace().setOriginString(re.getHoldPlace());
        }
        if (re.getVisibility() != null && re.getVisibility().length() != 0) {
            ele.getVisibility().setOriginString(re.getVisibility());
        }
        if (re.getPostSteps() != null && re.getPostSteps().length() != 0) {
            ele.setPostSteps(re.getPostSteps());
        }
        if (re.getPreSteps() != null && re.getPreSteps().length() != 0) {
            ele.setPreSteps(re.getPreSteps());
        }
        if (!(re instanceof Page)) {
            IContainer parent = re.getParent();
            if (parent instanceof Table) {
                this.saveTableLocationAttribute(ele, re);
            } else {
                this.saveLocationAttribute(ele, re);
            }
        }
        ele.setPriority(re.getPriority());
    }

    private void saveElement(ReportElement ele, Container container) {
        switch (ele.getEleType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                this.saveCell(ele, container);
                break;
            }
            case 10: {
                this.saveTable((Table)ele, container);
                break;
            }
            case 12: {
                this.saveGroup((Group)ele, container);
                break;
            }
            case 11: {
                this.saveLoop((LoopArea)ele, container);
            }
        }
    }

    private void saveLoop(LoopArea loop, Container container) {
        Area area = new Area();
        if (loop.getMaxLoopCount() != -1) {
            area.setMaxLoopCount(loop.getMaxLoopCount());
        }
        if (loop.getMinLoopCount() > 0) {
            area.setMinLoopCount(loop.getMinLoopCount());
        }
        if (loop.getHorizontalSpacing() > 0.0f) {
            area.setHorizontalSpacing(String.valueOf(loop.getHorizontalSpacing()));
        }
        if (loop.getVerticalSpacing() > 0.0f) {
            area.setVerticalSpacing(String.valueOf(loop.getVerticalSpacing()));
        }
        if (loop.getNextLoopArea() != null) {
            Area nextArea = new Area();
            nextArea.setId(loop.getNextLoopArea().getName());
            area.setNext(nextArea);
        }
        Element areaDesign = new Element("DesignedArea", KDFXmlReader.NS_FORM);
        if (!(loop.getParent() instanceof Table)) {
            this.addDesignLocationAttributes(areaDesign, loop);
        }
        areaDesign.setAttribute("locked", String.valueOf(loop.isLocked()));
        area.setUserObject((Object)areaDesign);
        container.addChild((Container)area);
        this.saveCommonProps((Container)area, loop);
        area.setParent(container);
        container.getPage().getIdTable().put(area.getId(), area);
        ArrayList array = new ArrayList();
        Iterator it = loop.allChildren.iterator();
        while (it.hasNext()) {
            array.add(it.next());
        }
        this.sortReportElement(array);
        it = array.iterator();
        while (it.hasNext()) {
            this.saveElement((ReportElement)it.next(), (Container)area);
        }
    }

    private void addDesignLocationAttributes(Element designNode, ReportElement re) {
        Location loc = re.getLocation();
        loc.saveKDFAttriubtes(designNode);
    }

    private void saveLocationAttribute(Container container, ReportElement re) {
        Location loc = re.getLocation();
        boolean btline = false;
        if (re.getEleType() == 5 && ((LineElement)re).getDirection() == 1) {
            btline = true;
        }
        if (btline) {
            container.getLeft().setOriginString(loc.getKDFRelationFormula(0) + "+" + String.valueOf(re.getWidthLom()));
            container.getRight().setOriginString(loc.getKDFRelationFormula(0));
            container.getTop().setOriginString(loc.getKDFRelationFormula(2));
            container.getBottom().setOriginString(loc.getKDFRelationFormula(3));
        } else {
            this.saveSideLocation(container.getLeft(), loc, 0);
            this.saveSideLocation(container.getRight(), loc, 1);
            this.saveSideLocation(container.getTop(), loc, 2);
            this.saveSideLocation(container.getBottom(), loc, 3);
        }
    }

    private void saveSideLocation(EntityInfo ei, Location loc, int side) {
        SideLocation sl = loc.getSideLocation(side);
        if (sl.getType() == 3) {
            ei.setOriginString(null);
        } else if (sl.getType() == 2) {
            ei.setOriginString(sl.getStrFormula());
        } else {
            ei.setOriginString(loc.getKDFRelationFormula(side));
        }
    }

    private void saveTableLocationAttribute(Container container, ReportElement re) {
        TableLocation loc = re.getTableLocation();
        container.getLeft().setOriginString(loc.getKDFString(0));
        container.getRight().setOriginString(loc.getKDFString(1));
        container.getTop().setOriginString(loc.getKDFString(2));
        container.getBottom().setOriginString(loc.getKDFString(3));
    }

    private void saveGroup(Group group, Container container) {
        Panel pane = new Panel();
        if (!StringUtil.isEmptyString((String)group.getDataSource())) {
            pane.group().setDataSource(group.getDataSource());
        } else if (group.getParent() instanceof LoopArea) {
            String nearDS = group.getNearDataSource();
            if (!StringUtil.isEmptyString((String)nearDS)) {
                pane.group().setDataSource(nearDS);
            } else {
                this.invalidGroups.add(group.getAliasName());
            }
        }
        if (!StringUtil.isEmptyString((String)group.getField())) {
            pane.group().setField(group.getField());
        }
        Element groupDesign = new Element("DesignedPanel", KDFXmlReader.NS_FORM);
        if (!(group.getParent() instanceof Table)) {
            this.addDesignLocationAttributes(groupDesign, group);
        }
        groupDesign.setAttribute("locked", String.valueOf(group.isLocked()));
        pane.setUserObject((Object)groupDesign);
        container.addChild((Container)pane);
        this.saveCommonProps((Container)pane, group);
        pane.setParent(container);
        container.getPage().getIdTable().put(pane.getId(), pane);
        ArrayList array = new ArrayList();
        Iterator it = group.allChildren.iterator();
        while (it.hasNext()) {
            array.add(it.next());
        }
        this.sortReportElement(array);
        it = array.iterator();
        while (it.hasNext()) {
            this.saveElement((ReportElement)it.next(), (Container)pane);
        }
    }

    private void saveTable(Table tb, Container container) {
        com.kingdee.bos.ctrl.kdf.form.Table table = new com.kingdee.bos.ctrl.kdf.form.Table();
        if (!StringUtil.isEmptyString((String)tb.getDataSource())) {
            table.group().setDataSource(tb.getDataSource());
        } else if (tb.getParent() instanceof LoopArea) {
            String nearDS = tb.getNearDataSource();
            if (!StringUtil.isEmptyString((String)nearDS)) {
                table.group().setDataSource(nearDS);
            } else {
                this.invalidGroups.add(tb.getAliasName());
            }
        }
        if (!StringUtil.isEmptyString((String)tb.getField())) {
            table.group().setField(tb.getField());
        }
        Element tableDesign = new Element("DesignedTable", KDFXmlReader.NS_FORM);
        table.setCols(tb.getCols());
        table.setRows(tb.getRows());
        if (!tb.isSamedWidth() && !tb.isSamedHeight()) {
            table.setLayoutMode(1);
            tableDesign.setAttribute("layout", "nonAuto");
        } else if (!tb.isSamedWidth() && tb.isSamedHeight()) {
            table.setLayoutMode(1);
            tableDesign.setAttribute("layout", "heightAuto");
        } else if (tb.isSamedWidth() && !tb.isSamedHeight()) {
            table.setLayoutMode(1);
            tableDesign.setAttribute("layout", "widthAuto");
        } else {
            tableDesign.setAttribute("layout", "auto");
        }
        if (!(tb.getParent() instanceof Table)) {
            this.addDesignLocationAttributes(tableDesign, tb);
        }
        tableDesign.setAttribute("locked", String.valueOf(tb.isLocked()));
        table.setUserObject((Object)tableDesign);
        container.addChild((Container)table);
        this.saveCommonProps((Container)table, tb);
        table.setParent(container);
        container.getPage().getIdTable().put(table.getId(), table);
        ArrayList array = new ArrayList();
        Iterator it = tb.allChildren.iterator();
        while (it.hasNext()) {
            array.add(it.next());
        }
        this.sortReportElement(array);
        it = array.iterator();
        while (it.hasNext()) {
            this.saveElement((ReportElement)it.next(), (Container)table);
        }
    }

    private void saveCell(ReportElement re, Container container) {
        LineElement line;
        Cell cell = new Cell();
        Data data = new Data();
        cell.setData(data);
        Element cellDesign = new Element("DesignedCell", KDFXmlReader.NS_FORM);
        switch (re.getEleType()) {
            case 13: {
                cell.setType("formula");
                cell.getData().setFormat(((FormulaElement)re).getFormula());
                cell.setDataFormat(((FormulaElement)re).getFormat());
                break;
            }
            case 14: {
                cell.setType("variant");
                cell.getData().setFormat(((VariantElement)re).getVariantName());
                cell.setDataFormat(((VariantElement)re).getFormat());
                break;
            }
            case 4: {
                FieldElement field = (FieldElement)re;
                switch (field.getFieldType()) {
                    case 0: {
                        cell.setType("field");
                        if (!field.isPhoto()) break;
                        cell.addProperty(new Property("contentType", null, "image"));
                        Property pro = new Property("scale", null, ScaleUtil.toScaleName((int)field.getScale()));
                        cell.addProperty(pro);
                        break;
                    }
                    case 1: {
                        cell.setType("groupField");
                        break;
                    }
                    case 2: {
                        cell.setType("groupTotal");
                        break;
                    }
                    case 3: {
                        cell.setType("areaTotal");
                    }
                }
                cell.setDataFormat(field.getFormat());
                cell.getData().setFormat(field.getFieldID());
                if (StringUtil.isEmptyString((String)field.getFieldAlias())) break;
                cellDesign.setAttribute("text", field.getFieldAlias());
                break;
            }
            case 3: {
                cell.setType("constant");
                cell.getData().setFormat(((StaticTextElement)re).getText());
                break;
            }
            case 5: {
                cell.setType("constant");
                cell.getData().setType("line");
                break;
            }
            case 2: {
                ImageElement image = (ImageElement)re;
                cell.setType("constant");
                if (image.isLinked()) {
                    cell.getData().setType("linkedImage");
                    cell.getData().setFormat(image.getImageExpression());
                } else {
                    cell.getData().setType("embeddedImage");
                    byte[] datas = this.getImageData(image.getImg());
                    if (datas != null) {
                        cell.getData().setFormat(Base64.encodeBytes((byte[])datas));
                    }
                }
                Property pro = new Property("scale", null, ScaleUtil.toScaleName((int)image.getScale()));
                cell.addProperty(pro);
                break;
            }
            case 9: {
                ChartElement chart = (ChartElement)re;
                cell.setType("chart");
                cell.getData().setType("string");
                cell.getData().setFormat(chart.makeSavingString(this.getDataManager().getDataForBind()));
            }
        }
        if (re.getEleType() == 5 && (line = (LineElement)re).getDirection() != 0) {
            cellDesign.setAttribute("direction", "1");
        }
        if (!(re.getParent() instanceof Table)) {
            this.addDesignLocationAttributes(cellDesign, re);
        }
        cellDesign.setAttribute("locked", String.valueOf(re.isLocked()));
        cell.setUserObject((Object)cellDesign);
        container.addChild((Container)cell);
        this.saveCommonProps((Container)cell, re);
        cell.setParent(container);
        container.getPage().getIdTable().put(cell.getId(), cell);
        cell.setDivideCharacter(re.getDivideCharacter());
    }

    private byte[] getImageData(Image image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics g = bufferedImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", out);
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public boolean isDirty() {
        return this.dirty > 0;
    }

    public void setDirty(boolean dirty) {
        int n = this.dirty = dirty ? this.dirty + 1 : 0;
        if (this.reportFrame != null) {
            this.reportFrame.updateTitle();
        }
    }

    public void decrementDirty() {
        if (this.dirty > 0) {
            --this.dirty;
        }
        if (this.reportFrame != null) {
            this.reportFrame.updateTitle();
        }
    }

    public void incrementDirty() {
        ++this.dirty;
        if (this.reportFrame != null) {
            this.reportFrame.updateTitle();
        }
    }

    public int getDirtyOperations() {
        return this.dirty;
    }

    public void addPage(Page newpage) {
        this.pages.add(newpage);
        this.allElementsNameMap.put(newpage.getName(), newpage);
        this.allElementsAliasNameMap.put(newpage.getAliasName(), newpage);
        if (this.reportFrame != null) {
            this.reportFrame.setCurrentpage(newpage);
        }
        this.incrementDirty();
    }

    public void updatePageSize(Page page) {
        if (page instanceof HeadFooter) {
            page.setWidthLom(this.getPureWidthLom());
        } else {
            page.setWidthLom(this.getPureWidthLom());
            page.setHeightLom(this.getPureHeightLom());
        }
    }

    public ArrayList getPages() {
        return this.pages;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setPureHeightLom(int pureHeightLom) {
        this.pureHeightLom = pureHeightLom;
    }

    public int getPureWidth() {
        return (int)StyleUtil.lomToPixel((long)this.getPureWidthLom());
    }

    public int getPureHeight() {
        return (int)StyleUtil.lomToPixel((long)this.getPureHeightLom());
    }

    public int getPureWidthLom() {
        return this.width - this.leftMargin - this.rightMargin;
    }

    public int getPureHeightLom() {
        if (this.isHeightLimitless()) {
            return this.pureHeightLom;
        }
        return this.height - this.topMargin - this.bottomMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    public String getUniqueName(int elementType) {
        return this.sn.getUniqueName(elementType);
    }

    public String getUniqueAliasName(int elementType) {
        return this.sn.getUniqueAliasName(elementType);
    }

    public HashMap getElementsNameMap() {
        return this.allElementsNameMap;
    }

    public HashMap getElementsAliasNameMap() {
        return this.allElementsAliasNameMap;
    }

    public IDataManager getDataManager() {
        if (this.dataManager == null) {
            this.dataManager = new DefaultDataManager();
        }
        return this.dataManager;
    }

    public void setDataManager(IDataManager dataManager) {
        this.dataManager = dataManager;
    }

    public boolean isHavedAliasName(String aliasName) {
        return this.allElementsAliasNameMap.get(aliasName) != null;
    }

    public HeadFooter getFooter() {
        return this.footer;
    }

    public void setFooter(HeadFooter footer) {
        this.footer = footer;
        this.allElementsNameMap.put(footer.getName(), footer);
    }

    public HeadFooter getHeader() {
        return this.header;
    }

    public void setHeader(HeadFooter header) {
        this.header = header;
        this.allElementsNameMap.put(header.getName(), header);
    }

    public boolean isHeightLimitless() {
        return this.heightLimitless;
    }

    public void setHeightLimitless(boolean heightLimitless) {
        this.heightLimitless = heightLimitless;
    }

    public boolean isWidthLimitless() {
        return this.widthLimitless;
    }

    public void setWidthLimitless(boolean widthLimitless) {
        this.widthLimitless = widthLimitless;
    }

    public boolean isQueryBound(String queryID) {
        Iterator it = this.pages.iterator();
        boolean isBound = false;
        while (it.hasNext()) {
            Page page = (Page)it.next();
            if (!this.isQueryBound(queryID, page)) continue;
            isBound = true;
            break;
        }
        return isBound;
    }

    private boolean isQueryBound(String queryID, ReportElement element) {
        ChartElement chart;
        if (element instanceof AbstractGroup ? StringUtil.equals((String)((AbstractGroup)element).getDataSource(), (String)queryID) : (element.getEleType() == 15 ? StringUtil.equals((String)((Page)element).getDataSource(), (String)queryID) : element.getEleType() == 9 && ((chart = (ChartElement)element).isSeriesBindToDS() && StringUtil.equals((String)chart.getSeriesDS(), (String)queryID) || chart.isGroupsBindToDS() && StringUtil.equals((String)chart.getGroupsDS(), (String)queryID) || chart.isValueBindToDS() && StringUtil.equals((String)chart.getValueDS(), (String)queryID)))) {
            return true;
        }
        if (element instanceof AbstractContainer) {
            for (ReportElement re : ((AbstractContainer)element).getChildren()) {
                if (!this.isQueryBound(queryID, re)) continue;
                return true;
            }
        }
        return false;
    }

    public void renameQueryBound(String oldID, String newID) {
        Iterator it = this.pages.iterator();
        while (it.hasNext()) {
            this.renameQueryBound((Page)it.next(), oldID, newID);
        }
    }

    private void renameQueryBound(ReportElement element, String oldID, String newID) {
        if (element instanceof AbstractGroup) {
            if (StringUtil.equals((String)((AbstractGroup)element).getDataSource(), (String)oldID)) {
                ((AbstractGroup)element).setDataSource(newID, false);
            }
        } else if (element.getEleType() == 15) {
            if (StringUtil.equals((String)((Page)element).getDataSource(), (String)oldID)) {
                ((Page)element).setDataSource(newID, false);
            }
        } else if (element.getEleType() == 9) {
            ChartElement chart = (ChartElement)element;
            if (chart.isSeriesBindToDS() && StringUtil.equals((String)chart.getSeriesDS(), (String)oldID)) {
                chart.setSeriesDS(newID);
            }
            if (chart.isGroupsBindToDS() && StringUtil.equals((String)chart.getGroupsDS(), (String)oldID)) {
                chart.setGroupsDS(newID);
            }
            if (chart.isValueBindToDS() && StringUtil.equals((String)chart.getValueDS(), (String)oldID)) {
                chart.setValueDS(newID);
            }
        }
        if (element instanceof AbstractContainer) {
            Iterator it = ((AbstractContainer)element).getChildren().iterator();
            while (it.hasNext()) {
                this.renameQueryBound((ReportElement)it.next(), oldID, newID);
            }
        }
    }

    public void deleteFieldBound(String queryID, List deletedCols) {
        for (Page page : this.pages) {
            for (MetaField col : deletedCols) {
                this.deleteFieldBound(queryID, col, page);
            }
        }
    }

    private void deleteFieldBound(String queryID, MetaField column, ReportElement element) {
        if (element instanceof AbstractGroup) {
            if (StringUtil.equals((String)((AbstractGroup)element).getNearDataSource(), (String)queryID) && StringUtil.equals((String)((AbstractGroup)element).getField(), (String)column.getName())) {
                ((AbstractGroup)element).setField("");
            }
        } else if (element.getEleType() == 4) {
            if (StringUtil.equals((String)((FieldElement)element).getNearDataSource(), (String)queryID) && StringUtil.equals((String)((FieldElement)element).getFieldAlias(), (String)column.getAliasName()) && StringUtil.equals((String)((FieldElement)element).getFieldID(), (String)column.getName())) {
                ((FieldElement)element).setField(null);
            }
        } else if (element.getEleType() == 9) {
            ChartElement chart = (ChartElement)element;
            if (chart.isSeriesBindToDS() && StringUtil.equals((String)chart.getSeriesDS(), (String)queryID) && StringUtil.equals((String)chart.getSeriesField(), (String)column.getName())) {
                chart.setSeriesField("");
            }
            if (chart.isGroupsBindToDS() && StringUtil.equals((String)chart.getGroupsDS(), (String)queryID) && StringUtil.equals((String)chart.getGroupsField(), (String)column.getName())) {
                chart.setGroupsField("");
            }
        }
        if (element instanceof AbstractContainer) {
            Iterator it = ((AbstractContainer)element).getChildren().iterator();
            while (it.hasNext()) {
                this.deleteFieldBound(queryID, column, (ReportElement)it.next());
            }
        }
    }

    public void reBuilder() {
        this.updatePageSize(this.header);
        this.updatePageSize(this.footer);
        for (Page page : this.pages) {
            this.updatePageSize(page);
        }
        this.calcAllElementPosition();
    }

    public String getFilename4Title() {
        if (StringUtil.isEmptyString((String)this.getFilename())) {
            return this.getName();
        }
        int s = this.filename.lastIndexOf(File.separator);
        return this.filename.substring(s + 1);
    }

    public boolean isHaveFooter() {
        return this.haveFooter;
    }

    public boolean isHaveHeader() {
        return this.haveHeader;
    }

    public void setHaveFooter(boolean b) {
        this.haveFooter = b;
    }

    public void setHaveHeader(boolean b) {
        this.haveHeader = b;
    }

    public ArrayList getInvalidGroups() {
        return this.invalidGroups;
    }

    public int getSaveWhere() {
        return this.saveWhere;
    }

    public void setSaveWhere(int i) {
        this.saveWhere = i;
    }

    public void initAllElementListener() {
        Iterator it = this.getPages().iterator();
        while (it.hasNext()) {
            this.initAllElementListener((Page)it.next());
        }
        this.initAllElementListener(this.getHeader());
        this.initAllElementListener(this.getFooter());
    }

    private void initAllElementListener(IElement elm) {
        FormDesigner.initReportElementListener(this.reportFrame.getMainFrame(), this, elm);
        if (elm instanceof AbstractContainer) {
            for (IElement child : ((AbstractContainer)elm).getChildren()) {
                this.initAllElementListener(child);
            }
        }
    }

    public boolean isDynamicPaper() {
        return this.isDynamicPaper;
    }

    public void setDynamicPaper(boolean isDynamicPaper) {
        this.isDynamicPaper = isDynamicPaper;
    }

    public boolean isEconomizePaper() {
        return this.isEconomizePaper;
    }

    public void setEconomizePaper(boolean isEconomize) {
        this.isEconomizePaper = isEconomize;
    }
}

