/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.common.util.CustomFileFilter;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.fd2.DocumentTreeEntry;
import com.kingdee.bos.ctrl.kdf.fd2.IFileLoader;
import com.kingdee.bos.ctrl.kdf.fd2.IFileSaver;
import com.kingdee.bos.ctrl.kdf.fd2.KDF;
import com.kingdee.bos.ctrl.kdf.fd2.RecentFile;
import com.kingdee.bos.ctrl.kdf.fd2.StyleClipboard;
import com.kingdee.bos.ctrl.kdf.fd2.actions.AbstractDesignerAction;
import com.kingdee.bos.ctrl.kdf.fd2.actions.ActionManager;
import com.kingdee.bos.ctrl.kdf.fd2.data.DefaultDataManagerFactory;
import com.kingdee.bos.ctrl.kdf.fd2.data.DefaultMetaManager;
import com.kingdee.bos.ctrl.kdf.fd2.data.IDataManager;
import com.kingdee.bos.ctrl.kdf.fd2.data.IDataManagerFactory;
import com.kingdee.bos.ctrl.kdf.fd2.data.IMetaManager;
import com.kingdee.bos.ctrl.kdf.fd2.gui.FormDesignerOwnerFactory;
import com.kingdee.bos.ctrl.kdf.fd2.gui.IFormDesignerOwner;
import com.kingdee.bos.ctrl.kdf.fd2.gui.KDFFrame;
import com.kingdee.bos.ctrl.kdf.fd2.gui.data.QueryTree;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.InitCompletedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.InitCompletedListener;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.InternalFrameActivatedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.InternalFrameActivatedListener;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.PropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.PropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ReportElementChangedEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ReportElementsSelectionEvent;
import com.kingdee.bos.ctrl.kdf.fd2.gui.event.ReportListener;
import com.kingdee.bos.ctrl.kdf.fd2.gui.propertiesdialog.ElePropsDialog;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.KDFFileTreeNode;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.KDFPropsDialog;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.KDFStructTreeNode;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.KDFTreeSelectionModel;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MDIDesktopPane;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MDIMenuBar;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MenuItemFactory;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.RadioButtonMenuItem;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.SplashFrame;
import com.kingdee.bos.ctrl.kdf.fd2.icons.Icons;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.HeadFooter;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ImageElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.util.DataUtil;
import com.kingdee.bos.ctrl.kdf.fd2.util.LimitedSizeStack;
import com.kingdee.bos.ctrl.kdf.fd2.util.Misc;
import com.kingdee.bos.ctrl.kdf.util.AbstractK3File2KDFObj;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.KDRFile2KDFObj;
import com.kingdee.bos.ctrl.kdf.util.NDFFile2KDFObj;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarRenderer;
import com.kingdee.bos.ctrl.swing.event.MenuAdapter;
import com.kingdee.bos.ctrl.swing.event.PopupMenuAdapter;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTreeUI;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class FormDesigner
extends KDPanel
implements ReportListener {
    private IFormDesignerOwner owner;
    private IFileLoader fileLoader;
    private IFileSaver fileSaver;
    private String designerTitle = FormDesigner.getMLS("designerTitle", "\u8868\u5355\u8bbe\u8ba1\u5668");
    private HashMap properties;
    private LimitedSizeStack recentFilesStack;
    private ArrayList clipboards;
    private StyleClipboard styleClipboard;
    private HashMap docHashmap = new HashMap();
    private boolean isInit = true;
    private static boolean isSingleRun = false;
    private JProgressBar pgb;
    private double prgBarPercent = 0.0;
    private ActionManager actionManager;
    private String configFile = "/client/FormDesigner.xml";
    private KDMenuItem treePopItemCut;
    private KDMenuItem treePopItemCopy;
    private KDMenuItem treePopItemPaste;
    private KDMenuItem treePopItemDelete;
    private KDMenuItem treePopItemCopyStyle;
    private KDMenuItem treePopItemPasteStyle;
    private KDMenuItem treePopItemProperty;
    private MDIMenuBar mdiMenuBar;
    private KDToolBar normalToolBar;
    private KDStatusBar statusBar;
    private KDSplitPane horizontalSplitPane;
    private MDIDesktopPane mdiDesktopPane;
    private KDTabbedPane wizardTabbedPane;
    private KDPanel panDocStructure;
    private KDPanel panQuery;
    private KDPanel panStorage;
    private KDTree docStructureTree;
    private KDTree filesTree;
    private QueryTree queryTree;
    private ButtonGroup buttonGroupFramesList;
    private KDFPropsDialog rpf;
    private ElePropsDialog elementPropertiesDialog;
    private KDToggleButton btnToolboxPointer;
    private KDToggleButton btnToolboxLoop;
    private KDToggleButton btnToolboxTable;
    private KDToggleButton btnToolboxGroup;
    private KDToggleButton btnToolboxText;
    private KDToggleButton btnToolboxVariant;
    private KDToggleButton btnToolboxFormula;
    private KDToggleButton btnToolboxField;
    private KDToggleButton btnToolboxLine;
    private KDToggleButton btnToolboxImage;
    private KDToggleButton btnToolboxChart;
    private boolean dontHandleEvent;
    private FormListener formListener = null;
    private boolean isHeadFooter = false;
    private boolean isHeadDesign = false;
    private static SplashFrame splash;
    private static String res;
    private EventListenerList listenerList = new EventListenerList();
    private IDataManagerFactory dataManagerFactory;
    private IMetaManager metaManager;

    public FormDesigner(IFormDesignerOwner owner, boolean isHeadDesign) {
        this.owner = owner;
        this.isHeadDesign = isHeadDesign;
    }

    public void setConfigFile(String file) {
        if (StringUtil.isEmptyString((String)file)) {
            return;
        }
        this.configFile = file;
    }

    public void init() {
        this.getOwner().setTitle(this.designerTitle);
        this.initFrame();
        this.startStatusProgressTimer();
        new Thread(){

            @Override
            public void run() {
                FormDesigner.this.initComponents();
            }
        }.start();
    }

    public String getFirstNameFree() {
        JInternalFrame[] frames = this.mdiDesktopPane.getAllFrames();
        String nameForepart = FormDesigner.getMLS("defaultFormName", "\u8868\u5355_");
        int k = 1;
        while (true) {
            String name = nameForepart + k;
            boolean found = false;
            for (int i = 0; i < frames.length; ++i) {
                KDFFrame jrf;
                if (!(frames[i] instanceof KDFFrame) || !(jrf = (KDFFrame)((Object)frames[i])).getReport().getName().equalsIgnoreCase(name)) continue;
                found = true;
                break;
            }
            if (!found) {
                return name;
            }
            ++k;
        }
    }

    private void setFileListActivatedFrame(KDFFrame frame) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.filesTree.getModel();
        Enumeration opened_entries = ((KDFFileTreeNode)((Object)dtm.getRoot())).children();
        while (opened_entries.hasMoreElements()) {
            DocumentTreeEntry dte;
            KDFFileTreeNode documentEntryNode = (KDFFileTreeNode)((Object)opened_entries.nextElement());
            if (!(documentEntryNode.getUserObject() instanceof DocumentTreeEntry) || (dte = (DocumentTreeEntry)documentEntryNode.getUserObject()).getKDF() != frame) continue;
            this.filesTree.setSelectionNode((DefaultKingdeeTreeNode)documentEntryNode);
            break;
        }
    }

    public void updateMenuWindowList() {
        KDMenu mnuWin = this.getActionManager().getMenu("window");
        Component[] menus = mnuWin.getMenuComponents();
        int i = 0;
        for (int k = 0; k < menus.length; ++k) {
            if (!(menus[k] instanceof RadioButtonMenuItem) || ((RadioButtonMenuItem)((Object)menus[k])).getFrame() == null || !((RadioButtonMenuItem)((Object)menus[k])).getFrame().isVisible()) continue;
            RadioButtonMenuItem menuItem = (RadioButtonMenuItem)((Object)menus[k]);
            menuItem.setText(i + 1 + ". " + menuItem.getFrame().getTitle());
            menuItem.setMnemonic((i + 1 + "").charAt(0));
            menuItem.setAccelerator(KeyStroke.getKeyStroke((int)(i + 1 + "").charAt(0), 8));
            ++i;
        }
    }

    private void actionPerformedFrameList(ActionEvent evt) {
        if (evt.getSource() != null && evt.getSource() instanceof RadioButtonMenuItem) {
            RadioButtonMenuItem mdm = (RadioButtonMenuItem)((Object)evt.getSource());
            try {
                mdm.getFrame().setSelected(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jMDIDesktopPaneInternalFrameActivated(InternalFrameActivatedEvent evt) {
        if (this.isHeadDesign) {
            if (evt.getJMDIFrame() instanceof KDFFrame) {
                KDFFrame jrf = (KDFFrame)evt.getJMDIFrame();
                this.setFileListActivatedFrame(jrf);
                this.setActiveReportForm(jrf);
            }
        } else {
            if (evt.getJMDIFrame() != null && evt.getAction() == -1) {
                DefaultTreeModel dtm = (DefaultTreeModel)this.filesTree.getModel();
                Enumeration opened_entries = ((KDFFileTreeNode)((Object)dtm.getRoot())).children();
                while (opened_entries.hasMoreElements()) {
                    DocumentTreeEntry dte;
                    KDFFileTreeNode documentEntryNode = (KDFFileTreeNode)((Object)opened_entries.nextElement());
                    if (!(documentEntryNode.getUserObject() instanceof DocumentTreeEntry) || (dte = (DocumentTreeEntry)documentEntryNode.getUserObject()).getKDF() != evt.getJMDIFrame()) continue;
                    this.filesTree.removeNodeFromParent((MutableTreeNode)((Object)documentEntryNode));
                    break;
                }
                KDMenu mnuWin = this.getActionManager().getMenu("window");
                Component[] menus = mnuWin.getMenuComponents();
                for (int k = menus.length - 1; k >= 0; --k) {
                    if (!(menus[k] instanceof RadioButtonMenuItem) || ((RadioButtonMenuItem)((Object)menus[k])).getFrame() != evt.getJMDIFrame()) continue;
                    mnuWin.remove(menus[k]);
                    break;
                }
                Enumeration<AbstractButton> enu = this.buttonGroupFramesList.getElements();
                while (enu.hasMoreElements()) {
                    RadioButtonMenuItem item = (RadioButtonMenuItem)((Object)enu.nextElement());
                    if (item.getFrame() != evt.getJMDIFrame()) continue;
                    this.buttonGroupFramesList.remove((AbstractButton)((Object)item));
                }
                this.updateMenuWindowList();
                return;
            }
            if (evt.getJMDIFrame() instanceof KDFFrame) {
                KDFFrame jrf = (KDFFrame)evt.getJMDIFrame();
                this.setFileListActivatedFrame(jrf);
                this.setActiveReportForm(jrf);
            } else {
                this.setActiveReportForm(null);
            }
        }
    }

    private void setActiveReportForm(KDFFrame frame) {
        boolean enabled = true;
        if (frame == null) {
            this.getOwner().setTitle(this.designerTitle);
            enabled = false;
        } else {
            this.getOwner().setTitle(this.designerTitle + " - " + frame.getTitle());
            KDMenu mnuWin = this.getActionManager().getMenu("window");
            Component[] menus = mnuWin.getMenuComponents();
            for (int k = menus.length - 1; k >= 0; --k) {
                if (!(menus[k] instanceof RadioButtonMenuItem) || ((RadioButtonMenuItem)((Object)menus[k])).getFrame() != frame) continue;
                ((RadioButtonMenuItem)((Object)menus[k])).setSelected(true);
            }
        }
        if (this.elementPropertiesDialog != null) {
            this.elementPropertiesDialog.setKDFFrame(frame);
        }
        this.updateHeadFooterMenuItem(frame);
        this.updateDocumentStructureTree(frame);
        this.updataQueryTree(frame);
        this.updateUndoMenu(frame);
        this.updateCutPasteMenuEnabled(frame);
        this.updatePasteStyleMenuEnabled(frame);
        this.btnToolboxPointer.setEnabled(enabled);
        this.btnToolboxLoop.setEnabled(enabled);
        this.btnToolboxGroup.setEnabled(enabled);
        this.btnToolboxTable.setEnabled(enabled);
        this.btnToolboxText.setEnabled(enabled);
        this.btnToolboxField.setEnabled(enabled);
        this.btnToolboxVariant.setEnabled(enabled);
        this.btnToolboxFormula.setEnabled(enabled);
        this.btnToolboxImage.setEnabled(enabled);
        this.btnToolboxLine.setEnabled(enabled);
        this.btnToolboxChart.setEnabled(enabled);
        this.getActionManager().getDesignerAction("close").setEnabled(enabled);
        this.getActionManager().getDesignerAction("saveAll").setEnabled(enabled);
        this.getActionManager().getDesignerAction("saveAs").setEnabled(enabled);
        this.getActionManager().getDesignerAction("save").setEnabled(enabled);
        this.getActionManager().getDesignerAction("preview").setEnabled(enabled);
        this.getActionManager().getDesignerAction("formAttributes").setEnabled(enabled);
        this.getActionManager().getDesignerAction("objectProperties").setEnabled(enabled);
        this.getActionManager().getDesignerAction("header").setEnabled(enabled);
        this.getActionManager().getDesignerAction("footer").setEnabled(enabled);
        this.getActionManager().getDesignerAction("dataWizard").setEnabled(enabled);
        this.getActionManager().getDesignerAction("reportWizard").setEnabled(enabled);
        this.setActiveTool((Component)this.btnToolboxPointer);
        if (!enabled) {
            this.btnToolboxPointer.setSelected(false);
        }
    }

    private void updateDocumentStructureTree(KDFFrame frame) {
        this.setDontHandleEvent(true);
        this.docHashmap.clear();
        KDFStructTreeNode root = (KDFStructTreeNode)((Object)this.docStructureTree.getModel().getRoot());
        this.docStructureTree.removeAllChildrenFromParent((MutableTreeNode)((Object)root));
        this.setDontHandleEvent(false);
        if (frame != null) {
            if (frame.getReport().isHaveHeader()) {
                KDFStructTreeNode headernode = new KDFStructTreeNode(frame.getReport().getHeader());
                this.docStructureTree.addNodeInto((MutableTreeNode)((Object)headernode), (MutableTreeNode)((Object)root));
                this.docHashmap.put(frame.getReport().getHeader(), headernode);
                this.updateDocuemtElement(headernode, frame.getReport().getHeader());
            }
            if (frame.getReport().isHaveFooter()) {
                KDFStructTreeNode footernode = new KDFStructTreeNode(frame.getReport().getFooter());
                this.docStructureTree.addNodeInto((MutableTreeNode)((Object)footernode), (MutableTreeNode)((Object)root));
                this.docHashmap.put(frame.getReport().getFooter(), footernode);
                this.updateDocuemtElement(footernode, frame.getReport().getFooter());
            }
            if (!this.isHeadDesign) {
                for (Page page : frame.getReport().getPages()) {
                    KDFStructTreeNode pagenode = new KDFStructTreeNode(page);
                    this.docStructureTree.addNodeInto((MutableTreeNode)((Object)pagenode), (MutableTreeNode)((Object)root));
                    this.docHashmap.put(page, pagenode);
                    this.updateDocuemtElement(pagenode, page);
                }
            }
            this.reportElementsSelectionChanged(new ReportElementsSelectionEvent(frame, frame.getSelectedElements()));
        }
        ((KingdeeTreeUI)this.docStructureTree.getUI()).resetSize();
        this.docStructureTree.expandPath(new TreePath(root.getPath()));
    }

    private void updateDocuemtElement(KDFStructTreeNode father, IContainer container) {
        for (IElement ele : container.getChildren()) {
            KDFStructTreeNode node = new KDFStructTreeNode(ele);
            this.docHashmap.put(ele, node);
            this.docStructureTree.addNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)father));
            if (!(ele instanceof IContainer)) continue;
            this.updateDocuemtElement(node, (IContainer)ele);
        }
    }

    public void setActiveToolIsPointer() {
        this.setActiveTool((Component)this.btnToolboxPointer);
    }

    private void setActiveTool(Component tool) {
        try {
            this.btnToolboxPointer.setSelected(tool == this.btnToolboxPointer);
            this.btnToolboxLoop.setSelected(tool == this.btnToolboxLoop);
            this.btnToolboxGroup.setSelected(tool == this.btnToolboxGroup);
            this.btnToolboxTable.setSelected(tool == this.btnToolboxTable);
            this.btnToolboxText.setSelected(tool == this.btnToolboxText);
            this.btnToolboxField.setSelected(tool == this.btnToolboxField);
            this.btnToolboxFormula.setSelected(tool == this.btnToolboxFormula);
            this.btnToolboxVariant.setSelected(tool == this.btnToolboxVariant);
            this.btnToolboxImage.setSelected(tool == this.btnToolboxImage);
            this.btnToolboxLine.setSelected(tool == this.btnToolboxLine);
            this.btnToolboxChart.setSelected(tool == this.btnToolboxChart);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initFrame() {
        if (!this.isHeadDesign) {
            this.mdiMenuBar = new MDIMenuBar();
            this.mdiMenuBar.setPreferredSize(new Dimension(100, 27));
            this.getOwner().setJMenuBar((JMenuBar)((Object)this.mdiMenuBar));
        }
        this.initStatusBar();
        this.formListener = new FormListener();
        this.mdiDesktopPane = new MDIDesktopPane();
        this.horizontalSplitPane = new KDSplitPane();
        this.horizontalSplitPane.setRightComponent((Component)this.mdiDesktopPane);
        this.wizardTabbedPane = new KDTabbedPane(1, 1);
        this.wizardTabbedPane.setTabPlacement(3);
        this.wizardTabbedPane.setPreferredSize(new Dimension(240, 10));
        this.panDocStructure = new KDPanel((LayoutManager)new BorderLayout());
        this.panQuery = new KDPanel((LayoutManager)new BorderLayout());
        this.panStorage = new KDPanel((LayoutManager)new BorderLayout());
        this.wizardTabbedPane.addTab(FormDesigner.getMLS("fileStruct", "\u6587\u6863\u7ed3\u6784"), (Component)this.panDocStructure);
        this.wizardTabbedPane.addTab(FormDesigner.getMLS("queryObject", "\u67e5\u8be2\u5bf9\u8c61"), (Component)this.panQuery);
        this.horizontalSplitPane.setLeftComponent((Component)this.wizardTabbedPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.horizontalSplitPane, "Center");
        this.getOwner().setContentPane((Container)((Object)this));
        this.getOwner().setSize(800, 600);
        if (this.getOwner() instanceof KDFrame) {
            ((KDFrame)this.getOwner()).setExtendedState(6);
        }
        this.getOwner().setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.isInit = true;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (FormDesigner.this.getOwner() instanceof JFrame) {
                    splash = new SplashFrame((JFrame)((Object)FormDesigner.this.getOwner()), Icons.IMG_ABOUTPICTURE, 2000, 502, 205);
                } else if (FormDesigner.this.getOwner() instanceof JDialog) {
                    splash = new SplashFrame((JDialog)((Object)FormDesigner.this.getOwner()), Icons.IMG_ABOUTPICTURE, 2000, 502, 205);
                }
                splash.showSplash();
            }
        });
        thread.start();
        this.showStatusProgress(0.1);
        this.properties = new HashMap();
        this.recentFilesStack = new LimitedSizeStack(9);
        this.clipboards = new ArrayList();
        this.styleClipboard = new StyleClipboard();
        File confFile = GlobalLocator.getInstance().locateResourceFile(this.configFile);
        this.showStatusProgress(0.2);
        this.buttonGroupFramesList = new ButtonGroup();
        this.getOwner().addWindowListener(this.formListener);
        this.showStatusProgress(0.3);
        this.actionManager = new ActionManager(this, confFile);
        if (!this.isHeadDesign) {
            this.initMenu();
        }
        this.showStatusProgress(0.4);
        this.initToolBar();
        this.showStatusProgress(0.5);
        this.showStatusProgress(0.6);
        this.initFileTree();
        this.initStructureTree();
        this.initQueryTree();
        this.showStatusProgress(0.7);
        this.initElePropsDialog();
        this.showStatusProgress(0.8);
        System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        this.mdiDesktopPane.addInternalFrameActivatedListener(new InternalFrameActivatedListener(){

            @Override
            public void internalFrameActivated(InternalFrameActivatedEvent evt) {
                FormDesigner.this.jMDIDesktopPaneInternalFrameActivated(evt);
            }
        });
        try {
            MediaTracker mt = new MediaTracker(new JPanel());
            mt.addImage(Icons.IMG_IMAGE_SAMPLE, 0);
            mt.waitForID(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ImageElement.setImgDef(Icons.IMG_IMAGE_SAMPLE);
        this.getOwner().setDefaultCloseOperation(0);
        this.getOwner().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                FormDesigner.this.showStatusElementName("");
                FormDesigner.this.showStatusMousePosition("");
                FormDesigner.this.showStatusDeltaMouse("");
            }
        });
        this.showStatusProgress(0.9);
        this.initKDFPropsDialog();
        this.mdiDesktopPane.setBackground(Misc.DESIGNER_BACKGROUND);
        AbstractDesignerAction actionShowNavigate = this.getActionManager().getDesignerAction("showNavigate");
        actionShowNavigate.setActionEnable(true);
        if (this.getProperty("showNavigation", true)) {
            actionShowNavigate.doAction();
        } else {
            actionShowNavigate.doAction();
            actionShowNavigate.doAction();
        }
        this.showStatusProgress(1.0);
        splash.stop();
        splash.dispose();
        this.isInit = false;
        this.fireInitCompleted();
        this.setActiveReportForm(this.getKDFFrame());
    }

    private void initFileTree() {
        KDFFileTreeNode fileroot = new KDFFileTreeNode(FormDesigner.getMLS("openedFile", "\u5f53\u524d\u6587\u4ef6"));
        this.filesTree = new KDTree((ITreeNode)fileroot, false);
        this.filesTree.addTreeSelectionListener((TreeSelectionListener)this.formListener);
        this.filesTree.addMouseListener((MouseListener)this.formListener);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.filesTree);
        this.filesTree.setCollapsePathDisabled(true);
        this.filesTree.setRootVisible(false);
    }

    private void initStructureTree() {
        KDFStructTreeNode docroot = new KDFStructTreeNode(FormDesigner.getMLS("reportStruct", "\u8868\u5355"));
        this.docStructureTree = new KDTree((ITreeNode)docroot, false);
        this.docStructureTree.setRootVisible(false);
        this.docStructureTree.setShowsRootHandles(true);
        this.initStructureTreeLintener();
        this.docStructureTree.addTreeSelectionListener((TreeSelectionListener)this.formListener);
        this.panDocStructure.add((Component)new KDScrollPane((Component)this.docStructureTree), (Object)"Center");
    }

    private void initQueryTree() {
        KDFStructTreeNode root = new KDFStructTreeNode(FormDesigner.getMLS("queryObject", "\u67e5\u8be2\u5bf9\u8c61"));
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)((Object)root));
        model.setAsksAllowsChildren(true);
        this.queryTree = new QueryTree(this);
        this.queryTree.setModel((TreeModel)model);
        this.queryTree.setRootVisible(false);
        this.queryTree.setShowsRootHandles(true);
        this.queryTree.setShowCheckBox(false);
        this.queryTree.setSyncChecked(true);
        KDTreeView tv = new KDTreeView((KDTree)this.queryTree);
        tv.setShowControlPanel(false);
        this.panQuery.add((Component)tv, (Object)"Center");
    }

    public void updataQueryTree(KDFFrame frame) {
        DataUtil.updataQueryTree(frame, this.queryTree);
    }

    private void initStatusBar() {
        this.statusBar = new KDStatusBar();
        SimpleStatusBarPart part0 = new SimpleStatusBarPart();
        SimpleStatusBarPart part1 = new SimpleStatusBarPart();
        SimpleStatusBarPart part2 = new SimpleStatusBarPart();
        SimpleStatusBarPart part3 = new SimpleStatusBarPart();
        this.statusBar.addPart(part0);
        this.statusBar.addPart(part1);
        this.statusBar.addPart(part2);
        this.statusBar.addPart(part3);
        part0.setHgrap(0);
        part1.setHgrap(0);
        part2.setHgrap(0);
        part3.setHgrap(0);
        part0.setPreferredSize(new Dimension(500, 30));
        part1.setPreferredSize(new Dimension(100, 30));
        part2.setPreferredSize(new Dimension(100, 30));
        part3.setPreferredSize(new Dimension(100, 30));
        SimpleStatusBarRenderer rdElementPrompt = new SimpleStatusBarRenderer();
        part0.addRenderer((ISimpleStatusBarRenderer)rdElementPrompt, (Object)"elementPrompt");
        this.pgb = new JProgressBar(0, 100);
        this.pgb.setPreferredSize(new Dimension(96, 17));
        SimpleStatusBarRenderer rdProgress = new SimpleStatusBarRenderer((JComponent)this.pgb, "progressBar");
        part1.addRenderer((ISimpleStatusBarRenderer)rdProgress, (Object)"progress");
        SimpleStatusBarRenderer rdMousePosition = new SimpleStatusBarRenderer();
        part2.addRenderer((ISimpleStatusBarRenderer)rdMousePosition, (Object)"mousePosition");
        SimpleStatusBarRenderer rdDeltaMouse = new SimpleStatusBarRenderer();
        part3.addRenderer((ISimpleStatusBarRenderer)rdDeltaMouse, (Object)"deltaMouse");
        ((FlowLayout)part0.getLayout()).setVgap(0);
        ((FlowLayout)part1.getLayout()).setVgap(0);
        ((FlowLayout)part2.getLayout()).setVgap(0);
        ((FlowLayout)part3.getLayout()).setVgap(0);
        ((FlowLayout)part1.getLayout()).setHgap(0);
        this.statusBar.setPreferredSize(new Dimension(800, 25));
        this.getOwner().setStatusBar(this.statusBar);
    }

    private void showStatusProgress(double percent) {
        this.prgBarPercent = percent;
    }

    private void startStatusProgressTimer() {
        final Timer timer = new Timer(50, null);
        timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int value = FormDesigner.this.pgb.getValue();
                if (value < FormDesigner.this.pgb.getMaximum()) {
                    FormDesigner.this.pgb.setValue((int)(FormDesigner.this.prgBarPercent * (double)FormDesigner.this.pgb.getMaximum()));
                } else if (timer.getDelay() >= 200) {
                    timer.stop();
                    FormDesigner.this.pgb.setValue(0);
                } else {
                    timer.setDelay(200);
                }
            }
        });
        timer.start();
    }

    public void showStatusProgress() {
        this.pgb.setValue(0);
        final Timer timer = new Timer(1, null);
        timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value = FormDesigner.this.pgb.getValue();
                if (value < FormDesigner.this.pgb.getMaximum()) {
                    SecureRandom sc = new SecureRandom();
                    int delay = sc.nextInt(300);
                    timer.setDelay(delay);
                    value = (int)((double)value + (double)FormDesigner.this.pgb.getMaximum() * 0.2);
                    FormDesigner.this.pgb.setValue(value);
                } else if (timer.getDelay() >= 500) {
                    timer.stop();
                    FormDesigner.this.pgb.setValue(0);
                } else {
                    timer.setDelay(500);
                }
            }
        });
        timer.start();
    }

    public void showStatusElementName(String text) {
        this.statusBar.setRendererText(text, (Object)"elementPrompt");
    }

    public void showStatusMousePosition(String text) {
        this.statusBar.setRendererText(text, (Object)"mousePosition");
    }

    public void showStatusDeltaMouse(String text) {
        this.statusBar.setRendererText(text, (Object)"deltaMouse");
    }

    private void addPopItem(KDMenuItem menuItem) {
        if (!(menuItem instanceof AbstractDesignerAction.NoMenuItem)) {
            this.docStructureTree.getPopupMenu().add((JMenuItem)menuItem);
        }
    }

    private void initStructureTreeLintener() {
        this.docStructureTree.setSelectionModel((TreeSelectionModel)new KDFTreeSelectionModel());
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selPath;
                if (e.getClickCount() == 2 && !FormDesigner.this.getElementPropertiesDialog().isVisible() && (selPath = FormDesigner.this.docStructureTree.getPathForLocation(e.getX(), e.getY())) != null && selPath.getPath().length > 1) {
                    FormDesigner.this.getElementPropertiesDialog().updateSelection(FormDesigner.this.isHeadFooter);
                    FormDesigner.this.getElementPropertiesDialog().setVisible(true);
                }
            }
        };
        this.docStructureTree.addMouseListener((MouseListener)ml);
        this.docStructureTree.setShowPopMenuDefaultItem(false);
        this.treePopItemCut = MenuItemFactory.create(this.getActionManager().getDesignerAction("cut"));
        this.treePopItemCopy = MenuItemFactory.create(this.getActionManager().getDesignerAction("copy"));
        this.treePopItemPaste = MenuItemFactory.create(this.getActionManager().getDesignerAction("paste"));
        this.treePopItemDelete = MenuItemFactory.create(this.getActionManager().getDesignerAction("delete"));
        this.treePopItemCopyStyle = MenuItemFactory.create(this.getActionManager().getDesignerAction("copyStyle"));
        this.treePopItemPasteStyle = MenuItemFactory.create(this.getActionManager().getDesignerAction("pasteStyle"));
        this.treePopItemProperty = MenuItemFactory.create(this.getActionManager().getDesignerAction("objectProperties"));
        this.addPopItem(this.treePopItemCut);
        this.addPopItem(this.treePopItemCopy);
        this.addPopItem(this.treePopItemPaste);
        this.addPopItem(this.treePopItemDelete);
        this.docStructureTree.getPopupMenu().add((Component)new KDSeparator());
        this.addPopItem(this.treePopItemCopyStyle);
        this.addPopItem(this.treePopItemPasteStyle);
        this.docStructureTree.getPopupMenu().add((Component)new KDSeparator());
        this.addPopItem(this.treePopItemProperty);
        this.docStructureTree.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent e) {
                if (e.getClosestPath() == null || e.getSelectionPaths() == null || e.getSelectionPaths().length == 0) {
                    return false;
                }
                if (!FormDesigner.this.docStructureTree.isPathsContainsPath(e.getSelectionPaths(), e.getClosestPath())) {
                    return false;
                }
                KDFFrame frame = (KDFFrame)((Object)FormDesigner.this.mdiDesktopPane.getSelectedFrame());
                if (frame == null) {
                    return false;
                }
                KDFStructTreeNode node = (KDFStructTreeNode)((Object)e.getClosestPath().getLastPathComponent());
                Object obj = node.getUserObject();
                if (obj instanceof Page) {
                    FormDesigner.this.treePopItemCut.setEnabled(false);
                    FormDesigner.this.treePopItemCopy.setEnabled(false);
                } else {
                    FormDesigner.this.treePopItemCut.setEnabled(true);
                    FormDesigner.this.treePopItemCopy.setEnabled(true);
                }
                if (frame.isCanPaste()) {
                    FormDesigner.this.treePopItemPaste.setEnabled(true);
                } else {
                    FormDesigner.this.treePopItemPaste.setEnabled(false);
                }
                if (obj instanceof HeadFooter || obj instanceof Page && frame.getReport().getPages().size() < 2) {
                    FormDesigner.this.treePopItemDelete.setEnabled(false);
                } else {
                    FormDesigner.this.treePopItemDelete.setEnabled(true);
                }
                if (FormDesigner.this.getStyleClipboard().isClipboardEmpty()) {
                    FormDesigner.this.treePopItemPasteStyle.setEnabled(false);
                } else {
                    FormDesigner.this.treePopItemPasteStyle.setEnabled(true);
                }
                if (frame.getSelectedElements().size() > 1) {
                    FormDesigner.this.treePopItemCopyStyle.setEnabled(false);
                } else {
                    FormDesigner.this.treePopItemCopyStyle.setEnabled(true);
                }
                FormDesigner.this.addDocumentTreePopupMenuItem(e.getClosestPath());
                return true;
            }
        });
    }

    private void addDocumentTreePopupMenuItem(final TreePath path) {
        ArrayList pages;
        final KDFStructTreeNode node = (KDFStructTreeNode)((Object)path.getLastPathComponent());
        final JPopupMenu menu = this.docStructureTree.getPopupMenu();
        final Object obj = node.getUserObject();
        final KDF kdf = ((KDFFrame)((Object)this.mdiDesktopPane.getSelectedFrame())).getReport();
        if (obj instanceof Page && !(obj instanceof HeadFooter) && (pages = kdf.getPages()).size() > 1) {
            final KDSeparator sp = new KDSeparator();
            menu.add((Component)sp, 0);
            menu.addPopupMenuListener((PopupMenuListener)new PopupMenuAdapter(){

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    menu.remove((Component)sp);
                    menu.removePopupMenuListener((PopupMenuListener)((Object)this));
                }
            });
            if (!obj.equals(pages.get(pages.size() - 1))) {
                final KDMenuItem itemDown = new KDMenuItem(FormDesigner.getMLS("moveDown", "\u4e0b\u79fb"));
                itemDown.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int idx = kdf.getPages().indexOf(obj);
                        kdf.getPages().remove(idx);
                        kdf.getPages().add(idx + 1, obj);
                        KDFStructTreeNode parentNode = (KDFStructTreeNode)((Object)node.getParent());
                        int nodeIdx = parentNode.getIndex((TreeNode)((Object)node));
                        boolean isExpanded = FormDesigner.this.docStructureTree.isExpanded(path);
                        FormDesigner.this.docStructureTree.removeNodeFromParent((MutableTreeNode)((Object)node));
                        FormDesigner.this.docStructureTree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)parentNode), nodeIdx + 1);
                        FormDesigner.this.docStructureTree.setSelectionNode((DefaultKingdeeTreeNode)node);
                        if (isExpanded) {
                            FormDesigner.this.docStructureTree.expandPath(path);
                        }
                        kdf.setDirty(true);
                    }
                });
                menu.add((Component)itemDown, 0);
                menu.addPopupMenuListener((PopupMenuListener)new PopupMenuAdapter(){

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        menu.remove((Component)itemDown);
                        menu.removePopupMenuListener((PopupMenuListener)((Object)this));
                    }
                });
            }
            if (!obj.equals(pages.get(0))) {
                final KDMenuItem itemUp = new KDMenuItem(FormDesigner.getMLS("moveUp", "\u4e0a\u79fb"));
                itemUp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int idx = kdf.getPages().indexOf(obj);
                        kdf.getPages().remove(idx);
                        kdf.getPages().add(idx - 1, obj);
                        KDFStructTreeNode parentNode = (KDFStructTreeNode)((Object)node.getParent());
                        int nodeIdx = parentNode.getIndex((TreeNode)((Object)node));
                        boolean isExpanded = FormDesigner.this.docStructureTree.isExpanded(path);
                        FormDesigner.this.docStructureTree.removeNodeFromParent((MutableTreeNode)((Object)node));
                        FormDesigner.this.docStructureTree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)parentNode), nodeIdx - 1);
                        FormDesigner.this.docStructureTree.setSelectionNode((DefaultKingdeeTreeNode)node);
                        if (isExpanded) {
                            FormDesigner.this.docStructureTree.expandPath(path);
                        }
                        kdf.setDirty(true);
                    }
                });
                menu.add((Component)itemUp, 0);
                menu.addPopupMenuListener((PopupMenuListener)new PopupMenuAdapter(){

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        menu.remove((Component)itemUp);
                        menu.removePopupMenuListener((PopupMenuListener)((Object)this));
                    }
                });
            }
        }
    }

    private void initToolBar() {
        KDToolBar[] bars = this.actionManager.createToolBars();
        this.normalToolBar = bars[0];
        this.getOwner().addToolBar((JToolBar)this.normalToolBar);
        for (int i = 1; i < bars.length; ++i) {
            this.getOwner().addToolBar((JToolBar)bars[i]);
        }
        this.btnToolboxPointer = new KDToggleButton();
        this.btnToolboxLoop = new KDToggleButton();
        this.btnToolboxGroup = new KDToggleButton();
        this.btnToolboxTable = new KDToggleButton();
        this.btnToolboxText = new KDToggleButton();
        this.btnToolboxField = new KDToggleButton();
        this.btnToolboxVariant = new KDToggleButton();
        this.btnToolboxFormula = new KDToggleButton();
        this.btnToolboxLine = new KDToggleButton();
        this.btnToolboxImage = new KDToggleButton();
        this.btnToolboxChart = new KDToggleButton();
        this.normalToolBar.addSeparator();
        KDLabel lab = new KDLabel();
        lab.setPreferredSize(new Dimension(30, 1));
        this.normalToolBar.add((Component)lab);
        this.initToolboxButton(this.btnToolboxPointer, "tbtn/toolbar_finger", FormDesigner.getMLS("pointer", "\u6307\u9488"));
        if (!this.isHeadDesign) {
            this.initToolboxButton(this.btnToolboxLoop, "tbtn/toolbar_cyc", FormDesigner.getMLS("loopArea", "\u5faa\u73af\u533a"));
        }
        this.initToolboxButton(this.btnToolboxGroup, "tbtn/toolbar_grouping", FormDesigner.getMLS("group", "\u5206\u7ec4"));
        this.initToolboxButton(this.btnToolboxTable, "tbtn/toolbar_form", FormDesigner.getMLS("table", "\u8868\u683c"));
        this.initToolboxButton(this.btnToolboxText, "tbtn/toolbar_textbox", FormDesigner.getMLS("staticText", "\u6587\u672c"));
        if (!this.isHeadDesign) {
            this.initToolboxButton(this.btnToolboxField, "tbtn/toolbar_field", FormDesigner.getMLS("field", "\u5b57\u6bb5"));
        }
        this.initToolboxButton(this.btnToolboxVariant, "tbtn/toolbar_variable", FormDesigner.getMLS("variant", "\u53d8\u91cf"));
        this.initToolboxButton(this.btnToolboxFormula, "tbtn/toolbar_dingba", FormDesigner.getMLS("formula", "\u516c\u5f0f"));
        this.initToolboxButton(this.btnToolboxLine, "tbtn/toolbar_line", FormDesigner.getMLS("line", "\u76f4\u7ebf"));
        this.initToolboxButton(this.btnToolboxImage, "tbtn/toolbar_figure", FormDesigner.getMLS("image", "\u56fe\u50cf"));
        this.initToolboxButton(this.btnToolboxChart, "tbtn/toolbar_new", FormDesigner.getMLS("chart", "\u56fe\u8868"));
        this.normalToolBar.validate();
        this.normalToolBar.repaint();
    }

    private void initToolboxButton(KDToggleButton btn, String img, String toolTip) {
        btn.setIcon((Icon)Icons.createIcon(img + ".gif"));
        btn.setEnabled(false);
        btn.setToolTipText(toolTip);
        btn.addActionListener((ActionListener)this.formListener);
        this.normalToolBar.add((Component)btn);
    }

    private void initMenu() {
        this.actionManager.buildMenuBar(this.mdiMenuBar);
        this.actionManager.getMenu("edit").addMenuListener((MenuListener)new MenuAdapter(){

            public void menuSelected(MenuEvent e) {
                if (FormDesigner.this.getKDFFrame() != null) {
                    FormDesigner.this.updatePasteStyleMenuEnabled(FormDesigner.this.getKDFFrame());
                }
            }
        });
        this.actionManager.getMenu("insert").addMenuListener((MenuListener)new MenuAdapter(){

            public void menuSelected(MenuEvent e) {
                FormDesigner.this.updateInsertMenuEnabled(FormDesigner.this.getKDFFrame());
            }
        });
        this.updateMenuRecentFile();
    }

    private void updateInsertMenuEnabled(KDFFrame frame) {
        AbstractDesignerAction actionPage = this.getActionManager().getDesignerAction("insertPage");
        AbstractDesignerAction actionLoop = this.getActionManager().getDesignerAction("insertLoop");
        AbstractDesignerAction actionGroup = this.getActionManager().getDesignerAction("insertGroup");
        AbstractDesignerAction actionTable = this.getActionManager().getDesignerAction("insertTable");
        AbstractDesignerAction actionText = this.getActionManager().getDesignerAction("insertText");
        AbstractDesignerAction actionField = this.getActionManager().getDesignerAction("insertField");
        AbstractDesignerAction actionVariant = this.getActionManager().getDesignerAction("insertVariant");
        AbstractDesignerAction actionFormula = this.getActionManager().getDesignerAction("insertFormula");
        AbstractDesignerAction actionLine = this.getActionManager().getDesignerAction("insertLine");
        AbstractDesignerAction actionImage = this.getActionManager().getDesignerAction("insertImage");
        AbstractDesignerAction actionChart = this.getActionManager().getDesignerAction("insertChart");
        if (frame == null) {
            actionPage.setEnabled(false);
            actionLoop.setEnabled(false);
            actionGroup.setEnabled(false);
            actionTable.setEnabled(false);
            actionText.setEnabled(false);
            actionField.setEnabled(false);
            actionVariant.setEnabled(false);
            actionFormula.setEnabled(false);
            actionLine.setEnabled(false);
            actionImage.setEnabled(false);
            actionChart.setEnabled(false);
            return;
        }
        actionPage.setEnabled(true);
        actionLoop.setEnabled(frame.isCanInsertElement(11));
        actionGroup.setEnabled(frame.isCanInsertElement(12));
        actionTable.setEnabled(frame.isCanInsertElement(10));
        actionText.setEnabled(frame.isCanInsertElement(3));
        actionField.setEnabled(frame.isCanInsertElement(4));
        actionVariant.setEnabled(frame.isCanInsertElement(14));
        actionFormula.setEnabled(frame.isCanInsertElement(13));
        actionLine.setEnabled(frame.isCanInsertElement(5));
        actionImage.setEnabled(frame.isCanInsertElement(2));
        actionChart.setEnabled(frame.isCanInsertElement(9));
    }

    private void initKDFPropsDialog() {
        if (this.getOwner() instanceof JFrame) {
            this.rpf = new KDFPropsDialog((JFrame)((Object)this.getOwner()));
        } else if (this.getOwner() instanceof JDialog) {
            this.rpf = new KDFPropsDialog((JDialog)((Object)this.getOwner()));
        }
    }

    private void initElePropsDialog() {
        if (this.getOwner() instanceof JFrame) {
            this.elementPropertiesDialog = new ElePropsDialog((JFrame)((Object)this.getOwner()), false);
        } else if (this.getOwner() instanceof JDialog) {
            this.elementPropertiesDialog = new ElePropsDialog((JDialog)((Object)this.getOwner()), false);
        }
    }

    private void documentTreeValueChanged(TreeSelectionEvent evt) {
        if (this.dontHandleEvent) {
            return;
        }
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            ArrayList<ReportElement> elementsToSelect = new ArrayList<ReportElement>();
            TreePath[] path = this.docStructureTree.getSelectionPaths();
            if (path != null) {
                for (int i = 0; i < path.length; ++i) {
                    KDFStructTreeNode elementNode = (KDFStructTreeNode)((Object)path[i].getLastPathComponent());
                    if (elementNode.getUserObject() instanceof Page) {
                        Page page = (Page)elementNode.getUserObject();
                        frame.setCurrentpage(page);
                        frame.setDefaultContainer(page);
                        continue;
                    }
                    if (elementNode.getUserObject() instanceof ReportElement) {
                        ReportElement re = (ReportElement)elementNode.getUserObject();
                        frame.setCurrentpage(re.getTopContainer());
                        elementsToSelect.add(re);
                        continue;
                    }
                    if (path.length != 1) continue;
                    frame.setSelectedElement(null);
                    return;
                }
                frame.getSelectedElements().clear();
                for (ReportElement re : elementsToSelect) {
                    frame.getSelectedElements().add(re);
                    frame.setCurrentpage(re.getTopContainer());
                    Point reRelativeTop = re.getRelativePagePosition();
                    frame.scrollRectToVisible(reRelativeTop.x, reRelativeTop.y, re.getWidth(), re.getHeight());
                }
                frame.refreshHierarchy();
                this.updateCutPasteMenuEnabled(frame);
            }
            if (this.getElementPropertiesDialog().isVisible()) {
                this.getElementPropertiesDialog().updateSelection(this.isHeadFooter);
            }
        }
    }

    private void filesTreeValueChanged(TreeSelectionEvent evt) {
        DocumentTreeEntry dtn;
        KDFFileTreeNode nodem;
        Object obj;
        TreePath path = this.filesTree.getSelectionPath();
        if (path == null) {
            return;
        }
        KDFFileTreeNode node = (KDFFileTreeNode)((Object)path.getLastPathComponent());
        if (node instanceof KDFFileTreeNode && (obj = (nodem = node).getUserObject()) != null && obj instanceof DocumentTreeEntry && (dtn = (DocumentTreeEntry)obj).getKDF() != null) {
            try {
                dtn.getKDF().setSelected(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onShowHeadFooter(boolean isHeader, boolean isChecked) {
        HeadFooter headfooter;
        KDFFrame frame = this.getKDFFrame();
        if (frame == null) {
            return;
        }
        KDFStructTreeNode root = (KDFStructTreeNode)((Object)this.docStructureTree.getModel().getRoot());
        int idx = 0;
        if (isHeader) {
            frame.getReport().setHaveHeader(isChecked);
            headfooter = frame.getReport().getHeader();
            idx = 0;
        } else {
            frame.getReport().setHaveFooter(isChecked);
            headfooter = frame.getReport().getFooter();
            int n = idx = frame.getReport().isHaveHeader() ? 1 : 0;
        }
        if (isChecked) {
            KDFStructTreeNode node = new KDFStructTreeNode(headfooter);
            this.docStructureTree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)root), idx);
            this.docHashmap.put(headfooter, node);
            this.updateDocuemtElement(node, headfooter);
        } else {
            KDFStructTreeNode node = (KDFStructTreeNode)((Object)root.getChildAt(idx));
            if (node.getUserObject().equals(headfooter)) {
                TreePath path = new TreePath(node.getPath());
                if (path.isDescendant(this.docStructureTree.getSelectionPath())) {
                    KDFStructTreeNode firstPage = (KDFStructTreeNode)((Object)this.docHashmap.get(frame.getReport().getPages().get(0)));
                    this.docStructureTree.setSelectionNode((DefaultKingdeeTreeNode)firstPage);
                }
                this.docStructureTree.removeNodeFromParent((MutableTreeNode)((Object)node));
                this.docHashmap.remove(headfooter);
            }
        }
        frame.getReport().setDirty(true);
    }

    public void onDefaultSaveToLocal(boolean saveAs) {
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            String fileName = frame.getReport().getFilename();
            if (frame.getReport().getSaveWhere() != 1) {
                frame.getReport().setFilename("");
            }
            if (!frame.saveToFile(saveAs)) {
                frame.getReport().setFilename(fileName);
            } else {
                frame.getReport().setSaveWhere(1);
            }
        }
    }

    public void doExit() {
        this.elementPropertiesDialog.dispose();
        this.getOwner().dispose();
        if (isSingleRun) {
            System.exit(0);
        }
    }

    public boolean closeAllFrame() {
        JInternalFrame[] frames = this.mdiDesktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            this.closeFrame(frames[i]);
        }
        frames = this.mdiDesktopPane.getAllFrames();
        return frames.length == 0;
    }

    public void onDefaultClose() {
        KDFFrame f = this.getKDFFrame();
        this.closeFrame((JInternalFrame)((Object)f));
    }

    private void closeFrame(JInternalFrame f) {
        if (f != null) {
            try {
                int frames = this.mdiDesktopPane.getAllFrames().length;
                f.doDefaultCloseAction();
                if (f.isClosed() && frames <= 1) {
                    this.mdiMenuBar.removeFrameButtons();
                }
                if (f.isClosed()) {
                    this.mdiDesktopPane.remove(f);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private int promptFileError(String path, String type) {
        String title = FormDesigner.getMLS("warning", "\u91d1\u8776\u63d0\u793a");
        if (type.equals("OVERWRITE")) {
            String prompt = FormDesigner.getMLS("savingDlgPrompt", "\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f");
            return MsgBox.show((Component)((Object)this), prompt, title, 68);
        }
        if (type.equals("NOTEXIST")) {
            String prompt = path + " " + FormDesigner.getMLS("fileNotExistPrompt2", "\u4e0d\u5b58\u5728\u3002");
            return MsgBox.show((Component)((Object)this), prompt, title, 17);
        }
        if (type.equals("NOTFILE")) {
            String prompt = path + " " + FormDesigner.getMLS("fileNotExistPrompt3", "\u6ca1\u6709\u6307\u5411\u4e00\u4e2a\u6587\u4ef6\u3002");
            return MsgBox.show((Component)((Object)this), prompt, title, 17);
        }
        if (type.equals("ERROR")) {
            String prompt = path + " " + FormDesigner.getMLS("fileErrorPrompt", "\u683c\u5f0f\u4e0d\u6b63\u786e\u3002");
            return MsgBox.show((Component)((Object)this), prompt, title, 17);
        }
        return -1;
    }

    public void onDefaultOpenDoc() {
        if (this.isTooManyWindows()) {
            return;
        }
        KDFileChooser jfc = new KDFileChooser(System.getProperty("KDF.dir"));
        jfc.setFileFilter((FileFilter)new CustomFileFilter(".kdrs-form", FormDesigner.getMLS("savefilter", "\u91d1\u8776\u62a5\u8868 *.kdf")));
        jfc.setMultiSelectionEnabled(true);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog((Component)((Object)this)) == 0) {
            File[] files = jfc.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                this.loadFromFile(files[i]);
            }
        }
        System.setProperty("KDF.dir", jfc.getCurrentDirectory().toString());
    }

    public com.kingdee.bos.ctrl.kdf.util.file.KDF translateKDR(InputStream input) {
        KDRFile2KDFObj r2f = new KDRFile2KDFObj();
        return this.translateK3File(input, (AbstractK3File2KDFObj)r2f);
    }

    public com.kingdee.bos.ctrl.kdf.util.file.KDF translateNDF(InputStream input) {
        NDFFile2KDFObj n2k = new NDFFile2KDFObj();
        return this.translateK3File(input, (AbstractK3File2KDFObj)n2k);
    }

    private com.kingdee.bos.ctrl.kdf.util.file.KDF translateK3File(InputStream input, AbstractK3File2KDFObj transer) {
        return transer.getKdf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File file) {
        block20: {
            String newfileName;
            block13: {
                int saveWhere;
                com.kingdee.bos.ctrl.kdf.util.file.KDF kdfDom;
                block16: {
                    block17: {
                        block14: {
                            newfileName = file.getPath();
                            if (!file.exists()) break block13;
                            kdfDom = null;
                            if (!newfileName.substring(newfileName.length() - 4).equalsIgnoreCase(".ndf")) break block14;
                            FileInputStream fis = null;
                            try {
                                fis = new FileInputStream(newfileName);
                                kdfDom = this.translateNDF(fis);
                            }
                            catch (FileNotFoundException e) {
                                try {
                                    e.printStackTrace();
                                }
                                catch (Throwable throwable) {
                                    CloseUtil.close((Closeable[])new Closeable[]{fis});
                                    throw throwable;
                                }
                                CloseUtil.close((Closeable[])new Closeable[]{fis});
                            }
                            CloseUtil.close((Closeable[])new Closeable[]{fis});
                            saveWhere = 0;
                            break block16;
                        }
                        if (!newfileName.substring(newfileName.length() - 4).equalsIgnoreCase(".kdr")) break block17;
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(newfileName);
                            kdfDom = this.translateKDR(fis);
                        }
                        catch (FileNotFoundException e) {
                            try {
                                e.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                CloseUtil.close((Closeable[])new Closeable[]{fis});
                                throw throwable;
                            }
                            CloseUtil.close((Closeable[])new Closeable[]{fis});
                        }
                        CloseUtil.close((Closeable[])new Closeable[]{fis});
                        saveWhere = 0;
                        break block16;
                    }
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(file);
                        kdfDom = this.loadKDF(file.getPath(), 1, fis);
                    }
                    catch (FileNotFoundException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            CloseUtil.close((Closeable[])new Closeable[]{fis});
                            throw throwable;
                        }
                        CloseUtil.close((Closeable[])new Closeable[]{fis});
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{fis});
                    saveWhere = 1;
                }
                if (kdfDom != null) {
                    this.loadDesignedKDF(kdfDom, newfileName, saveWhere);
                }
                break block20;
            }
            String prompt = FormDesigner.getMLS("fileNotExistPrompt1", "\u6587\u4ef6") + " " + newfileName + " " + FormDesigner.getMLS("fileNotExistPrompt2", "\u4e0d\u5b58\u5728\u3002");
            String title = FormDesigner.getMLS("warning", "\u91d1\u8776\u63d0\u793a");
            MsgBox.show((Component)((Object)this), prompt, title, 17);
        }
    }

    private boolean isLoadFileOpened(String path, int saveWhere) {
        boolean isOpened = false;
        KDFFrame kdfFrame = null;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.filesTree.getModel().getRoot();
        for (int j = 0; j < root.getChildCount(); ++j) {
            KDFFileTreeNode node = (KDFFileTreeNode)((Object)root.getChildAt(j));
            kdfFrame = ((DocumentTreeEntry)node.getUserObject()).getKDF();
            if (!kdfFrame.getReport().getFilename().equals(path)) continue;
            isOpened = true;
            break;
        }
        if (isOpened) {
            try {
                kdfFrame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            this.addRecentFile(saveWhere, path);
        }
        return isOpened;
    }

    public com.kingdee.bos.ctrl.kdf.util.file.KDF loadKDF(String path, int saveWhere, InputStream input) {
        if (!this.isLoadFileOpened(path, saveWhere)) {
            com.kingdee.bos.ctrl.kdf.util.file.KDF tempDom = null;
            try {
                tempDom = new com.kingdee.bos.ctrl.kdf.util.file.KDF(input, true);
            }
            catch (KDFException e3) {
                this.promptFileError(path, "ERROR");
            }
            catch (AssertionError e) {
                this.promptFileError(path, "ERROR");
            }
            return tempDom;
        }
        return null;
    }

    public void loadDesignedKDF(final com.kingdee.bos.ctrl.kdf.util.file.KDF kdfdom, String path, int saveWhere) {
        String tempPath = path;
        int tempWhere = saveWhere;
        if ("1.1".equals(kdfdom.getVersion()) && MsgBox.show((Component)((Object)this), FormDesigner.getMLS("promptUpgradeFromV11", "\u8be5\u6587\u6863\u4e3a\u65e7\u7248\u672c(V1.1)\uff0c\u60a8\u662f\u5426\u5e0c\u671b\u5728\u4ee5\u540e\u4fdd\u5b58\u65f6\u8986\u76d6\u73b0\u6709\u6587\u4ef6\uff1f"), FormDesigner.getMLS("warning", "\u63d0\u793a"), 68) != 0) {
            tempPath = "";
            tempWhere = 0;
        }
        final String filePath = tempPath;
        final int where = tempWhere;
        this.startStatusProgressTimer();
        new Thread(){

            @Override
            public void run() {
                FormDesigner.this.showStatusProgress(0.3);
                KDF report = new KDF();
                IDataManager dm = FormDesigner.this.getDataManagerFactory().create();
                dm.loadData(kdfdom);
                report.setDataManager(dm);
                try {
                    report.load(kdfdom);
                    report.setFilename(filePath);
                    report.setSaveWhere(where);
                    FormDesigner.this.showStatusProgress(0.6);
                    FormDesigner.this.openNewReportWindow(report);
                    FormDesigner.this.showStatusProgress(0.8);
                    FormDesigner.this.addRecentFile(where, filePath);
                    FormDesigner.this.showStatusProgress(1.0);
                }
                catch (KDFException e) {
                    e.printStackTrace();
                    MsgBox.show((Component)((Object)FormDesigner.this), e.getMessage(), FormDesigner.getMLS("warning", "\u91d1\u8776\u63d0\u793a"), 17);
                    FormDesigner.this.showStatusProgress(1.0);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    MsgBox.show((Component)((Object)FormDesigner.this), e.getMessage(), FormDesigner.getMLS("warning", "\u91d1\u8776\u63d0\u793a"), 17);
                    FormDesigner.this.showStatusProgress(1.0);
                }
            }
        }.start();
    }

    public void onAddPage() {
        if (this.mdiDesktopPane.getSelectedFrame() != null && this.mdiDesktopPane.getSelectedFrame() instanceof KDFFrame) {
            KDFFrame kdf = (KDFFrame)((Object)this.mdiDesktopPane.getSelectedFrame());
            Page page = new Page(kdf.getReport(), kdf.getReport().getUniqueName(15), 0, 0);
            kdf.getReport().updatePageSize(page);
            kdf.getReport().addPage(page);
            ReportElementChangedEvent event = new ReportElementChangedEvent(kdf, page, 2);
            kdf.fireReportListenerReportElementsChanged(event);
            page.setAliasName(kdf.getReport().getUniqueAliasName(15));
            page.firstBuildQuean();
            FormDesigner.initReportElementListener(this, kdf.getReport(), page);
            this.docStructureTree.removeTreeSelectionListener((TreeSelectionListener)this.formListener);
            Page re = page;
            KDFStructTreeNode node = (KDFStructTreeNode)((Object)this.docHashmap.get(re));
            this.docStructureTree.setSelectionNode((DefaultKingdeeTreeNode)node);
            this.docStructureTree.addTreeSelectionListener((TreeSelectionListener)this.formListener);
            if (this.getElementPropertiesDialog().isVisible()) {
                this.getElementPropertiesDialog().updateSelection();
            }
            kdf.getReport().setDirty(true);
        }
    }

    private void toolboxActionPerformedPointer(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxPointer);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(-1, false);
        }
    }

    private void toolboxActionPerformedLoopArea(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxLoop);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(11, (e.getModifiers() & 2) != 0);
        }
    }

    private void toolboxActionPerformedGroup(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxGroup);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(12, (e.getModifiers() & 2) != 0);
        }
    }

    private void toolboxActionPerformedTable(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxTable);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(10, (e.getModifiers() & 2) != 0);
        }
    }

    private void toolboxActionPerformedStaticText(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxText);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(3, (e.getModifiers() & 2) != 0);
        }
    }

    private void toolboxActionPerformedField(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxField);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(4, (e.getModifiers() & 2) != 0);
        }
    }

    private void toolboxActionPerformedVariant(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxVariant);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(14, (e.getModifiers() & 2) != 0);
        }
    }

    private void toolboxActionPerformedFormula(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxFormula);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(13, (e.getModifiers() & 2) != 0);
        }
    }

    private void toolboxActionPerformedLine(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxLine);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(5, (e.getModifiers() & 2) != 0);
        }
    }

    private void toolboxActionPerformedImage(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxImage);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(2, (e.getModifiers() & 2) != 0);
        }
    }

    private void toolboxActionPerformedChart(ActionEvent e) {
        this.setActiveTool((Component)this.btnToolboxChart);
        KDFFrame frame = this.getKDFFrame();
        if (frame != null) {
            frame.setNewObjectType(9, (e.getModifiers() & 2) != 0);
        }
    }

    public void setCutCopyEnabled(boolean enabled) {
        this.getActionManager().getDesignerAction("cut").setEnabled(enabled);
        this.getActionManager().getDesignerAction("copy").setEnabled(enabled);
        this.getActionManager().getDesignerAction("delete").setEnabled(enabled);
    }

    public void setPasteEnebled(boolean enabled) {
        this.getActionManager().getDesignerAction("paste").setEnabled(enabled);
    }

    public void setUndoEnebled(boolean enabled) {
        this.getActionManager().getDesignerAction("undo").setEnabled(enabled);
    }

    public void setRedoEnebled(boolean enabled) {
        this.getActionManager().getDesignerAction("redo").setEnabled(enabled);
    }

    public void setSaveEnebled(boolean enabled) {
        this.getActionManager().getDesignerAction("save").setEnabled(enabled);
    }

    public void onDefaultNewDoc(String formName) {
        if (this.isTooManyWindows()) {
            return;
        }
        this.initKDFPropsDialog();
        this.rpf.setReportName(formName);
        if (this.rpf.showDialog()) {
            KDF newkdf = new KDF();
            newkdf.setDataManager(this.getDataManagerFactory().create());
            newkdf.setOrientation(this.rpf.getOrientation());
            newkdf.setName(this.rpf.getReportName());
            newkdf.setReportFormat(this.rpf.getPaperName());
            newkdf.setTopMargin(this.rpf.getTopMargin());
            newkdf.setLeftMargin(this.rpf.getLeftMargin());
            newkdf.setRightMargin(this.rpf.getRightMargin());
            newkdf.setBottomMargin(this.rpf.getBottomMargin());
            if (this.rpf.getOrientation().equals("LANDSCAPE")) {
                newkdf.setWidth(this.rpf.getReportHeight());
                newkdf.setHeight(this.rpf.getReportWidth());
            } else {
                newkdf.setWidth(this.rpf.getReportWidth());
                newkdf.setHeight(this.rpf.getReportHeight());
            }
            newkdf.setPureHeightLom(this.rpf.getContentHeight());
            newkdf.setHeightLimitless(this.rpf.isHeightLimitLess());
            newkdf.setWidthLimitless(this.rpf.isWidthLimitLess());
            newkdf.setDynamicPaper(this.rpf.isDynamicPaper());
            Page page = new Page(newkdf, newkdf.getUniqueName(15), 0, 0);
            newkdf.updatePageSize(page);
            page.setAliasName(newkdf.getUniqueAliasName(15));
            page.firstBuildQuean();
            HeadFooter header = new HeadFooter(newkdf, true, 0, 0);
            newkdf.updatePageSize(header);
            header.setHeightLom(page.getHeightLom() / 3);
            HeadFooter footer = new HeadFooter(newkdf, false, 0, 0);
            newkdf.updatePageSize(footer);
            footer.setHeightLom(page.getHeightLom() / 3);
            header.firstBuildQuean();
            footer.firstBuildQuean();
            newkdf.setHeader(header);
            newkdf.setFooter(footer);
            newkdf.addPage(page);
            this.openNewReportWindow(newkdf);
        }
    }

    public KDF openKDF(com.kingdee.bos.ctrl.kdf.util.file.KDF kdfdom) {
        KDF newkdf = new KDF();
        newkdf.setDataManager(this.getDataManagerFactory().create());
        try {
            newkdf.load(kdfdom);
        }
        catch (KDFException e) {
            e.printStackTrace();
        }
        KDFFrame kdf = new KDFFrame(newkdf);
        kdf.addReportListener(this);
        kdf.setVisible(true);
        this.mdiDesktopPane.add((Component)((Object)kdf), JLayeredPane.DEFAULT_LAYER);
        this.mdiDesktopPane.getDesktopManager().activateFrame((JInternalFrame)((Object)kdf));
        kdf.getMainFrame();
        if (newkdf.getPages().size() > 0) {
            kdf.setCurrentpage((Page)newkdf.getPages().get(0));
        }
        try {
            kdf.setSelected(true);
            kdf.setMaximum(true);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        return newkdf;
    }

    private void openNewReportWindow(KDF newkdf) {
        KDFFrame frame = new KDFFrame(newkdf);
        frame.setFileSaver(this.getFileSaver());
        frame.setVisible(true);
        frame.addReportListener(this);
        frame.setMenu(this.mdiMenuBar);
        this.mdiDesktopPane.add((Component)((Object)frame), JLayeredPane.DEFAULT_LAYER);
        this.mdiDesktopPane.getDesktopManager().activateFrame((JInternalFrame)((Object)frame));
        frame.getReport().initAllElementListener();
        try {
            frame.setMaximum(true);
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        int f_num = this.mdiDesktopPane.getAllFrames().length;
        RadioButtonMenuItem menuItem = new RadioButtonMenuItem(frame, f_num + ". " + frame.getTitle());
        menuItem.setMnemonic((f_num + "").charAt(0));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)(f_num + "").charAt(0), 8));
        KDMenu mnuWin = this.getActionManager().getMenu("window");
        mnuWin.insert((JMenuItem)((Object)menuItem), mnuWin.getMenuComponentCount());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormDesigner.this.actionPerformedFrameList(evt);
            }
        });
        this.buttonGroupFramesList.add((AbstractButton)((Object)menuItem));
        menuItem.setSelected(true);
        this.updateMenuWindowEnabled();
        DocumentTreeEntry dte = new DocumentTreeEntry(frame);
        KDFFileTreeNode node = new KDFFileTreeNode(dte);
        this.filesTree.addNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)((KDFFileTreeNode)((Object)this.filesTree.getModel().getRoot()))));
        frame.getReport().setDirty(false);
        this.filesTree.setSelectionNode((DefaultKingdeeTreeNode)node);
        this.docStructureTree.removeTreeSelectionListener((TreeSelectionListener)this.formListener);
        ReportElement re = (ReportElement)frame.getReport().getPages().get(0);
        KDFStructTreeNode nodeRe = (KDFStructTreeNode)((Object)this.docHashmap.get(re));
        this.docStructureTree.setSelectionNode((DefaultKingdeeTreeNode)nodeRe);
        this.docStructureTree.addTreeSelectionListener((TreeSelectionListener)this.formListener);
    }

    public ElePropsDialog getElementPropertiesDialog() {
        return this.elementPropertiesDialog;
    }

    public KDFPropsDialog getKDFPropsDialog() {
        return this.rpf;
    }

    private void saveConfig() {
        Element child;
        this.properties.put("fileChooserPath", System.getProperty("KDF.dir"));
        File file = GlobalLocator.getInstance().locateResourceFile(this.configFile);
        Document doc = null;
        if (file.exists()) {
            doc = Misc.buildDocFromFile(file);
        }
        if (doc == null) {
            doc = new Document();
        }
        Element root = null;
        if (doc.hasRootElement()) {
            root = doc.getRootElement();
        }
        if (root == null) {
            root = new Element("Config");
            doc.setRootElement(root);
        }
        Element props = Misc.getChildFromParent(root, "Properties");
        props.removeChildren("Property");
        for (Object key : this.properties.keySet()) {
            child = new Element("Property");
            child.addContent(this.properties.get(key) == null ? "" : this.properties.get(key).toString());
            child.setAttribute("name", key.toString());
            props.addContent((Content)child);
        }
        Element recents = Misc.getChildFromParent(root, "RecentFiles");
        recents.removeChildren("RecentFile");
        Iterator itRctfs = this.recentFilesStack.iterator();
        while (itRctfs.hasNext()) {
            Object rf = itRctfs.next();
            child = new Element("RecentFile");
            child.addContent(rf.toString());
            recents.addContent((Content)child);
        }
        Misc.saveDocToFile(doc, file);
    }

    private void loadConfig(File confFile) {
        if (!confFile.exists()) {
            return;
        }
        Document doc = Misc.buildDocFromFile(confFile);
        if (doc == null) {
            return;
        }
        Element root = null;
        if (doc.hasRootElement()) {
            root = doc.getRootElement();
        }
        if (root != null) {
            Element props = Misc.getChildFromParent(root, "Properties");
            List propsChildren = props.getChildren("Property");
            for (Element prop : propsChildren) {
                String propName = prop.getAttributeValue("name");
                String propValue = prop.getTextTrim();
                if (StringUtil.isEmptyString((String)propName) || StringUtil.isEmptyString((String)propValue)) continue;
                this.properties.put(propName, propValue);
            }
            Element recents = Misc.getChildFromParent(root, "RecentFiles");
            List recentChildren = recents.getChildren("RecentFile");
            Object[] allRecent = recentChildren.toArray();
            for (int i = allRecent.length - 1; i >= 0; --i) {
                RecentFile recent = new RecentFile(((Element)allRecent[i]).getTextTrim());
                this.recentFilesStack.push(recent);
            }
        }
        System.setProperty("KDF.dir", this.getProperty("fileChooserPath", ""));
    }

    @Override
    public void reportElementsChanged(ReportElementChangedEvent evt) {
        if (evt.getType() == 3) {
            ReportElement re = evt.getElement();
            KDFStructTreeNode node = (KDFStructTreeNode)((Object)this.docHashmap.get(re));
            if (node != null) {
                node.setText(re.getAliasName());
                ((KingdeeTreeModel)this.docStructureTree.getModel()).nodeChanged((TreeNode)((Object)node));
            }
        } else if (evt.getType() == 1) {
            ReportElement re = evt.getElement();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.docHashmap.get(re);
            if (node != null) {
                this.docStructureTree.removeTreeSelectionListener((TreeSelectionListener)this.formListener);
                this.docStructureTree.removeNodeFromParent((MutableTreeNode)node);
                this.docStructureTree.addTreeSelectionListener((TreeSelectionListener)this.formListener);
                this.docHashmap.remove(re);
                if (re instanceof Page) {
                    KDFStructTreeNode firstPage = (KDFStructTreeNode)((Object)this.docHashmap.get(evt.getJReportFrame().getReport().getPages().get(0)));
                    this.docStructureTree.setSelectionNode((DefaultKingdeeTreeNode)firstPage);
                }
            }
        } else if (evt.getType() == 2) {
            ReportElement re = evt.getElement();
            KDFStructTreeNode node = new KDFStructTreeNode(re);
            if (re.getParent() != re) {
                KDFStructTreeNode nodeParent = (KDFStructTreeNode)((Object)this.docHashmap.get(re.getParent()));
                if (nodeParent != null) {
                    this.docStructureTree.addNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)nodeParent));
                    this.docHashmap.put(re, node);
                }
            } else {
                KDFStructTreeNode nodeParent = (KDFStructTreeNode)((Object)this.docStructureTree.getModel().getRoot());
                this.docStructureTree.addNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)nodeParent));
                this.docHashmap.put(re, node);
            }
        }
    }

    @Override
    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
        this.setDontHandleEvent(true);
        this.docStructureTree.getSelectionModel().clearSelection();
        this.setDontHandleEvent(false);
        ArrayList array = evt.getSelectedElements();
        Iterator it = array.iterator();
        this.docStructureTree.removeTreeSelectionListener((TreeSelectionListener)this.formListener);
        this.docStructureTree.setSelectionPath(null);
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        while (it.hasNext()) {
            ReportElement re = (ReportElement)it.next();
            KDFStructTreeNode node = (KDFStructTreeNode)((Object)this.docHashmap.get(re));
            paths.add(new TreePath(node.getPath()));
        }
        this.docStructureTree.addSelectionPaths(paths.toArray(new TreePath[0]));
        this.docStructureTree.addTreeSelectionListener((TreeSelectionListener)this.formListener);
        if (paths.size() > 0) {
            this.docStructureTree.scrollPathToVisible((TreePath)paths.get(0));
        }
        this.fireReportElementsSelectionChanged(evt);
    }

    private boolean isDontHandleEvent() {
        return this.dontHandleEvent;
    }

    private void setDontHandleEvent(boolean dontHandleEvent) {
        this.dontHandleEvent = dontHandleEvent;
    }

    public void updateUndoMenu(KDFFrame kdf) {
        AbstractDesignerAction actionUndo = this.getActionManager().getDesignerAction("undo");
        AbstractDesignerAction actionRedo = this.getActionManager().getDesignerAction("redo");
        actionUndo.getMenuItem().setText(FormDesigner.getMLS("undo", "\u64a4\u9500"));
        actionRedo.getMenuItem().setText(FormDesigner.getMLS("redo", "\u6062\u590d"));
        if (kdf == null) {
            actionUndo.setEnabled(false);
            actionRedo.setEnabled(false);
            return;
        }
        if (kdf.getUndoOperation() != null) {
            actionUndo.setEnabled(true);
            actionUndo.getMenuItem().setText(FormDesigner.getMLS("undo", "\u64a4\u9500") + " " + kdf.getUndoOperation());
        } else {
            actionUndo.setEnabled(false);
        }
        if (kdf.getRedoOperation() != null) {
            actionRedo.setEnabled(true);
            actionRedo.getMenuItem().setText(FormDesigner.getMLS("redo", "\u6062\u590d") + " " + kdf.getRedoOperation());
        } else {
            actionRedo.setEnabled(false);
        }
    }

    private void updatePasteStyleMenuEnabled(KDFFrame kdf) {
        if (kdf != null) {
            this.getActionManager().getDesignerAction("copyStyle").setEnabled(kdf.getSelectedElements().size() <= 1);
            this.getActionManager().getDesignerAction("pasteStyle").setEnabled(!this.getStyleClipboard().isClipboardEmpty());
        } else {
            this.getActionManager().getDesignerAction("copyStyle").setEnabled(false);
            this.getActionManager().getDesignerAction("pasteStyle").setEnabled(false);
        }
    }

    public void updateCutPasteMenuEnabled(KDFFrame kdf) {
        if (kdf == null) {
            this.setCutCopyEnabled(false);
            this.setPasteEnebled(false);
            return;
        }
        if (kdf.getSelectedElements().size() > 0) {
            this.setCutCopyEnabled(true);
        } else {
            this.setCutCopyEnabled(false);
        }
        this.setPasteEnebled(kdf.isCanPaste());
        if (kdf.getSelectedElements().size() == 0 && (kdf.getCurrentPage() instanceof HeadFooter || kdf.getReport().getPages().size() < 2)) {
            this.getActionManager().getDesignerAction("delete").setEnabled(false);
        } else {
            this.getActionManager().getDesignerAction("delete").setEnabled(true);
        }
    }

    public void updateOpenedDocumentsList() {
        JInternalFrame[] allFrames = this.mdiDesktopPane.getAllFrames();
        KDFFileTreeNode root = (KDFFileTreeNode)((Object)this.filesTree.getModel().getRoot());
        block0: for (int i = root.getChildCount() - 1; i >= 0; --i) {
            KDFFileTreeNode node = (KDFFileTreeNode)((Object)root.getChildAt(i));
            KDFFrame frame = ((DocumentTreeEntry)node.getUserObject()).getKDF();
            for (int j = allFrames.length - 1; j >= 0; --j) {
                int trueNameStart;
                if (!((Object)((Object)frame)).equals(allFrames[j])) continue;
                String filename = frame.getReport().getFilename();
                String trueName = filename.substring((trueNameStart = filename.lastIndexOf("\\")) + 1);
                trueName = trueName.equals("") ? FormDesigner.getMLS("unsaved", "\u672a\u4fdd\u5b58") : trueName;
                node.setAssociatedIcon();
                node.setText(frame.getReport().getName() + " [" + trueName + "]");
                ((DefaultTreeModel)this.filesTree.getModel()).nodeChanged((TreeNode)((Object)node));
                continue block0;
            }
        }
    }

    private void updateHeadFooterMenuItem(KDFFrame frame) {
        if (frame == null) {
            this.getActionManager().getDesignerAction("header").getMenuItem().setSelected(false);
            this.getActionManager().getDesignerAction("footer").getMenuItem().setSelected(false);
        } else {
            this.getActionManager().getDesignerAction("header").getMenuItem().setSelected(frame.getReport().isHaveHeader());
            this.getActionManager().getDesignerAction("footer").getMenuItem().setSelected(frame.getReport().isHaveFooter());
        }
    }

    public void updateMenuWindowEnabled() {
        boolean enabled = this.mdiDesktopPane.getAllFrames().length > 0;
        this.getActionManager().getDesignerAction("winCascade").setEnabled(enabled);
        this.getActionManager().getDesignerAction("winEqulity").setEnabled(enabled);
        this.getActionManager().getDesignerAction("winHorizona").setEnabled(enabled);
        this.getActionManager().getDesignerAction("winVertical").setEnabled(enabled);
        this.getActionManager().getDesignerAction("winNext").setEnabled(enabled);
        this.getActionManager().getDesignerAction("winPrevious").setEnabled(enabled);
    }

    public ArrayList getClipBoard() {
        return this.clipboards;
    }

    public void setClipBoardContent(ArrayList elements) {
        this.clipboards = elements;
    }

    public StyleClipboard getStyleClipboard() {
        return this.styleClipboard;
    }

    public void setHeadFooter(boolean isHeadFooter) {
        if (this.isHeadFooter != isHeadFooter) {
            this.isHeadFooter = isHeadFooter;
            if (isHeadFooter) {
                this.btnToolboxLoop.setEnabled(false);
                this.btnToolboxField.setEnabled(false);
            } else {
                this.btnToolboxLoop.setEnabled(true);
                this.btnToolboxField.setEnabled(true);
            }
        }
    }

    public boolean isHeadFooter() {
        return this.isHeadFooter;
    }

    public static Image getIconImage() {
        return Icons.IMG_KDFICON;
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        isSingleRun = true;
        IFormDesignerOwner frame = FormDesignerOwnerFactory.createFrame();
        frame.show();
    }

    private static String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }

    public KDFFrame getKDFFrame() {
        if (this.mdiDesktopPane.getSelectedFrame() != null && this.mdiDesktopPane.getSelectedFrame() instanceof KDFFrame) {
            return (KDFFrame)((Object)this.mdiDesktopPane.getSelectedFrame());
        }
        return null;
    }

    public boolean isInitCompleted() {
        return !this.isInit;
    }

    public void addInitCompletedListener(InitCompletedListener l) {
        this.listenerList.add(InitCompletedListener.class, l);
    }

    public void removeInitCompletedListener(InitCompletedListener l) {
        this.listenerList.remove(InitCompletedListener.class, l);
    }

    private void fireInitCompleted() {
        Object[] listeners = this.listenerList.getListenerList();
        InitCompletedEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != InitCompletedListener.class) continue;
            if (null == event) {
                event = new InitCompletedEvent(this);
            }
            ((InitCompletedListener)listeners[i + 1]).initCompleted(event);
        }
    }

    private boolean isTooManyWindows() {
        if (this.mdiDesktopPane.getAllFrames().length >= 9) {
            MsgBox.show((Component)((Object)this), FormDesigner.getMLS("promptTooManyWin", "\u6253\u5f00\u7a97\u53e3\u4e0d\u80fd\u8d85\u8fc79\u4e2a..."), FormDesigner.getMLS("warning", "\u63d0\u793a"), 129);
            return true;
        }
        return false;
    }

    private boolean getProperty(String key, boolean defaultValue) {
        if ("false".equals((String)this.properties.get(key))) {
            return false;
        }
        if ("true".equals((String)this.properties.get(key))) {
            return true;
        }
        return defaultValue;
    }

    private String getProperty(String key, String defaultValue) {
        if (this.properties.get(key) == null) {
            return defaultValue;
        }
        return this.properties.get(key).toString();
    }

    private void updateMenuRecentFile() {
        KDMenu mnuFile = this.getActionManager().getMenu("file");
        Component[] menuItems = mnuFile.getMenuComponents();
        int insertIdx = 0;
        for (int k = menuItems.length - 3; k > 0; --k) {
            if (!(menuItems[k] instanceof KDMenuItem) || !(((KDMenuItem)menuItems[k]).getUserObject() instanceof RecentFile)) {
                if (menuItems[k] instanceof KDSeparator) {
                    mnuFile.remove(menuItems[k]);
                    insertIdx = k;
                    break;
                }
                insertIdx = k + 1;
                break;
            }
            mnuFile.remove(menuItems[k]);
        }
        int idx = 1;
        Iterator itRf = this.recentFilesStack.iterator();
        if (itRf.hasNext()) {
            mnuFile.add((Component)new KDSeparator(), insertIdx++);
        }
        while (itRf.hasNext()) {
            RecentFile rf = (RecentFile)itRf.next();
            KDMenuItem menuItem = new KDMenuItem();
            menuItem.setUserObject((Object)rf);
            menuItem.setText(idx + " " + rf.getPath());
            menuItem.setMnemonic((idx + "").charAt(0));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = ((KDMenuItem)e.getSource()).getUserObject();
                    if (obj instanceof RecentFile) {
                        RecentFile rf = (RecentFile)obj;
                        FormDesigner.this.getFileLoader().load(rf.getPath(), FormDesigner.this);
                    }
                }
            });
            mnuFile.insert((JMenuItem)menuItem, insertIdx++);
            ++idx;
        }
    }

    public void addRecentFile(int saveWhere, String path) {
        if (saveWhere != 1 && saveWhere != 2 || StringUtil.isEmptyString((String)path)) {
            return;
        }
        RecentFile rf = new RecentFile(saveWhere, path);
        if (this.recentFilesStack.contains(rf)) {
            this.recentFilesStack.remove(rf);
        }
        this.recentFilesStack.push(rf);
        this.updateMenuRecentFile();
    }

    public IFormDesignerOwner getOwner() {
        return this.owner;
    }

    public MDIDesktopPane getMdiDesktopPane() {
        return this.mdiDesktopPane;
    }

    public MDIMenuBar getMdiMenuBar() {
        return this.mdiMenuBar;
    }

    public KDSplitPane getHorizontalSplitPane() {
        return this.horizontalSplitPane;
    }

    public KDTabbedPane getWizardTabbedPane() {
        return this.wizardTabbedPane;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public String getTitle() {
        return this.designerTitle;
    }

    public void setTitle(String title) {
        this.designerTitle = title;
    }

    public IFileLoader getFileLoader() {
        if (this.fileLoader == null) {
            this.fileLoader = new DefaultFileLoader();
        }
        return this.fileLoader;
    }

    public void setFileLoader(IFileLoader fileLoader) {
        this.fileLoader = fileLoader;
    }

    public IFileSaver getFileSaver() {
        if (this.fileSaver == null) {
            this.fileSaver = new DefaultFileSaver();
        }
        return this.fileSaver;
    }

    public void setFileSaver(IFileSaver fileSaver) {
        this.fileSaver = fileSaver;
    }

    public void setDataManagerFactory(IDataManagerFactory dmf) {
        this.dataManagerFactory = dmf;
    }

    public IDataManagerFactory getDataManagerFactory() {
        if (this.dataManagerFactory == null) {
            this.dataManagerFactory = new DefaultDataManagerFactory();
        }
        return this.dataManagerFactory;
    }

    public void setMetaManager(IMetaManager manager) {
        this.metaManager = manager;
    }

    public IMetaManager getMetaManager() {
        if (this.metaManager == null) {
            this.metaManager = new DefaultMetaManager();
        }
        return this.metaManager;
    }

    public void addReportListener(ReportListener l) {
        this.listenerList.add(ReportListener.class, l);
    }

    public void removeReportListener(ReportListener l) {
        this.listenerList.remove(ReportListener.class, l);
    }

    protected void fireReportElementsSelectionChanged(ReportElementsSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReportListener.class) continue;
            ((ReportListener)listeners[i + 1]).reportElementsSelectionChanged(e);
        }
    }

    public void addReportElementPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    public void removeReportElementPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    protected void fireReportElementPropertyChange(PropertyChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChanged(event);
        }
    }

    public static void initReportElementListener(final FormDesigner fd, final KDF report, IElement re) {
        re.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent e) {
                report.setDirty(true);
                fd.fireReportElementPropertyChange(e);
            }
        });
    }

    public void setSupplyVariant(byte[] filedata) {
        this.getElementPropertiesDialog().prepareVariantCtrl(filedata);
    }

    static {
        res = CtrlClassUtil.getPackageName(FormDesigner.class) + ".gui";
    }

    private class DefaultFileSaver
    implements IFileSaver {
        private DefaultFileSaver() {
        }

        @Override
        public boolean save(KDFFrame kdfframe) {
            return kdfframe.saveToFile(false);
        }
    }

    private class DefaultFileLoader
    implements IFileLoader {
        private DefaultFileLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean load(String path, FormDesigner designer) {
            boolean bl;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(path));
                com.kingdee.bos.ctrl.kdf.util.file.KDF kdf = FormDesigner.this.loadKDF(path, 1, fis);
                if (kdf != null) {
                    designer.loadDesignedKDF(kdf, path, 1);
                }
                bl = true;
            }
            catch (FileNotFoundException e) {
                boolean bl2;
                try {
                    WindowUtil.msgboxError((Object)"\u7cfb\u7edf\u627e\u4e0d\u5230\u6307\u5b9a\u6587\u4ef6\u3002", (String)"\u6253\u5f00\u6587\u4ef6", (Component)((Object)designer));
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{fis});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                return bl2;
            }
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            return bl;
        }
    }

    private class FormListener
    implements ActionListener,
    MouseListener,
    WindowListener,
    TreeSelectionListener {
        private FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (FormDesigner.this.isInit) {
                return;
            }
            if (source == FormDesigner.this.btnToolboxPointer) {
                FormDesigner.this.toolboxActionPerformedPointer(evt);
                return;
            }
            if (source == FormDesigner.this.btnToolboxLoop) {
                FormDesigner.this.toolboxActionPerformedLoopArea(evt);
            }
            if (source == FormDesigner.this.btnToolboxGroup) {
                FormDesigner.this.toolboxActionPerformedGroup(evt);
                return;
            }
            if (source == FormDesigner.this.btnToolboxTable) {
                FormDesigner.this.toolboxActionPerformedTable(evt);
                return;
            }
            if (source == FormDesigner.this.btnToolboxText) {
                FormDesigner.this.toolboxActionPerformedStaticText(evt);
                return;
            }
            if (source == FormDesigner.this.btnToolboxField) {
                FormDesigner.this.toolboxActionPerformedField(evt);
                return;
            }
            if (source == FormDesigner.this.btnToolboxVariant) {
                FormDesigner.this.toolboxActionPerformedVariant(evt);
                return;
            }
            if (source == FormDesigner.this.btnToolboxFormula) {
                FormDesigner.this.toolboxActionPerformedFormula(evt);
                return;
            }
            if (source == FormDesigner.this.btnToolboxLine) {
                FormDesigner.this.toolboxActionPerformedLine(evt);
                return;
            }
            if (source == FormDesigner.this.btnToolboxImage) {
                FormDesigner.this.toolboxActionPerformedImage(evt);
                return;
            }
            if (source == FormDesigner.this.btnToolboxChart) {
                FormDesigner.this.toolboxActionPerformedChart(evt);
                return;
            }
        }

        public void componentHidden(ComponentEvent evt) {
        }

        public void componentMoved(ComponentEvent evt) {
        }

        public void componentResized(ComponentEvent evt) {
        }

        public void componentShown(ComponentEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void windowActivated(WindowEvent evt) {
        }

        @Override
        public void windowClosed(WindowEvent evt) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (evt.getSource() == FormDesigner.this.getOwner() && FormDesigner.this.getActionManager() != null) {
                FormDesigner.this.getActionManager().getDesignerAction("exit").doAction();
            }
        }

        @Override
        public void windowDeactivated(WindowEvent evt) {
        }

        @Override
        public void windowDeiconified(WindowEvent evt) {
        }

        @Override
        public void windowIconified(WindowEvent evt) {
        }

        @Override
        public void windowOpened(WindowEvent evt) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            if (evt.getSource() == FormDesigner.this.filesTree) {
                FormDesigner.this.filesTreeValueChanged(evt);
            } else if (evt.getSource() == FormDesigner.this.docStructureTree) {
                FormDesigner.this.documentTreeValueChanged(evt);
            }
        }
    }
}

