/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.util;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.CustomFocusTraversalPolicy;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.NumberField;
import com.kingdee.bos.ctrl.kdf.printprovider.PrintInfo;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.print.attribute.standard.MediaSize;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KDFPropsDialog
extends TypicalDialog {
    private static final String[] myStringTable = new String[]{"iso-a0", "iso-a1", "iso-a2", "iso-a3", "iso-a4", "iso-a5", "iso-a6", "iso-a7", "iso-a8", "iso-a9", "iso-a10", "iso-b0", "iso-b1", "iso-b2", "iso-b3", "iso-b4", "iso-b5", "iso-b6", "iso-b7", "iso-b8", "iso-b9", "iso-b10", "jis-b0", "jis-b1", "jis-b2", "jis-b3", "jis-b4", "jis-b5", "jis-b6", "jis-b7", "jis-b8", "jis-b9", "jis-b10", "iso-c0", "iso-c1", "iso-c2", "iso-c3", "iso-c4", "iso-c5", "iso-c6", "na-letter", "na-legal", "executive", "ledger", "tabloid", "invoice", "folio", "quarto", "japanese-postcard", "oufuko-postcard", "a", "b", "c", "d", "e", "iso-designated-long", "italian-envelope", "monarch-envelope", "personal-envelope", "na-number-9-envelope", "na-number-10-envelope", "na-number-11-envelope", "na-number-12-envelope", "na-number-14-envelope", "na-6x9-envelope", "na-7x9-envelope", "na-9x11-envelope", "na-9x12-envelope", "na-10x13-envelope", "na-10x14-envelope", "na-10x15-envelope", "na-5x7", "na-8x10"};
    private KDTextField txtKDFName;
    private NumberField txtWidth;
    private NumberField txtHeight;
    private KDComboBox cmbPaper;
    private KDComboBox cmbOrientation;
    private NumberField txtTopMargin;
    private NumberField txtRightMargin;
    private NumberField txtLeftMargin;
    private NumberField txtBottomMargin;
    private KDPanel panKdfName;
    private KDPanel panPaper;
    private KDPanel panMargin;
    private KDPanel panContent;
    private KDPanel panPrinter;
    private KDLabel labWidthUnit;
    private KDLabel labHeightUnit;
    private KDCheckBox chkDynamicPaper;
    private KDCheckBox chkEconomizePaper;
    private NumberField txtContentWidth;
    private NumberField txtContentHeight;
    private KDCheckBox chkHeightLimitless;
    private String invalidChars = "\\/:*?\"<>|";
    private static String res = CtrlClassUtil.getPackageName(KDFPropsDialog.class) + ".util";

    public KDFPropsDialog(Frame parent) {
        super(parent);
    }

    public KDFPropsDialog(Dialog parent) {
        super(parent);
    }

    public KDFPropsDialog() {
    }

    protected void todoInit() {
        this.initComponents();
        this.installListener();
        this.initFocusPolicy();
        this.cmbPaper.addItem((Object)"Custom");
        this.cmbPaper.addItems((Object[])myStringTable);
        this.cmbOrientation.addItem((Object)KDFPropsDialog.getMLS("orientV", "\u7eb5\u5411"));
        this.cmbOrientation.addItem((Object)KDFPropsDialog.getMLS("orientH", "\u6a2a\u5411"));
        PrintInfo pi = new PrintInfo();
        this.setTopMargin(pi.getTopMargin());
        this.setBottomMargin(pi.getBottomMargin());
        this.setLeftMargin(pi.getLeftMargin());
        this.setRightMargin(pi.getRightMargin());
        this.setPaperName(pi.getNamedPaperSize());
        this.setReportName("Untitled_report_1");
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        KDLabelContainer lbcKDFName = CtrlSwingUtilities.createLabelContainer((JComponent)this.txtKDFName, (String)KDFPropsDialog.getMLS("kdfName", "\u62a5\u8868\u540d\u79f0"), (int)80);
        KDLabelContainer lbcPaper = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbPaper, (String)KDFPropsDialog.getMLS("paper", "\u7eb8\u5f20"), (int)80);
        KDLabelContainer lbcWidth = CtrlSwingUtilities.createLabelContainer((JComponent)((Object)this.txtWidth), (String)KDFPropsDialog.getMLS("width", "\u5bbd\u5ea6"), (int)80);
        KDLabelContainer lbcHeight = CtrlSwingUtilities.createLabelContainer((JComponent)((Object)this.txtHeight), (String)KDFPropsDialog.getMLS("height", "\u9ad8\u5ea6"), (int)80);
        KDLabelContainer lbcOrientation = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbOrientation, (String)KDFPropsDialog.getMLS("orient", "\u65b9\u5411"), (int)80);
        this.labWidthUnit.setText(KDFPropsDialog.getMLS("unitTenthMm", "(0.1\u6beb\u7c73)"));
        this.labHeightUnit.setText(KDFPropsDialog.getMLS("unitTenthMm", "(0.1\u6beb\u7c73)"));
        KDLabelContainer lbcTopMargin = CtrlSwingUtilities.createLabelContainer((JComponent)((Object)this.txtTopMargin), (String)KDFPropsDialog.getMLS("topMargin", "\u4e0a\u8fb9\u8ddd"), (int)40);
        KDLabelContainer lbcBottomMargin = CtrlSwingUtilities.createLabelContainer((JComponent)((Object)this.txtBottomMargin), (String)KDFPropsDialog.getMLS("bottomMargin", "\u4e0b\u8fb9\u8ddd"), (int)40);
        KDLabelContainer lbcLeftMargin = CtrlSwingUtilities.createLabelContainer((JComponent)((Object)this.txtLeftMargin), (String)KDFPropsDialog.getMLS("leftMargin", "\u5de6\u8fb9\u8ddd"), (int)40);
        KDLabelContainer lbcRightMargin = CtrlSwingUtilities.createLabelContainer((JComponent)((Object)this.txtRightMargin), (String)KDFPropsDialog.getMLS("rightMargin", "\u53f3\u8fb9\u8ddd"), (int)40);
        KDLabelContainer lbcContentHeight = CtrlSwingUtilities.createLabelContainer((JComponent)((Object)this.txtContentHeight), (String)KDFPropsDialog.getMLS("height", "\u9ad8\u5ea6"), (int)80);
        KDLabelContainer lbcContentWidth = CtrlSwingUtilities.createLabelContainer((JComponent)((Object)this.txtContentWidth), (String)KDFPropsDialog.getMLS("width", "\u5bbd\u5ea6"), (int)80);
        this.panKdfName.setLayout((LayoutManager)new BorderLayout());
        this.panKdfName.add((Component)lbcKDFName, (Object)"North");
        this.panPaper.setLayout(null);
        this.panPaper.add((Component)lbcPaper);
        this.panPaper.add((Component)lbcWidth);
        this.panPaper.add((Component)lbcHeight);
        this.panPaper.add((Component)this.labWidthUnit);
        this.panPaper.add((Component)this.labHeightUnit);
        this.panPaper.add((Component)lbcOrientation);
        this.panMargin.setLayout(null);
        this.panMargin.add((Component)lbcTopMargin);
        this.panMargin.add((Component)lbcBottomMargin);
        this.panMargin.add((Component)lbcLeftMargin);
        this.panMargin.add((Component)lbcRightMargin);
        this.panContent.setLayout(null);
        this.panContent.add((Component)lbcContentHeight);
        this.panContent.add((Component)lbcContentWidth);
        this.panContent.add((Component)this.chkHeightLimitless);
        this.panPrinter.setLayout(null);
        this.panPrinter.add((Component)this.chkDynamicPaper);
        this.panPrinter.add((Component)this.chkEconomizePaper);
        lbcPaper.setBounds(10, 24, 250, 19);
        lbcWidth.setBounds(10, 47, 150, 21);
        this.labWidthUnit.setBounds(170, 47, 70, 21);
        lbcHeight.setBounds(10, 71, 150, 21);
        this.labHeightUnit.setBounds(170, 71, 70, 21);
        lbcOrientation.setBounds(10, 95, 250, 19);
        lbcTopMargin.setBounds(60, 24, 80, 21);
        lbcLeftMargin.setBounds(10, 58, 80, 21);
        lbcRightMargin.setBounds(110, 58, 80, 21);
        lbcBottomMargin.setBounds(60, 92, 80, 21);
        lbcContentWidth.setBounds(10, 24, 150, 21);
        lbcContentHeight.setBounds(10, 48, 150, 21);
        this.chkHeightLimitless.setBounds(180, 48, 280, 19);
        this.chkDynamicPaper.setBounds(10, 24, 150, 19);
        this.chkEconomizePaper.setBounds(180, 24, 150, 19);
        Table tb = thisCell.split(4, 1);
        tb.rowStyle(0).setPriY(1);
        tb.rowStyle(1).setHeight(125);
        tb.rowStyle(2).setHeight(80);
        tb.rowStyle(3).setHeight(55);
        Table tb1 = tb.cell(1).split(1, 2);
        tb1.colStyle(0).setWidth(270);
        tb1.colStyle(1).setPriX(1);
        parent.add((Component)this.panKdfName, tb.cell(0));
        parent.add((Component)this.panPaper, tb1.cell(0));
        parent.add((Component)this.panMargin, tb1.cell(1));
        parent.add((Component)this.panContent, tb.cell(2));
        parent.add((Component)this.panPrinter, tb.cell(3));
        int h = this.panKdfName.getPreferredSize().height;
        this.setSize(500, 360 + h);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.panKdfName = new KDPanel();
        this.txtKDFName = new KDTextField();
        this.panPaper = new KDPanel();
        this.cmbPaper = new KDComboBox();
        this.labWidthUnit = new KDLabel();
        this.labHeightUnit = new KDLabel();
        this.cmbOrientation = new KDComboBox();
        this.txtWidth = new NumberField();
        this.txtHeight = new NumberField();
        this.panMargin = new KDPanel();
        this.txtTopMargin = new NumberField();
        this.txtBottomMargin = new NumberField();
        this.txtLeftMargin = new NumberField();
        this.txtRightMargin = new NumberField();
        this.panContent = new KDPanel();
        this.txtContentHeight = new NumberField();
        this.txtContentWidth = new NumberField();
        this.chkHeightLimitless = new KDCheckBox(KDFPropsDialog.getMLS("heightLimitless", "\u65e0\u9650\u957f"));
        this.panPrinter = new KDPanel();
        this.chkDynamicPaper = new KDCheckBox(KDFPropsDialog.getMLS("dynamicPaper", "\u8fde\u7eed\u8d70\u7eb8"));
        this.chkEconomizePaper = new KDCheckBox(KDFPropsDialog.getMLS("economizePaper", "\u8282\u7eb8\u6253\u5370"));
        this.panPaper.setOpaque(false);
        this.panMargin.setOpaque(false);
        this.panContent.setOpaque(false);
        this.panPrinter.setOpaque(false);
        this.setTitle(KDFPropsDialog.getMLS("kdfPropsTitle", "\u62a5\u8868\u5c5e\u6027"));
        this.panPaper.setBorder((Border)BorderFactory.createTitledBorder(KDFPropsDialog.getMLS("paperSize", "\u7eb8\u5f20\u5927\u5c0f")));
        this.panMargin.setBorder((Border)BorderFactory.createTitledBorder(KDFPropsDialog.getMLS("pageMargin", "\u8fb9\u8ddd(0.1\u6beb\u7c73)")));
        this.panContent.setBorder((Border)BorderFactory.createTitledBorder(KDFPropsDialog.getMLS("content", "\u5185\u5bb9\u533a")));
        this.panPrinter.setBorder((Border)BorderFactory.createTitledBorder(KDFPropsDialog.getMLS("printer", "\u6253\u5370\u673a")));
        this.txtWidth.setHorizontalAlignment(4);
        this.txtHeight.setHorizontalAlignment(4);
        this.txtTopMargin.setHorizontalAlignment(4);
        this.txtBottomMargin.setHorizontalAlignment(4);
        this.txtLeftMargin.setHorizontalAlignment(4);
        this.txtRightMargin.setHorizontalAlignment(4);
        this.txtContentHeight.setHorizontalAlignment(4);
        this.txtContentWidth.setHorizontalAlignment(4);
        try {
            this.txtTopMargin.setInteger(true);
            this.txtWidth.setInteger(true);
            this.txtHeight.setInteger(true);
            this.txtBottomMargin.setInteger(true);
            this.txtLeftMargin.setInteger(true);
            this.txtRightMargin.setInteger(true);
            this.txtContentHeight.setInteger(true);
            this.txtContentWidth.setInteger(true);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.txtContentHeight.setEnabled(false);
        this.txtContentWidth.setEnabled(false);
        this.actionPerformedSyncContent();
    }

    private void installListener() {
        this.cmbPaper.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KDFPropsDialog.this.actionPerformedPaper(evt);
                KDFPropsDialog.this.actionPerformedSyncContent();
                if (!KDFPropsDialog.this.isCustomPaper()) {
                    KDFPropsDialog.this.txtHeight.setEnabled(false);
                }
            }
        });
        this.chkHeightLimitless.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDFPropsDialog.this.changeHeightLimitless();
            }
        });
        this.chkDynamicPaper.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                KDFPropsDialog.this.changeDynamicPaper(evt);
                if (KDFPropsDialog.this.chkDynamicPaper.isSelected()) {
                    KDFPropsDialog.this.chkEconomizePaper.setSelected(false);
                    KDFPropsDialog.this.chkEconomizePaper.setEnabled(false);
                } else {
                    KDFPropsDialog.this.chkEconomizePaper.setEnabled(true);
                }
            }
        });
        SyncContentHeightWidth syncContentHeightWidth = new SyncContentHeightWidth();
        this.txtHeight.addActionListener(syncContentHeightWidth);
        this.txtWidth.addActionListener(syncContentHeightWidth);
        this.txtTopMargin.addActionListener(syncContentHeightWidth);
        this.txtBottomMargin.addActionListener(syncContentHeightWidth);
        this.txtLeftMargin.addActionListener(syncContentHeightWidth);
        this.txtRightMargin.addActionListener(syncContentHeightWidth);
        this.cmbOrientation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDFPropsDialog.this.changeHeightLimitless();
                KDFPropsDialog.this.actionPerformedSyncContent();
            }
        });
    }

    private void initFocusPolicy() {
        Set forwardKeys = this.getFocusTraversalKeys(0);
        HashSet<KeyStroke> newForwardKeys = new HashSet<KeyStroke>(forwardKeys);
        newForwardKeys.add(KeyStroke.getKeyStroke(10, 0));
        this.setFocusTraversalKeys(0, newForwardKeys);
        LinkedList<Object> ctrlList = new LinkedList<Object>();
        ctrlList.add(this.txtKDFName);
        ctrlList.add(this.cmbPaper);
        ctrlList.add(this.txtWidth);
        ctrlList.add(this.txtHeight);
        ctrlList.add(this.cmbOrientation);
        ctrlList.add(this.txtTopMargin);
        ctrlList.add(this.txtLeftMargin);
        ctrlList.add(this.txtRightMargin);
        ctrlList.add(this.txtBottomMargin);
        ctrlList.add(this.chkHeightLimitless);
        ctrlList.add(this.chkDynamicPaper);
        ctrlList.add(this.chkEconomizePaper);
        CustomFocusTraversalPolicy focusPolicy = new CustomFocusTraversalPolicy();
        focusPolicy.setComponentsList(ctrlList);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(focusPolicy);
    }

    private void actionPerformedSyncContent() {
        this.txtContentHeight.setEnabled(this.isHeightLimitLess());
        String orientation = this.getOrientation();
        if (orientation.equals("PORTRAIT")) {
            this.txtContentWidth.setText("" + (int)(this.txtWidth.getValue() - this.txtLeftMargin.getValue() - this.txtRightMargin.getValue()));
            if (!this.isHeightLimitLess()) {
                this.txtContentHeight.setText("" + (int)(this.txtHeight.getValue() - this.txtTopMargin.getValue() - this.txtBottomMargin.getValue()));
            }
        } else {
            if (!this.isHeightLimitLess()) {
                this.txtContentHeight.setText("" + (int)(this.txtWidth.getValue() - this.txtTopMargin.getValue() - this.txtBottomMargin.getValue()));
            }
            this.txtContentWidth.setText("" + (int)(this.txtHeight.getValue() - this.txtLeftMargin.getValue() - this.txtRightMargin.getValue()));
        }
    }

    private void changeHeightLimitless() {
        if (!(!this.chkHeightLimitless.isSelected() || this.isCustomPaper() && "LANDSCAPE".equalsIgnoreCase(this.getOrientation()))) {
            this.chkDynamicPaper.setEnabled(true);
        } else {
            this.chkDynamicPaper.setSelected(false);
            this.chkDynamicPaper.setEnabled(false);
        }
        this.actionPerformedSyncContent();
    }

    private void changeDynamicPaper(ChangeEvent evt) {
        if (this.chkDynamicPaper.isSelected()) {
            this.txtHeight.setEnabled(false);
        } else {
            this.txtHeight.setEnabled(true);
            if (this.txtHeight.getValue() == -1.0) {
                try {
                    this.txtHeight.setValue(this.txtContentHeight.getValue() + this.txtTopMargin.getValue() + this.txtBottomMargin.getValue());
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void actionPerformedPaper(ActionEvent evt) {
        String paper = this.getPaperName();
        if (this.isCustomPaper()) {
            this.txtHeight.setEnabled(true);
            this.txtWidth.setEnabled(true);
            this.chkHeightLimitless.setEnabled(true);
        } else {
            MediaSize mediaSize = MediaSize.getMediaSizeForName(PrintInfo.String2MediaSizeName((String)paper));
            this.setReportWidth((int)(mediaSize.getX(1000) * 10.0f));
            this.setReportHeight((int)(mediaSize.getY(1000) * 10.0f));
            this.txtHeight.setEnabled(false);
            this.txtWidth.setEnabled(false);
            this.cmbOrientation.setEnabled(true);
            this.chkHeightLimitless.setEnabled(false);
            this.chkHeightLimitless.setSelected(false);
        }
    }

    public int getContentHeight() {
        return (int)this.txtContentHeight.getValue();
    }

    public void setContentHeight(int designHeight) {
        try {
            this.txtContentHeight.setValue(designHeight);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public int getReportHeight() {
        return (int)this.txtHeight.getValue();
    }

    public void setReportHeight(int reportHeight) {
        try {
            this.txtHeight.setValue(reportHeight);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public int getReportWidth() {
        return (int)this.txtWidth.getValue();
    }

    public void setReportWidth(int reportWidth) {
        try {
            this.txtWidth.setValue(reportWidth);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public int getRightMargin() {
        return (int)this.txtRightMargin.getValue();
    }

    public void setRightMargin(int rightMargin) {
        try {
            this.txtRightMargin.setValue(rightMargin);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public int getTopMargin() {
        return (int)this.txtTopMargin.getValue();
    }

    public void setTopMargin(int topMargin) {
        try {
            this.txtTopMargin.setValue(topMargin);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public int getLeftMargin() {
        return (int)this.txtLeftMargin.getValue();
    }

    public void setLeftMargin(int leftMargin) {
        try {
            this.txtLeftMargin.setValue(leftMargin);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public int getBottomMargin() {
        return (int)this.txtBottomMargin.getValue();
    }

    public void setBottomMargin(int bottomMargin) {
        try {
            this.txtBottomMargin.setValue(bottomMargin);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public String getOrientation() {
        if (this.cmbOrientation.getSelectedIndex() == 0) {
            return "PORTRAIT";
        }
        return "LANDSCAPE";
    }

    public void setOrientation(String orientation) {
        if (orientation.equals("PORTRAIT")) {
            this.cmbOrientation.setSelectedIndex(0);
        } else {
            this.cmbOrientation.setSelectedIndex(1);
        }
    }

    public String getReportName() {
        return this.txtKDFName.getText().trim();
    }

    public void setReportName(String reportName) {
        this.txtKDFName.setText(reportName);
    }

    public String getPaperName() {
        return (String)this.cmbPaper.getSelectedItem();
    }

    public void setPaperName(String paper) {
        this.cmbPaper.setSelectedItem((Object)paper);
    }

    public boolean isHeightLimitLess() {
        return this.chkHeightLimitless.isSelected();
    }

    public void setHeightLimitLess(boolean heightLimitLess) {
        this.chkHeightLimitless.setSelected(heightLimitLess);
    }

    public boolean isWidthLimitLess() {
        return false;
    }

    public void setWidthLimitLess(boolean widthLimitLess) {
    }

    public boolean isDynamicPaper() {
        return this.chkDynamicPaper.isSelected();
    }

    public void setDynamicPaper(boolean isDynmicPaper) {
        this.chkDynamicPaper.setSelected(isDynmicPaper);
    }

    public boolean isEconomizePaper() {
        return this.chkEconomizePaper.isSelected();
    }

    public void setEconomizePaper(boolean isEconomizePaper) {
        this.chkEconomizePaper.setSelected(isEconomizePaper);
    }

    protected boolean verify() {
        KDTextField emptyInput = this.isEmptyInput();
        if (emptyInput != null) {
            MsgBox.show((Component)((Object)this), KDFPropsDialog.getMLS("inputEmptyPrompt", "\u8f93\u5165\u4e0d\u80fd\u4e3a\u7a7a\u3002"), KDFPropsDialog.getMLS("warning", "\u8b66\u544a"), 17);
            emptyInput.requestFocusInWindow();
            return false;
        }
        if (this.isNameValid()) {
            MsgBox.show((Component)((Object)this), KDFPropsDialog.getMLS("nameInvalidPrompt", "\u540d\u79f0\u5305\u542b\u975e\u6cd5\u5b57\u7b26: ") + "\r\n" + this.invalidChars, KDFPropsDialog.getMLS("warning", "\u8b66\u544a"), 17);
            this.txtKDFName.requestFocusInWindow();
            return false;
        }
        if (!this.isMarginCorrect()) {
            MsgBox.show((Component)((Object)this), KDFPropsDialog.getMLS("marginErrorPrompt", "\u9875\u8fb9\u8ddd\u8bbe\u7f6e\u4e0d\u6b63\u786e\u3002"), KDFPropsDialog.getMLS("warning", "\u8b66\u544a"), 17);
            return false;
        }
        return true;
    }

    private boolean isNameValid() {
        for (int i = 0; i < this.invalidChars.length(); ++i) {
            if (this.txtKDFName.getText().indexOf(this.invalidChars.substring(i, i + 1)) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean isMarginCorrect() {
        String orientation = this.getOrientation();
        return !(orientation.equals("PORTRAIT") ? this.txtLeftMargin.getValue() + this.txtRightMargin.getValue() > this.txtWidth.getValue() || this.txtTopMargin.getValue() + this.txtBottomMargin.getValue() > this.txtHeight.getValue() : this.txtLeftMargin.getValue() + this.txtRightMargin.getValue() > this.txtHeight.getValue() || this.txtTopMargin.getValue() + this.txtBottomMargin.getValue() > this.txtWidth.getValue());
    }

    private KDTextField isEmptyInput() {
        if (StringUtil.isEmptyString((String)this.txtKDFName.getText())) {
            return this.txtKDFName;
        }
        if (this.txtWidth.getText().equals("")) {
            return this.txtWidth;
        }
        if (this.txtHeight.getText().equals("")) {
            return this.txtHeight;
        }
        if (this.txtLeftMargin.getText().equals("")) {
            return this.txtLeftMargin;
        }
        if (this.txtRightMargin.getText().equals("")) {
            return this.txtRightMargin;
        }
        if (this.txtTopMargin.getText().equals("")) {
            return this.txtTopMargin;
        }
        if (this.txtBottomMargin.getText().equals("")) {
            return this.txtBottomMargin;
        }
        return null;
    }

    private static String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }

    public boolean isCustomPaper() {
        return "CUSTOM".equalsIgnoreCase(this.getPaperName());
    }

    public boolean showDialog() {
        this.actionPerformedSyncContent();
        return super.showDialog();
    }

    private class SyncContentHeightWidth
    implements ActionListener {
        private SyncContentHeightWidth() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDFPropsDialog.this.actionPerformedSyncContent();
        }
    }
}

