/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.reportelement;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.FieldElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;

public abstract class AbstractGroup
extends AbstractContainer {
    protected String dataSource = "";
    protected String field = "";

    public AbstractGroup(String name, int left, int top, int width, int height) {
        super(name, left, top, width, height);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
        this.firePropertyChange(null);
    }

    public void setDataSource(String ds) {
        if (StringUtil.isEmptyString((String)ds) && StringUtil.equals((String)this.dataSource, (String)this.getAncestorDataSource()) || StringUtil.isEmptyString((String)this.dataSource) && StringUtil.equals((String)ds, (String)this.getAncestorDataSource())) {
            this.setDataSource(ds, false);
        } else {
            this.setDataSource(ds, true);
        }
    }

    public void setDataSource(String datasource, boolean isClearField) {
        if (isClearField && !StringUtil.isEmptyString((String)this.dataSource) && !this.dataSource.equals(datasource)) {
            this.clearFiled(this, this.dataSource);
        }
        this.dataSource = datasource;
        this.firePropertyChange(null);
    }

    private void clearFiled(AbstractContainer container, String datasource) {
        if (container instanceof AbstractGroup) {
            ((AbstractGroup)container).setField("");
        }
        for (ReportElement re : container.allChildren) {
            if (re.getEleType() == 4 && ((FieldElement)re).getNearDataSource().equals(datasource)) {
                ((FieldElement)re).setField(null);
            }
            if (!(re instanceof AbstractContainer)) continue;
            String ds = null;
            if (re instanceof AbstractGroup) {
                ds = ((AbstractGroup)re).getDataSource();
            }
            if (!StringUtil.isEmptyString(ds)) continue;
            this.clearFiled((AbstractContainer)re, datasource);
        }
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getNearDataSource() {
        if (!StringUtil.isEmptyString((String)this.getDataSource())) {
            return this.getDataSource();
        }
        return this.getAncestorDataSource();
    }

    private String getAncestorDataSource() {
        IContainer parent = this.getParent();
        while (!(parent instanceof Page)) {
            if (parent instanceof AbstractGroup && !StringUtil.isEmptyString((String)((AbstractGroup)parent).getDataSource())) {
                return ((AbstractGroup)parent).getDataSource();
            }
            parent = parent.getParent();
        }
        return ((Page)parent).getDataSource();
    }
}

