/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.reportelement;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.expr.Macro;
import com.kingdee.bos.ctrl.kdf.expr.RelationKey;
import com.kingdee.bos.ctrl.kdf.expr.RelationsListener;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.TableRelations;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.fd2.KDF;
import com.kingdee.bos.ctrl.kdf.fd2.SideLocation;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractGroup;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.FieldElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.LoopArea;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Table;
import com.kingdee.bos.ctrl.kdf.util.BMPReader;
import com.kingdee.bos.ctrl.kdf.util.render.ImageRender;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;

public class Page
extends AbstractContainer
implements RelationsListener {
    TableRelations deps = null;
    HashMap allRelationsMap = null;
    private ArrayList selectedElements;
    private String dataSource = "";
    private String field = "";
    private int repeat = -1;
    private KDF kdf = null;
    private boolean calcSus = true;
    private Backgroud backgroud;

    public Page(KDF kdf, String name, int width, int height) {
        super(name, 0, 0, width, height);
        this.eletype = 15;
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(Color.WHITE);
        sa.setPattern(Pattern.Solid);
        sa.setPatternColor(Color.BLACK);
        this.ssa = Styles.getSSA((StyleAttributes)sa);
        this.style = Styles.getStyle((ShareStyleAttributes)this.ssa);
        this.selectedElements = new ArrayList();
        this.allRelationsMap = new HashMap();
        this.topPage = this;
        this.container = this;
        this.location.createDefaultLocation();
        this.deps = new TableRelations();
        this.kdf = kdf;
        this.setLocked(true);
    }

    public ArrayList getSelectedElements() {
        return this.selectedElements;
    }

    public void setSelectedElements(Vector elements) {
    }

    public void setField(String field) {
        this.field = field;
        this.firePropertyChange(null);
    }

    public String getField() {
        return this.field;
    }

    public void setDataSource(String datasource) {
        this.setDataSource(datasource, true);
    }

    public void setDataSource(String datasource, boolean isClearField) {
        if (isClearField && !StringUtil.isEmptyString((String)this.dataSource) && !this.dataSource.equals(datasource)) {
            this.clearFiled(this, this.dataSource);
        }
        this.dataSource = datasource;
        this.firePropertyChange(null);
    }

    private void clearFiled(AbstractContainer container, String datasource) {
        if (container instanceof AbstractGroup) {
            ((AbstractGroup)container).setField("");
        }
        for (ReportElement re : container.allChildren) {
            if (re.getEleType() == 4 && !StringUtil.isEmptyString((String)((FieldElement)re).getNearDataSource()) && ((FieldElement)re).getNearDataSource().equals(datasource)) {
                ((FieldElement)re).setField(null);
            }
            if (!(re instanceof AbstractContainer)) continue;
            String ds = null;
            if (re instanceof AbstractGroup) {
                ds = ((AbstractGroup)re).getDataSource();
            }
            if (!StringUtil.isEmptyString(ds)) continue;
            this.clearFiled((AbstractContainer)re, datasource);
        }
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public boolean isSelectedElement(ReportElement re) {
        for (ReportElement ele : this.selectedElements) {
            if (re != ele) continue;
            return true;
        }
        return false;
    }

    @Override
    public Page getTopContainer() {
        return this;
    }

    public void drawAllObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        g.translate(10 - x_shift_origin, 10 - y_shift_origin);
        super.drawObject(g, zoom_factor);
        g.translate(x_shift_origin - 10, y_shift_origin - 10);
    }

    public void drawPage(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        g.translate(10 - x_shift_origin, 10 - y_shift_origin);
        this.drawGraphicsElement(g, zoom_factor);
        if (this.backgroud != null) {
            this.backgroud.draw((Graphics2D)g.create(0, 0, this.getWidth(), this.getHeight()));
        }
        g.translate(x_shift_origin - 10, y_shift_origin - 10);
    }

    @Override
    public void drawObject(Graphics2D g, double zoom_factor) {
    }

    public void firstBuildQuean() {
        this.allRelationsMap.clear();
        this.addRelationQuean(this.deps);
    }

    @Override
    public void addRelationQuean(TableRelations deps) {
        RelationKey keyleft = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_left"), null);
        deps.queue(keyleft, "=0");
        this.getTopContainer().allRelationsMap.put(keyleft, this);
        RelationKey keyright = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_right"), null);
        deps.queue(keyright, "=" + String.valueOf(this.widthLom));
        this.getTopContainer().allRelationsMap.put(keyright, this);
        RelationKey keytop = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_top"), null);
        deps.queue(keytop, "=0");
        this.allRelationsMap.put(keytop, this);
        RelationKey keybottom = new RelationKey((RelationsListener)this.getTopContainer(), (Object)(this.getName() + "_bottom"), null);
        deps.queue(keybottom, "=" + String.valueOf(this.heightLom));
        this.getTopContainer().allRelationsMap.put(keybottom, this);
        super.addRelationQuean(deps);
    }

    public Page clonePage() {
        Page page = (Page)this.cloneMe();
        page.allChildren = new ArrayList();
        page.location = this.location.cloneMe();
        for (ReportElement re : this.allChildren) {
            this.copyElementAndChild(page, re);
        }
        return page;
    }

    private void copyElementAndChild(AbstractContainer parent, ReportElement re) {
        if (re instanceof AbstractContainer) {
            AbstractContainer container = (AbstractContainer)re.cloneMe();
            container.setParent(parent);
            container.location = re.location.cloneMe();
            container.tablocation = re.tablocation.cloneMe();
            parent.addElement(container);
            Iterator it = ((AbstractContainer)re).allChildren.iterator();
            while (it.hasNext()) {
                this.copyElementAndChild(container, (ReportElement)it.next());
            }
        } else {
            ReportElement reClone = re.cloneMe();
            reClone.setParent(parent);
            reClone.location = re.location.cloneMe();
            reClone.tablocation = re.tablocation.cloneMe();
            parent.addElement(reClone);
        }
    }

    @Override
    public ReportElement cloneMe() {
        Page newReportElement = new Page(this.kdf, this.name, this.width, this.height);
        newReportElement.dataSource = this.dataSource;
        newReportElement.field = this.field;
        newReportElement.repeat = this.repeat;
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public boolean recalcAllPos() {
        this.calcSus = true;
        this.deps.calculateQueue();
        return this.calcSus;
    }

    public TableRelations getDeps() {
        return this.deps;
    }

    private int getSide(String keyString) {
        if (keyString.endsWith("_left")) {
            return 0;
        }
        if (keyString.endsWith("_right")) {
            return 1;
        }
        if (keyString.endsWith("_top")) {
            return 2;
        }
        if (keyString.endsWith("_bottom")) {
            return 3;
        }
        return -1;
    }

    public boolean queryRelationsListener(String listenerName, Variant varInstance) {
        return true;
    }

    public boolean queryInstance(RelationKey key, Variant varInstance) {
        return true;
    }

    public boolean queryFormula(RelationKey key, Variant varFormula) {
        return true;
    }

    public boolean queryValue(RelationKey key, Variant varResult) {
        return true;
    }

    public boolean queryVariable(String variableName, Variant varFormula, Variant varValue) {
        return true;
    }

    public boolean preIntepreted(RelationKey key) {
        return true;
    }

    public boolean intepretedComplete(boolean succeed, RelationKey key, Macro m) {
        if (!succeed) {
            m.getSyntaxError().getMessage();
            this.calcSus = false;
            return false;
        }
        try {
            int value = m.getVariableValue("$VALUE").intValue();
            ReportElement re = (ReportElement)this.allRelationsMap.get(key);
            if (re.getParent() instanceof Table) {
                return true;
            }
            SideLocation leftSide = re.getLocation().getSideLocation(0);
            SideLocation rightSide = re.getLocation().getSideLocation(1);
            SideLocation topSide = re.getLocation().getSideLocation(2);
            SideLocation bottomSide = re.getLocation().getSideLocation(3);
            switch (this.getSide((String)key.getIndex())) {
                case 0: {
                    int posx = value - re.getCorrespondTopPosLom().x;
                    if (re instanceof Page || re.isLoading()) {
                        re.posLom.x = posx;
                        re.position.x = (int)StyleUtil.lomToPixel((long)posx);
                        break;
                    }
                    if (leftSide.getType() != 1 && rightSide.getRelativeObjectID().equals(re.getName())) {
                        int newValue;
                        int parentRight;
                        int oldWidth = re.getWidthLom();
                        int right = oldWidth + posx;
                        if (right > (parentRight = re.getParent().getWidthLom())) {
                            newValue = leftSide.getValue();
                            leftSide.setValue(newValue += parentRight - right);
                            right = parentRight;
                            posx = right - oldWidth;
                        }
                        if (posx <= 0) {
                            newValue = leftSide.getValue();
                            leftSide.setValue(newValue -= posx);
                            posx = 0;
                            right = oldWidth > parentRight ? parentRight : oldWidth;
                        }
                        re.posLom.x = posx;
                        re.position.x = (int)StyleUtil.lomToPixel((long)posx);
                        int newWidth = right - posx;
                        if (oldWidth != newWidth) {
                            rightSide.setValue(newWidth);
                            re.setWidthLom(newWidth);
                        }
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    if (leftSide.getType() != 1) {
                        int off = 0;
                        if (posx > re.posLom.x + re.widthLom) {
                            int newValue = leftSide.getValue();
                            leftSide.setValue(newValue += re.posLom.x + re.widthLom - posx);
                            posx = re.posLom.x + re.widthLom;
                            off = posx - re.posLom.x;
                            re.posLom.x = posx;
                            re.position.x = (int)StyleUtil.lomToPixel((long)posx);
                            re.addRelationQuean(this.deps);
                        } else if (posx < 0) {
                            int newValue = leftSide.getValue();
                            leftSide.setValue(newValue -= posx);
                            posx = 0;
                            off = posx - re.posLom.x;
                            re.posLom.x = posx;
                            re.position.x = (int)StyleUtil.lomToPixel((long)posx);
                            re.addRelationQuean(this.deps);
                        } else {
                            off = posx - re.posLom.x;
                            re.posLom.x = posx;
                            re.position.x = (int)StyleUtil.lomToPixel((long)posx);
                        }
                        re.setWidthLom(re.widthLom - off);
                        break;
                    }
                    int rightValue = rightSide.getValue();
                    if (rightValue < 0) {
                        rightSide.setValue(-rightValue);
                    }
                    if (leftSide.getContextValue() == 1) {
                        if (posx < 0) {
                            leftSide.setValue(0);
                            int width = rightSide.getValue();
                            rightSide.setValue(width += 2 * posx);
                            re.posLom.x = 0;
                            re.position.x = (int)StyleUtil.lomToPixel((long)0L);
                            re.setWidthLom(width);
                            re.addRelationQuean(this.deps);
                            break;
                        }
                        re.posLom.x = posx;
                        re.position.x = (int)StyleUtil.lomToPixel((long)posx);
                        break;
                    }
                    if (posx < 0) {
                        int leftValue = leftSide.getValue();
                        leftSide.setValue(leftValue -= posx);
                        int width = rightSide.getValue();
                        rightSide.setValue(width += posx);
                        re.posLom.x = 0;
                        re.position.x = (int)StyleUtil.lomToPixel((long)0L);
                        re.setWidthLom(width);
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    re.posLom.x = posx;
                    re.position.x = (int)StyleUtil.lomToPixel((long)posx);
                    break;
                }
                case 1: {
                    int right = value - re.getCorrespondTopPosLom().x;
                    int parentRight = re.getParent().getWidthLom();
                    if (re instanceof Page || re.isLoading()) {
                        int newWidth = right - re.getPosLom().x;
                        re.setWidthLom(newWidth);
                        break;
                    }
                    if (leftSide.getType() != 1 && leftSide.getRelativeObjectID().equals(re.getName())) {
                        int posx;
                        int oldWidth = re.getWidthLom();
                        if (right > parentRight) {
                            int newValue = rightSide.getValue();
                            rightSide.setValue(newValue += parentRight - right);
                            right = parentRight;
                        }
                        if ((posx = right - oldWidth) < 0) {
                            int newValue = rightSide.getValue();
                            rightSide.setValue(newValue -= posx);
                            posx = 0;
                        }
                        re.posLom.x = posx;
                        re.position.x = (int)StyleUtil.lomToPixel((long)posx);
                        re.setWidthLom(right - posx);
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    if (leftSide.getType() != 1) {
                        int newWidth;
                        if (right > parentRight) {
                            int newValue = rightSide.getValue();
                            rightSide.setValue(newValue += parentRight - right);
                            right = parentRight;
                        }
                        if ((newWidth = right - re.getPosLom().x) < 0) {
                            int newValue = rightSide.getValue();
                            rightSide.setValue(newValue -= newWidth);
                            newWidth = 0;
                        }
                        re.setWidthLom(newWidth);
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    if (leftSide.getContextValue() == 1) {
                        if (right > parentRight) {
                            int leftValue = leftSide.getValue();
                            leftSide.setValue(leftValue += parentRight - right);
                            int width = rightSide.getValue();
                            rightSide.setValue(width += 2 * (parentRight - right));
                            re.posLom.x = leftValue;
                            re.position.x = (int)StyleUtil.lomToPixel((long)leftValue);
                            re.setWidthLom(width);
                            re.addRelationQuean(this.deps);
                            break;
                        }
                        int newWidth = right - re.getPosLom().x;
                        re.setWidthLom(newWidth);
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    if (right > parentRight) {
                        int width = rightSide.getValue();
                        rightSide.setValue(width += parentRight - right);
                        re.setWidthLom(width);
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    int newWidth = right - re.getPosLom().x;
                    re.setWidthLom(newWidth);
                    re.addRelationQuean(this.deps);
                    break;
                }
                case 2: {
                    int posy = value - re.getCorrespondTopPosLom().y;
                    if (re instanceof Page || re.isLoading()) {
                        re.posLom.y = posy;
                        re.position.y = (int)StyleUtil.lomToPixel((long)posy);
                        break;
                    }
                    if (topSide.getType() != 1 && bottomSide.getRelativeObjectID().equals(re.getName())) {
                        int newValue;
                        int parentBottom;
                        int oldHeight = re.getHeightLom();
                        int bottom = oldHeight + posy;
                        if (bottom > (parentBottom = re.getParent().getHeightLom())) {
                            newValue = topSide.getValue();
                            topSide.setValue(newValue += parentBottom - bottom);
                            bottom = parentBottom;
                            posy = bottom - oldHeight;
                        }
                        if (posy <= 0) {
                            newValue = topSide.getValue();
                            topSide.setValue(newValue -= posy);
                            posy = 0;
                            bottom = oldHeight > parentBottom ? parentBottom : oldHeight;
                        }
                        re.posLom.y = posy;
                        re.position.y = (int)StyleUtil.lomToPixel((long)posy);
                        int newHeight = bottom - posy;
                        if (oldHeight != newHeight) {
                            bottomSide.setValue(newHeight);
                            re.setHeightLom(newHeight);
                        }
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    if (topSide.getType() != 1) {
                        int off = 0;
                        if (posy > re.posLom.y + re.heightLom) {
                            int newValue = topSide.getValue();
                            topSide.setValue(newValue += re.posLom.y + re.heightLom - posy);
                            posy = re.posLom.y + re.heightLom;
                            off = posy - re.posLom.y;
                            re.posLom.y = posy;
                            re.position.y = (int)StyleUtil.lomToPixel((long)posy);
                            re.addRelationQuean(this.deps);
                        } else if (posy < 0) {
                            int newValue = topSide.getValue();
                            topSide.setValue(newValue -= posy);
                            posy = 0;
                            off = posy - re.posLom.y;
                            re.posLom.y = posy;
                            re.position.y = (int)StyleUtil.lomToPixel((long)posy);
                            re.addRelationQuean(this.deps);
                        } else {
                            off = posy - re.posLom.y;
                            re.posLom.y = posy;
                            re.position.y = (int)StyleUtil.lomToPixel((long)posy);
                        }
                        re.setHeightLom(re.heightLom - off);
                        break;
                    }
                    int bottomValue = bottomSide.getValue();
                    if (bottomValue < 0) {
                        bottomSide.setValue(-bottomValue);
                    }
                    if (topSide.getContextValue() == 4) {
                        if (posy < 0) {
                            topSide.setValue(0);
                            int height = bottomSide.getValue();
                            bottomSide.setValue(height += 2 * posy);
                            re.posLom.y = 0;
                            re.position.y = (int)StyleUtil.lomToPixel((long)0L);
                            re.setHeightLom(height);
                            re.addRelationQuean(this.deps);
                            break;
                        }
                        re.posLom.y = posy;
                        re.position.y = (int)StyleUtil.lomToPixel((long)posy);
                        break;
                    }
                    if (posy < 0) {
                        int topValue = topSide.getValue();
                        topSide.setValue(topValue -= posy);
                        int height = bottomSide.getValue();
                        bottomSide.setValue(height += posy);
                        re.posLom.y = 0;
                        re.position.y = (int)StyleUtil.lomToPixel((long)0L);
                        re.setHeightLom(height);
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    re.posLom.y = posy;
                    re.position.y = (int)StyleUtil.lomToPixel((long)posy);
                    break;
                }
                case 3: {
                    int bottom = value - re.getCorrespondTopPosLom().y;
                    int parentBottom = re.getParent().getHeightLom();
                    if (re instanceof Page || re.isLoading()) {
                        int newHeight = bottom - re.getPosLom().y;
                        re.setHeightLom(newHeight);
                        break;
                    }
                    if (topSide.getType() != 1 && topSide.getRelativeObjectID().equals(re.getName())) {
                        int posy;
                        int oldHeight = re.getHeightLom();
                        if (bottom > parentBottom) {
                            int newValue = bottomSide.getValue();
                            bottomSide.setValue(newValue += parentBottom - bottom);
                            bottom = parentBottom;
                        }
                        if ((posy = bottom - oldHeight) < 0) {
                            int newValue = bottomSide.getValue();
                            bottomSide.setValue(newValue -= posy);
                            posy = 0;
                        }
                        re.posLom.y = posy;
                        re.position.y = (int)StyleUtil.lomToPixel((long)posy);
                        re.setHeightLom(bottom - posy);
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    if (topSide.getType() != 1) {
                        int newHeight;
                        if (bottom > parentBottom) {
                            int newValue = bottomSide.getValue();
                            bottomSide.setValue(newValue += parentBottom - bottom);
                            bottom = parentBottom;
                        }
                        if ((newHeight = bottom - re.getPosLom().y) < 0) {
                            int newValue = bottomSide.getValue();
                            bottomSide.setValue(newValue -= newHeight);
                            newHeight = 0;
                        }
                        re.setHeightLom(newHeight);
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    if (topSide.getContextValue() == 1) {
                        if (bottom > parentBottom) {
                            int topValue = topSide.getValue();
                            topSide.setValue(topValue += parentBottom - bottom);
                            int height = bottomSide.getValue();
                            bottomSide.setValue(height += 2 * (parentBottom - bottom));
                            re.posLom.y = topValue;
                            re.position.y = (int)StyleUtil.lomToPixel((long)topValue);
                            re.setHeightLom(height);
                            re.addRelationQuean(this.deps);
                            break;
                        }
                        int newHeight = bottom - re.getPosLom().y;
                        re.setHeightLom(newHeight);
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    if (bottom > parentBottom) {
                        int height = bottomSide.getValue();
                        bottomSide.setValue(height += parentBottom - bottom);
                        re.setHeightLom(height);
                        re.addRelationQuean(this.deps);
                        break;
                    }
                    int newHeight = bottom - re.getPosLom().y;
                    re.setHeightLom(newHeight);
                    re.addRelationQuean(this.deps);
                    break;
                }
            }
            re.updateBounds();
        }
        catch (SyntaxErrorException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean formulaChanged(RelationKey key, String newFormula) {
        return true;
    }

    public boolean queryVariable(RelationKey key, String variableName, Variant varFormula, Variant varValue) {
        return true;
    }

    public boolean queryInstance(RelationKey key, RelationKey keyPos, Variant varInstance) {
        return true;
    }

    public String getMethodName(String methodName) {
        return "";
    }

    public KDF getKDF() {
        return this.kdf;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repert) {
        this.repeat = repert;
        this.firePropertyChange(null);
    }

    public ArrayList getAllLoopArea() {
        ArrayList array = new ArrayList();
        this.getAllLoopArea(this, array);
        return array;
    }

    private void getAllLoopArea(IContainer container, ArrayList array) {
        if (container instanceof LoopArea) {
            array.add(container);
        }
        for (ReportElement re : container.getChildren()) {
            if (!(re instanceof IContainer)) continue;
            this.getAllLoopArea((IContainer)((Object)re), array);
        }
    }

    public void setBackgroud(Backgroud backgroud) {
        this.backgroud = backgroud;
        this.firePropertyChange(null);
    }

    public Backgroud getBackgroud() {
        return this.backgroud;
    }

    public static class Backgroud {
        private Image img;
        private int offsetX;
        private int offsetY;
        private ImageRender imageRender = new ImageRender();

        public Backgroud(Image img) {
            this.img = img;
        }

        public Backgroud(String imageExpression) {
            URL urlOfData = null;
            try {
                urlOfData = new URL(imageExpression);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
            String url = urlOfData.toString();
            String suffix = url.substring(url.length() - 3, url.length());
            if (urlOfData.getProtocol().equalsIgnoreCase("file")) {
                this.img = "bmp".equalsIgnoreCase(suffix) || "dib".equalsIgnoreCase(suffix) ? BMPReader.loadBitMap((String)url.substring(7)) : new ImageIcon(url.substring(7)).getImage();
            }
        }

        public Image getImage() {
            return this.img;
        }

        public void draw(Graphics2D g) {
            this.imageRender.setGraphics2D(g);
            Point pt = new Point((int)StyleUtil.lomToPixel((long)this.offsetX), (int)StyleUtil.lomToPixel((long)this.offsetY));
            this.imageRender.draw(pt, this.img);
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public void setOffsetX(int offsetX) {
            this.offsetX = offsetX < 0 ? 0 : offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public void setOffsetY(int offsetY) {
            this.offsetY = offsetY < 0 ? 0 : offsetY;
        }
    }
}

