/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;

public class Misc {
    public static final Color KDFFRAME_BACKGROUND = new Color(228, 228, 223);
    public static final Color DESIGNER_BACKGROUND = new Color(153, 153, 153);

    public static String nvl(Object obj, String def) {
        return obj == null ? def : obj.toString();
    }

    public static void centerFrame(Component c) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        c.setLocation((int)((tk.getScreenSize().getWidth() - (double)c.getWidth()) / 2.0), (int)((tk.getScreenSize().getHeight() - (double)c.getHeight()) / 2.0));
    }

    public static String getShortFileName(String filename) {
        File f;
        if (filename.length() > 50 && Misc.nvl((f = new File(filename)).getParentFile(), "").length() > 10) {
            String dir = f.getParentFile().getPath() + File.separatorChar;
            String shortDir = dir.substring(0, dir.indexOf(File.separatorChar) + 1);
            if ((dir = dir.substring(dir.indexOf(File.separatorChar) + 1)).indexOf(File.separatorChar) > 0) {
                shortDir = shortDir + dir.substring(0, dir.indexOf(File.separatorChar) + 1);
            }
            return shortDir + "..." + File.separatorChar + f.getName();
        }
        return filename;
    }

    public static Document buildDocFromFile(File file) {
        if (file != null) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (input != null) {
                Document doc = Misc.buildDocument(input);
                try {
                    input.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return doc;
            }
        }
        return null;
    }

    public static Document buildDocument(InputStream inputStream) {
        InputSource source = null;
        if (inputStream != null) {
            source = new InputSource(inputStream);
        }
        if (source != null) {
            try {
                SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
                builder.setIgnoringElementContentWhitespace(true);
                return builder.build(source);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void saveDocToFile(Document doc, File file) {
        try {
            Misc.saveDocument(doc, new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void saveDocument(Document doc, OutputStream output) {
        OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setOmitEncoding(true);
        format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        XMLOutputter outter = new XMLOutputter(format);
        try {
            outter.output(doc, (Writer)writer);
            ((Writer)writer).close();
            output.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static Element getChildFromParent(Element parent, String childStr) {
        Element child = parent.getChild(childStr);
        if (child == null) {
            child = new Element(childStr);
            parent.addContent((Content)child);
        }
        return child;
    }
}

