/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.data.xy;

import com.kingdee.bos.ctrl.freechart.data.general.DatasetChangeEvent;
import com.kingdee.bos.ctrl.freechart.data.general.DatasetChangeListener;
import com.kingdee.bos.ctrl.freechart.data.xy.TableXYDataset;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class XYDatasetTableModel
extends AbstractTableModel
implements TableModel,
DatasetChangeListener {
    TableXYDataset model = null;

    public XYDatasetTableModel() {
    }

    public XYDatasetTableModel(TableXYDataset dataset) {
        this();
        this.model = dataset;
        this.model.addChangeListener(this);
    }

    public void setModel(TableXYDataset dataset) {
        this.model = dataset;
        this.model.addChangeListener(this);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getItemCount();
    }

    @Override
    public int getColumnCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getSeriesCount() + 1;
    }

    @Override
    public String getColumnName(int column) {
        if (this.model == null) {
            return super.getColumnName(column);
        }
        if (column < 1) {
            return "X Value";
        }
        return this.model.getSeriesKey(column - 1).toString();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.model == null) {
            return null;
        }
        if (column < 1) {
            return this.model.getX(0, row);
        }
        return this.model.getY(column - 1, row);
    }

    @Override
    public void datasetChanged(DatasetChangeEvent event) {
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.isCellEditable(row, column)) {
            // empty if block
        }
    }
}

