/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.jcr;

import com.kingdee.bos.ctrl.jcr.IPoolManager;
import com.kingdee.bos.ctrl.jcr.NamespaceUtil;
import com.kingdee.bos.ctrl.jcr.PathUtil;
import com.kingdee.bos.ctrl.jcr.PoolManager;
import com.kingdee.bos.ctrl.jcr.SMFile;
import com.kingdee.bos.ctrl.jcr.SMFolder;
import com.kingdee.bos.ctrl.jcr.SMResource;
import com.kingdee.bos.ctrl.jcr.exception.SMException;
import com.kingdee.bos.ctrl.jcr.exception.SMRuntimeException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class Explorer {
    private Session _session;
    private Node _root;
    private boolean _atomicSave = true;
    private ExplorerListener _listener;
    private IPoolManager pm;

    Explorer(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
        this._session = session;
    }

    Explorer(Session session, PoolManager pm) {
        this(session);
        this.pm = pm;
    }

    Session getSession() {
        if (this._session == null) {
            throw new SMRuntimeException("This instance out of commission.");
        }
        return this._session;
    }

    Node getRoot() throws SMException {
        if (this._root == null) {
            try {
                this._root = this.getSession().getRootNode();
                if (!this._root.hasProperty(NamespaceUtil.Created)) {
                    SMFolder.initProperties(this._root, false);
                    this.getSession().save();
                }
            }
            catch (RepositoryException e) {
                SMException.makeException(e);
            }
        }
        return this._root;
    }

    public String getWorkspaceName() {
        return this.getSession().getWorkspace().getName();
    }

    public SMFolder getRootFolder() throws SMException {
        return (SMFolder)this.wrapResource(this.getRoot(), false);
    }

    static boolean innerIsFile(Node node) throws SMException {
        try {
            return node.hasProperty(NamespaceUtil.Content);
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    SMResource wrapResource(Node node) throws SMException {
        return this.wrapResource(node, Explorer.innerIsFile(node));
    }

    SMResource wrapResource(Node node, boolean isFile) {
        if (isFile) {
            return new SMFile(this, node);
        }
        return new SMFolder(this, node);
    }

    public void setAtomicSave(boolean atomicSave) {
        this._atomicSave = atomicSave;
    }

    public boolean isAtomicSave() {
        return this._atomicSave;
    }

    public void save() throws SMException {
        try {
            this.getSession().save();
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public void giveUpSave() throws SMException {
        try {
            this.getSession().refresh(false);
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    void innerSave() throws SMException {
        if (this._atomicSave) {
            this.save();
        }
    }

    public void logout() {
        this.getSession().logout();
        this._session = null;
        this._listener.logouted();
    }

    public void free() {
        if (this.pm != null) {
            try {
                this.pm.free(this);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public SMResource getResourceByPath(String path) throws SMException {
        if (!PathUtil.isRelativePath(path)) {
            path = path.substring(1);
        }
        return this.getRootFolder().getChild(path);
    }

    public void setExplorerListener(ExplorerListener listener) {
        this._listener = listener;
    }

    public static interface ExplorerListener {
        public void logouted();
    }
}

