/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.jcr;

import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.jcr.Explorer;
import com.kingdee.bos.ctrl.jcr.ExplorerPool;
import com.kingdee.bos.ctrl.jcr.IConnectionCreator;
import com.kingdee.bos.ctrl.jcr.PoolManager;
import com.kingdee.bos.ctrl.jcr.exception.SMException;
import com.kingdee.bos.ctrl.jcr.exception.SMRuntimeException;
import com.kingdee.bos.ctrl.jcr.util.ConnectionCounter;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExplorerFactory {
    private static Logger log = LogUtil.getPackageLogger(ExplorerFactory.class);
    private static HashMap _dbConnectionCreator = new HashMap();
    private static HashMap _multiInstances = new HashMap();
    public static Map mapCacheConnection = new HashMap();
    private static Map mapPool = new HashMap();
    private static final int POOL_MAX_SIZE = 10;
    private static final Object getInstLock = new Object();
    private static final Object tmpRandomLock = new Object();
    private static Random random = new Random(System.currentTimeMillis());

    public static Connection getCacheConnection(String dataCenter) {
        if (mapCacheConnection.containsKey(dataCenter)) {
            return (Connection)mapCacheConnection.get(dataCenter);
        }
        return null;
    }

    public static Connection getConnection(String dataCenter) throws SQLException {
        IConnectionCreator creator = (IConnectionCreator)_dbConnectionCreator.get(dataCenter);
        log.debug((Object)("open connection " + ConnectionCounter.getOpenCounter()));
        Connection connection = creator.getConnection(dataCenter);
        if (connection == null) {
            throw new SQLException("BI Info: can't get connection!");
        }
        if (connection.getAutoCommit()) {
            connection.setAutoCommit(false);
        }
        return connection;
    }

    public static void closeConnection(Connection con) {
        SQLUtils.cleanup((Connection)con);
        log.debug((Object)("close connection " + ConnectionCounter.getCloseCounter()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Explorer getInst2(IConnectionCreator creator, String dataCenter, String workspace) {
        _dbConnectionCreator.put(dataCenter, creator);
        ExplorerPool pool = null;
        Object object = getInstLock;
        synchronized (object) {
            HashMap<String, ExplorerPool> pools = null;
            pools = (HashMap<String, ExplorerPool>)mapPool.get(dataCenter);
            if (pools == null) {
                pools = new HashMap<String, ExplorerPool>();
                mapPool.put(dataCenter, pools);
            }
            if ((pool = (ExplorerPool)pools.get(workspace)) == null) {
                pool = new ExplorerPool(dataCenter, workspace, 10);
                pools.put(workspace, pool);
            }
        }
        Explorer explorer = null;
        try {
            explorer = pool.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return explorer;
    }

    public static Explorer createNewExplorer(String dataCenter, String workspace, PoolManager pm) {
        Session session;
        try {
            session = ExplorerFactory.loginJcr(dataCenter, workspace);
        }
        catch (SMException e) {
            log.error((Object)"Login in JCR error.", (Throwable)e);
            throw new SMRuntimeException("Login in JCR error. ", e);
        }
        Explorer inst = new Explorer(session, pm);
        inst.setExplorerListener(new LogoutListener(dataCenter, workspace));
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Explorer getInst(IConnectionCreator creator, String dataCenter, String workspace) {
        _dbConnectionCreator.put(dataCenter, creator);
        Explorer inst = null;
        Object object = getInstLock;
        synchronized (object) {
            HashMap<String, Explorer> insts = null;
            insts = (HashMap<String, Explorer>)_multiInstances.get(dataCenter);
            if (insts == null) {
                insts = new HashMap<String, Explorer>();
                _multiInstances.put(dataCenter, insts);
            }
            if ((inst = (Explorer)insts.get(workspace)) == null) {
                Session session;
                try {
                    session = ExplorerFactory.loginJcr(dataCenter, workspace);
                }
                catch (SMException e) {
                    log.error((Object)"Login in JCR error.", (Throwable)e);
                    throw new SMRuntimeException("Login in JCR error. ", e);
                }
                inst = new Explorer(session);
                insts.put(workspace, inst);
                inst.setExplorerListener(new LogoutListener(dataCenter, workspace));
            }
        }
        return inst;
    }

    private static InputStream dynamicConfig(String dataCenter) {
        InputStream configIs = ExplorerFactory.class.getResourceAsStream("repository4eas.xml");
        try {
            Element configRoot = XmlUtil.loadXmlStream((InputStream)configIs);
            ExplorerFactory.modifyDataCenterParam(configRoot.getChild("FileSystem"), dataCenter);
            ExplorerFactory.modifyWsConfigXml(configRoot.getChild("Workspace"), dataCenter);
            configIs = new ByteArrayInputStream(XmlUtil.saveXmlBytes((Element)configRoot));
        }
        catch (Exception e) {
            try {
                throw new SMRuntimeException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{configIs});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{configIs});
        return configIs;
    }

    private static void modifyWsConfigXml(Element wsNode, String dataCenter) {
        ExplorerFactory.modifyDataCenterParam(wsNode.getChild("FileSystem"), dataCenter);
        ExplorerFactory.modifyDataCenterParam(wsNode.getChild("PersistenceManager"), dataCenter);
    }

    private static void modifyDataCenterParam(Element node, String dataCenter) {
        for (Element nodeParam : node.getChildren("param")) {
            if (!"dataCenter".equals(nodeParam.getAttributeValue("name"))) continue;
            nodeParam.setAttribute("value", dataCenter);
            return;
        }
        Element newParam = new Element("param");
        newParam.setAttribute("name", "dataCenter");
        newParam.setAttribute("value", dataCenter);
        node.addContent((Content)newParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buildRepositoryHomeDir(String dataCenter, String workspace) {
        StringBuffer sbDir = new StringBuffer();
        String ctrlhome = "";
        Object object = tmpRandomLock;
        synchronized (object) {
            ctrlhome = System.getProperty("java.io.tmpdir") + "/" + random.nextLong();
        }
        sbDir.append(ctrlhome);
        sbDir.append("/BIRepository/");
        sbDir.append(workspace);
        sbDir.append("@");
        sbDir.append(dataCenter);
        return sbDir.toString();
    }

    private static Session loginJcr(String dataCenter, String workspace) throws SMException {
        TransientRepository repository;
        RepositoryConfig rc;
        System.out.println(new StringBuffer("Login JCR, workspace: " + workspace + ", dataCenter: " + dataCenter));
        long lStart = System.currentTimeMillis();
        String repHomeDir = ExplorerFactory.buildRepositoryHomeDir(dataCenter, workspace);
        File homeDir = new File(repHomeDir);
        if (homeDir.exists()) {
            FileUtil.deleteFile((String)repHomeDir);
        }
        homeDir.mkdirs();
        InputStream configIs = ExplorerFactory.dynamicConfig(dataCenter);
        System.out.println("Create config file: cost " + (System.currentTimeMillis() - lStart));
        lStart = System.currentTimeMillis();
        try {
            rc = RepositoryConfig.create(configIs, repHomeDir);
        }
        catch (ConfigurationException e) {
            throw SMException.makeException((Throwable)((Object)e));
        }
        System.out.println("Create jackrabbit config : cost " + (System.currentTimeMillis() - lStart));
        lStart = System.currentTimeMillis();
        try {
            repository = new TransientRepository(rc);
        }
        catch (IOException e) {
            throw SMException.makeException(e);
        }
        System.out.println("Initial repository : cost " + (System.currentTimeMillis() - lStart));
        lStart = System.currentTimeMillis();
        SimpleCredentials cred = new SimpleCredentials("admin", "".toCharArray());
        Session session = null;
        Connection con = null;
        try {
            con = ExplorerFactory.getConnection(dataCenter);
            mapCacheConnection.put(dataCenter, con);
            Session tempSession = repository.login();
            ((WorkspaceImpl)tempSession.getWorkspace()).createWorkspace(workspace);
            session = repository.login((Credentials)cred, workspace);
            tempSession.logout();
        }
        catch (LoginException e) {
            throw SMException.makeException(e);
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        catch (SQLException e) {
            throw SMException.makeException(e);
        }
        finally {
            ExplorerFactory.closeConnection(con);
            mapCacheConnection.remove(dataCenter);
        }
        System.out.println("log in workspace " + workspace + " : cost " + (System.currentTimeMillis() - lStart));
        lStart = System.currentTimeMillis();
        try {
            session.getWorkspace().getNamespaceRegistry().registerNamespace("ctrl", "http://www.kingdee.com/ctrlstorage");
        }
        catch (NamespaceException e) {
            log.info((Object)"Namespace \"ctrl:\" has been registed.");
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        System.out.println("register namespace: cost " + (System.currentTimeMillis() - lStart));
        return session;
    }

    private static class LogoutListener
    implements Explorer.ExplorerListener {
        private String dataCenter;
        private String workspace;

        public LogoutListener(String dataCenter, String workspace) {
            this.dataCenter = dataCenter;
            this.workspace = workspace;
        }

        @Override
        public void logouted() {
            HashMap insts = (HashMap)_multiInstances.get(this.dataCenter);
            insts.remove(this.workspace);
            String repHomeDir = ExplorerFactory.buildRepositoryHomeDir(this.dataCenter, this.workspace);
            FileUtil.deleteFile((String)repHomeDir);
            log.info((Object)("Removed Explorer from cache, and deleted repHomeDir: " + repHomeDir));
        }
    }
}

