/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.analysis;

import com.kingdee.bos.ctrl.lucene.analysis.Token;
import com.kingdee.bos.ctrl.lucene.analysis.TokenFilter;
import com.kingdee.bos.ctrl.lucene.analysis.TokenStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class StopFilter
extends TokenFilter {
    private final Set stopWords;
    private final boolean ignoreCase;

    public StopFilter(TokenStream input, String[] stopWords) {
        this(input, stopWords, false);
    }

    public StopFilter(TokenStream in, String[] stopWords, boolean ignoreCase) {
        super(in);
        this.ignoreCase = ignoreCase;
        this.stopWords = StopFilter.makeStopSet(stopWords, ignoreCase);
    }

    public StopFilter(TokenStream input, Set stopWords, boolean ignoreCase) {
        super(input);
        this.ignoreCase = ignoreCase;
        this.stopWords = stopWords;
    }

    public StopFilter(TokenStream in, Set stopWords) {
        this(in, stopWords, false);
    }

    public static final Set makeStopSet(String[] stopWords) {
        return StopFilter.makeStopSet(stopWords, false);
    }

    public static final Set makeStopSet(String[] stopWords, boolean ignoreCase) {
        HashSet<String> stopTable = new HashSet<String>(stopWords.length);
        for (int i = 0; i < stopWords.length; ++i) {
            stopTable.add(ignoreCase ? stopWords[i].toLowerCase() : stopWords[i]);
        }
        return stopTable;
    }

    @Override
    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            String termText;
            String string = termText = this.ignoreCase ? token.termText.toLowerCase() : token.termText;
            if (!this.stopWords.contains(termText)) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }
}

