/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.index;

import com.kingdee.bos.ctrl.lucene.index.CorruptIndexException;
import com.kingdee.bos.ctrl.lucene.index.FieldInfos;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermBuffer;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import com.kingdee.bos.ctrl.lucene.index.TermInfo;
import com.kingdee.bos.ctrl.lucene.store.IndexInput;
import java.io.IOException;

final class SegmentTermEnum
extends TermEnum
implements Cloneable {
    private IndexInput input;
    FieldInfos fieldInfos;
    long size;
    long position = -1L;
    private TermBuffer termBuffer = new TermBuffer();
    private TermBuffer prevBuffer = new TermBuffer();
    private TermBuffer scratch;
    private TermInfo termInfo = new TermInfo();
    private int format;
    private boolean isIndex = false;
    long indexPointer = 0L;
    int indexInterval;
    int skipInterval;
    int maxSkipLevels;
    private int formatM1SkipInterval;

    SegmentTermEnum(IndexInput i, FieldInfos fis, boolean isi) throws CorruptIndexException, IOException {
        this.input = i;
        this.fieldInfos = fis;
        this.isIndex = isi;
        this.maxSkipLevels = 1;
        int firstInt = this.input.readInt();
        if (firstInt >= 0) {
            this.format = 0;
            this.size = firstInt;
            this.indexInterval = 128;
            this.skipInterval = Integer.MAX_VALUE;
        } else {
            this.format = firstInt;
            if (this.format < -3) {
                throw new CorruptIndexException("Unknown format version:" + this.format);
            }
            this.size = this.input.readLong();
            if (this.format == -1) {
                if (!this.isIndex) {
                    this.indexInterval = this.input.readInt();
                    this.formatM1SkipInterval = this.input.readInt();
                }
                this.skipInterval = Integer.MAX_VALUE;
            } else {
                this.indexInterval = this.input.readInt();
                this.skipInterval = this.input.readInt();
                if (this.format == -3) {
                    this.maxSkipLevels = this.input.readInt();
                }
            }
        }
    }

    protected Object clone() {
        SegmentTermEnum clone = null;
        try {
            clone = (SegmentTermEnum)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (null != clone) {
            clone.input = (IndexInput)this.input.clone();
            clone.termInfo = new TermInfo(this.termInfo);
            clone.termBuffer = (TermBuffer)this.termBuffer.clone();
            clone.prevBuffer = (TermBuffer)this.prevBuffer.clone();
            clone.scratch = null;
        }
        return clone;
    }

    final void seek(long pointer, int p, Term t, TermInfo ti) throws IOException {
        this.input.seek(pointer);
        this.position = p;
        this.termBuffer.set(t);
        this.prevBuffer.reset();
        this.termInfo.set(ti);
    }

    @Override
    public final boolean next() throws IOException {
        if (this.position++ >= this.size - 1L) {
            this.termBuffer.reset();
            return false;
        }
        this.prevBuffer.set(this.termBuffer);
        this.termBuffer.read(this.input, this.fieldInfos);
        this.termInfo.docFreq = this.input.readVInt();
        this.termInfo.freqPointer += this.input.readVLong();
        this.termInfo.proxPointer += this.input.readVLong();
        if (this.format == -1) {
            if (!this.isIndex && this.termInfo.docFreq > this.formatM1SkipInterval) {
                this.termInfo.skipOffset = this.input.readVInt();
            }
        } else if (this.termInfo.docFreq >= this.skipInterval) {
            this.termInfo.skipOffset = this.input.readVInt();
        }
        if (this.isIndex) {
            this.indexPointer += this.input.readVLong();
        }
        return true;
    }

    final void scanTo(Term term) throws IOException {
        if (this.scratch == null) {
            this.scratch = new TermBuffer();
        }
        this.scratch.set(term);
        while (this.scratch.compareTo(this.termBuffer) > 0 && this.next()) {
        }
    }

    @Override
    public final Term term() {
        return this.termBuffer.toTerm();
    }

    final Term prev() {
        return this.prevBuffer.toTerm();
    }

    final TermInfo termInfo() {
        return new TermInfo(this.termInfo);
    }

    final void termInfo(TermInfo ti) {
        ti.set(this.termInfo);
    }

    @Override
    public final int docFreq() {
        return this.termInfo.docFreq;
    }

    final long freqPointer() {
        return this.termInfo.freqPointer;
    }

    final long proxPointer() {
        return this.termInfo.proxPointer;
    }

    @Override
    public final void close() throws IOException {
        this.input.close();
    }
}

