/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import com.kingdee.bos.ctrl.lucene.search.BooleanClause;
import com.kingdee.bos.ctrl.lucene.search.BooleanQuery;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.TermQuery;
import com.kingdee.bos.ctrl.lucene.util.ToStringUtils;
import java.io.IOException;

public class PrefixQuery
extends Query {
    private Term prefix;

    public PrefixQuery(Term prefix) {
        this.prefix = prefix;
    }

    public Term getPrefix() {
        return this.prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery query = new BooleanQuery(true);
        try (TermEnum enumerator = reader.terms(this.prefix);){
            Term term;
            String prefixText = this.prefix.text();
            String prefixField = this.prefix.field();
            while ((term = enumerator.term()) != null && term.text().startsWith(prefixText) && term.field() == prefixField) {
                TermQuery tq = new TermQuery(term);
                tq.setBoost(this.getBoost());
                query.add(tq, BooleanClause.Occur.SHOULD);
                if (enumerator.next()) continue;
                break;
            }
        }
        return query;
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.prefix.field().equals(field)) {
            buffer.append(this.prefix.field());
            buffer.append(":");
        }
        buffer.append(this.prefix.text());
        buffer.append('*');
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PrefixQuery)) {
            return false;
        }
        PrefixQuery other = (PrefixQuery)o;
        return this.getBoost() == other.getBoost() && this.prefix.equals(other.prefix);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.prefix.hashCode() ^ 0x6634D93C;
    }
}

