/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.DefaultSimilarity;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.util.SmallFloat;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public abstract class Similarity
implements Serializable {
    private static Similarity defaultImpl = new DefaultSimilarity();
    private static final float[] NORM_TABLE = new float[256];

    public static void setDefault(Similarity similarity) {
        defaultImpl = similarity;
    }

    public static Similarity getDefault() {
        return defaultImpl;
    }

    public static float decodeNorm(byte b) {
        return NORM_TABLE[b & 0xFF];
    }

    public static float[] getNormDecoder() {
        return NORM_TABLE;
    }

    public abstract float lengthNorm(String var1, int var2);

    public abstract float queryNorm(float var1);

    public static byte encodeNorm(float f) {
        return SmallFloat.floatToByte315(f);
    }

    public float tf(int freq) {
        return this.tf((float)freq);
    }

    public abstract float sloppyFreq(int var1);

    public abstract float tf(float var1);

    public float idf(Term term, Searcher searcher) throws IOException {
        return this.idf(searcher.docFreq(term), searcher.maxDoc());
    }

    public float idf(Collection terms, Searcher searcher) throws IOException {
        float idf = 0.0f;
        Iterator i = terms.iterator();
        while (i.hasNext()) {
            idf += this.idf((Term)i.next(), searcher);
        }
        return idf;
    }

    public abstract float idf(int var1, int var2);

    public abstract float coord(int var1, int var2);

    public float scorePayload(byte[] payload, int offset, int length) {
        return 1.0f;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Similarity.NORM_TABLE[i] = SmallFloat.byte315ToFloat((byte)i);
        }
    }
}

