/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.search.HitCollector;
import com.kingdee.bos.ctrl.lucene.search.HitQueue;
import com.kingdee.bos.ctrl.lucene.search.ScoreDoc;
import com.kingdee.bos.ctrl.lucene.search.TopDocs;
import com.kingdee.bos.ctrl.lucene.util.PriorityQueue;

public class TopDocCollector
extends HitCollector {
    private int numHits;
    private float minScore = 0.0f;
    int totalHits;
    PriorityQueue hq;

    public TopDocCollector(int numHits) {
        this(numHits, new HitQueue(numHits));
    }

    TopDocCollector(int numHits, PriorityQueue hq) {
        this.numHits = numHits;
        this.hq = hq;
    }

    @Override
    public void collect(int doc, float score) {
        if (score > 0.0f) {
            ++this.totalHits;
            if (this.hq.size() < this.numHits || score >= this.minScore) {
                this.hq.insert(new ScoreDoc(doc, score));
                this.minScore = ((ScoreDoc)this.hq.top()).score;
            }
        }
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public TopDocs topDocs() {
        ScoreDoc[] scoreDocs = new ScoreDoc[this.hq.size()];
        for (int i = this.hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)this.hq.pop();
        }
        float maxScore = this.totalHits == 0 ? Float.NEGATIVE_INFINITY : scoreDocs[0].score;
        return new TopDocs(this.totalHits, scoreDocs, maxScore);
    }
}

