/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.core.cluster.NamespaceEventChannel;
import org.apache.jackrabbit.core.cluster.NamespaceEventListener;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.namespace.AbstractNamespaceResolver;
import org.apache.jackrabbit.util.XMLChar;
import org.slf4j.Logger;

public class NamespaceRegistryImpl
extends AbstractNamespaceResolver
implements NamespaceRegistry,
NamespaceEventListener {
    private static Logger log = CommonSLF4JLogger.getLogger(NamespaceRegistryImpl.class);
    private static final String NS_REG_RESOURCE = "ns_reg.properties";
    private static final String NS_IDX_RESOURCE = "ns_idx.properties";
    private static final HashSet reservedPrefixes = new HashSet();
    private static final HashSet reservedURIs = new HashSet();
    private HashMap prefixToURI = new HashMap();
    private HashMap uriToPrefix = new HashMap();
    private HashMap indexToURI = new HashMap();
    private HashMap uriToIndex = new HashMap();
    private int lastIndex = 0;
    private NameResolver nameResolver;
    private PathResolver pathResolver;
    private final FileSystem nsRegStore;
    private NamespaceEventChannel eventChannel;

    protected NamespaceRegistryImpl(FileSystem nsRegStore) throws RepositoryException {
        super(true);
        this.nsRegStore = nsRegStore;
        this.load();
    }

    private void clear() {
        this.prefixToURI.clear();
        this.uriToPrefix.clear();
        this.indexToURI.clear();
        this.uriToIndex.clear();
    }

    private void map(String prefix, String uri) {
        this.map(prefix, uri, null);
    }

    private void map(String prefix, String uri, Integer idx) {
        this.prefixToURI.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
        if (!this.uriToIndex.containsKey(uri)) {
            if (idx == null) {
                idx = new Integer(++this.lastIndex);
            } else if (idx > this.lastIndex) {
                this.lastIndex = idx;
            }
            this.indexToURI.put(idx, uri);
            this.uriToIndex.put(uri, idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws RepositoryException {
        FileSystemResource propFile = new FileSystemResource(this.nsRegStore, NS_REG_RESOURCE);
        FileSystemResource idxFile = new FileSystemResource(this.nsRegStore, NS_IDX_RESOURCE);
        try {
            InputStream in;
            if (!propFile.exists()) {
                this.clear();
                this.map("", "");
                this.map("rep", "internal");
                this.map("jcr", "http://www.jcp.org/jcr/1.0");
                this.map("nt", "http://www.jcp.org/jcr/nt/1.0");
                this.map("mix", "http://www.jcp.org/jcr/mix/1.0");
                this.map("sv", "http://www.jcp.org/jcr/sv/1.0");
                this.map("xml", "http://www.w3.org/XML/1998/namespace");
                this.store();
                return;
            }
            Properties indexes = new Properties();
            if (idxFile.exists()) {
                in = idxFile.getInputStream();
                try {
                    indexes.load(in);
                }
                finally {
                    in.close();
                }
            }
            in = propFile.getInputStream();
            try {
                Properties props = new Properties();
                props.load(in);
                this.clear();
                for (String string : props.keySet()) {
                    String uri = props.getProperty(string);
                    String idx = indexes.getProperty(uri);
                    if (idx != null) {
                        this.map(string, uri, Integer.decode(idx));
                        continue;
                    }
                    this.map(string, uri);
                }
            }
            finally {
                in.close();
            }
            if (!idxFile.exists()) {
                this.store();
            }
        }
        catch (Exception e) {
            String msg = "failed to load namespace registry";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws RepositoryException {
        FileSystemResource propFile = new FileSystemResource(this.nsRegStore, NS_REG_RESOURCE);
        try {
            propFile.makeParentDirs();
            OutputStream os = propFile.getOutputStream();
            Properties props = new Properties();
            for (String prefix : this.prefixToURI.keySet()) {
                String uri = (String)this.prefixToURI.get(prefix);
                props.setProperty(prefix, uri);
            }
            try {
                props.store(os, null);
            }
            finally {
                os.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to persist namespace registry";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        FileSystemResource indexFile = new FileSystemResource(this.nsRegStore, NS_IDX_RESOURCE);
        try {
            indexFile.makeParentDirs();
            OutputStream os = indexFile.getOutputStream();
            Properties props = new Properties();
            for (String uri : this.uriToIndex.keySet()) {
                String index = this.uriToIndex.get(uri).toString();
                props.setProperty(uri, index);
            }
            try {
                props.store(os, null);
            }
            finally {
                os.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to persist namespace registry index.";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    public PathResolver getPathResolver() {
        return this.pathResolver;
    }

    public String getUniquePrefix(String uriHint) {
        return "_pre" + (this.prefixToURI.size() + 1);
    }

    public synchronized void safeRegisterNamespace(String prefixHint, String uri) throws NamespaceException, RepositoryException {
        try {
            this.getPrefix(uri);
        }
        catch (NamespaceException e1) {
            if (prefixHint.toLowerCase().startsWith("xml") || !XMLChar.isValidNCName(prefixHint)) {
                prefixHint = "_pre";
            }
            String prefix = prefixHint;
            try {
                int suffix = 2;
                while (true) {
                    this.getURI(prefix);
                    prefix = prefixHint + suffix;
                    ++suffix;
                }
            }
            catch (NamespaceException e2) {
                this.registerNamespace(prefix, uri);
            }
        }
    }

    public void setEventChannel(NamespaceEventChannel eventChannel) {
        this.eventChannel = eventChannel;
        eventChannel.setListener(this);
    }

    public int getURIIndex(String uri) throws NamespaceException {
        Integer idx = (Integer)this.uriToIndex.get(uri);
        if (idx == null) {
            throw new NamespaceException("URI " + uri + " is not registered.");
        }
        return idx;
    }

    public String getURI(int idx) throws NamespaceException {
        String uri = (String)this.indexToURI.get(new Integer(idx));
        if (uri == null) {
            throw new NamespaceException("URI for index " + idx + " not registered.");
        }
        return uri;
    }

    public synchronized void registerNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        if (prefix == null || uri == null) {
            throw new IllegalArgumentException("prefix/uri can not be null");
        }
        if ("".equals(prefix) || "".equals(uri)) {
            throw new NamespaceException("default namespace is reserved and can not be changed");
        }
        if (reservedURIs.contains(uri)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved URI");
        }
        if (reservedPrefixes.contains(prefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved prefix");
        }
        if (prefix.toLowerCase(Locale.ENGLISH).startsWith("xml")) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved prefix");
        }
        if (!XMLChar.isValidNCName(prefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": invalid prefix");
        }
        String oldPrefix = (String)this.uriToPrefix.get(uri);
        if (prefix.equals(oldPrefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": mapping already exists");
        }
        if (this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": remapping existing prefixes is not supported.");
        }
        if (oldPrefix != null) {
            this.prefixToURI.remove(oldPrefix);
            this.uriToPrefix.remove(uri);
        }
        this.map(prefix, uri);
        if (this.eventChannel != null) {
            this.eventChannel.remapped(oldPrefix, prefix, uri);
        }
        this.store();
        if (oldPrefix != null) {
            this.notifyNamespaceRemapped(oldPrefix, prefix, uri);
        } else {
            this.notifyNamespaceAdded(prefix, uri);
        }
    }

    public void unregisterNamespace(String prefix) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        if (reservedPrefixes.contains(prefix)) {
            throw new NamespaceException("reserved prefix: " + prefix);
        }
        if (!this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException("unknown prefix: " + prefix);
        }
        throw new NamespaceException("unregistering namespaces is not supported.");
    }

    public String[] getPrefixes() throws RepositoryException {
        return this.prefixToURI.keySet().toArray(new String[this.prefixToURI.keySet().size()]);
    }

    public String[] getURIs() throws RepositoryException {
        return this.uriToPrefix.keySet().toArray(new String[this.uriToPrefix.keySet().size()]);
    }

    @Override
    public String getURI(String prefix) throws NamespaceException {
        String uri = (String)this.prefixToURI.get(prefix);
        if (uri == null) {
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
        return uri;
    }

    @Override
    public String getPrefix(String uri) throws NamespaceException {
        String prefix = (String)this.uriToPrefix.get(uri);
        if (prefix == null) {
            throw new NamespaceException(uri + ": is not a registered namespace uri.");
        }
        return prefix;
    }

    @Override
    public void externalRemap(String oldPrefix, String newPrefix, String uri) throws RepositoryException {
        if (newPrefix == null) {
            throw new NamespaceException("unregistering namespaces is not supported.");
        }
        if (oldPrefix != null) {
            this.prefixToURI.remove(oldPrefix);
            this.uriToPrefix.remove(uri);
        }
        this.map(newPrefix, uri);
        this.store();
        if (oldPrefix != null) {
            this.notifyNamespaceRemapped(oldPrefix, newPrefix, uri);
        } else {
            this.notifyNamespaceAdded(newPrefix, uri);
        }
    }

    static {
        reservedPrefixes.add("xml");
        reservedPrefixes.add("xmlns");
        reservedPrefixes.add("rep");
        reservedPrefixes.add("jcr");
        reservedPrefixes.add("nt");
        reservedPrefixes.add("mix");
        reservedPrefixes.add("sv");
        reservedURIs.add("http://www.w3.org/XML/1998/namespace");
        reservedURIs.add("http://www.w3.org/2000/xmlns/");
        reservedURIs.add("internal");
        reservedURIs.add("http://www.jcp.org/jcr/1.0");
        reservedURIs.add("http://www.jcp.org/jcr/nt/1.0");
        reservedURIs.add("http://www.jcp.org/jcr/mix/1.0");
        reservedURIs.add("http://www.jcp.org/jcr/sv/1.0");
    }
}

