/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.XASession;
import org.apache.jackrabbit.core.XAWorkspace;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.lock.XALockManager;
import org.apache.jackrabbit.core.security.AuthContext;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.state.XAItemStateManager;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.core.version.VersionManagerImpl;
import org.apache.jackrabbit.core.version.XAVersionManager;
import org.slf4j.Logger;

public class XASessionImpl
extends SessionImpl
implements XASession,
XAResource {
    private static final Logger log = CommonSLF4JLogger.getLogger(XASessionImpl.class);
    private static final Map txGlobal = Collections.synchronizedMap(new HashMap());
    private static final int DEFAULT_TX_TIMEOUT = 5;
    private TransactionContext tx;
    private int txTimeout;
    private InternalXAResource[] txResources;
    private LockManager lockMgr;

    protected XASessionImpl(RepositoryImpl rep, AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        super(rep, loginContext, wspConfig);
        this.init();
    }

    protected XASessionImpl(RepositoryImpl rep, Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        super(rep, subject, wspConfig);
        this.init();
    }

    private void init() throws RepositoryException {
        XAItemStateManager stateMgr = (XAItemStateManager)this.wsp.getItemStateManager();
        XALockManager lockMgr = (XALockManager)this.getLockManager();
        XAVersionManager versionMgr = (XAVersionManager)this.getVersionManager();
        this.txResources = new InternalXAResource[]{versionMgr.getXAResourceBegin(), stateMgr, lockMgr, versionMgr, versionMgr.getXAResourceEnd()};
        stateMgr.setVirtualProvider(versionMgr);
    }

    @Override
    protected WorkspaceImpl createWorkspaceInstance(WorkspaceConfig wspConfig, SharedItemStateManager stateMgr, RepositoryImpl rep, SessionImpl session) {
        return new XAWorkspace(wspConfig, stateMgr, rep, session);
    }

    @Override
    protected VersionManager createVersionManager(RepositoryImpl rep) throws RepositoryException {
        VersionManagerImpl vMgr = (VersionManagerImpl)rep.getVersionManager();
        return new XAVersionManager(vMgr, rep.getNodeTypeRegistry(), this, rep.getItemStateCacheFactory());
    }

    @Override
    public LockManager getLockManager() throws RepositoryException {
        if (this.lockMgr == null) {
            LockManagerImpl lockMgr = (LockManagerImpl)this.wsp.getLockManager();
            this.lockMgr = new XALockManager(lockMgr);
        }
        return this.lockMgr;
    }

    @Override
    public XAResource getXAResource() {
        return this;
    }

    @Override
    public int getTransactionTimeout() {
        return this.txTimeout == 0 ? 5 : this.txTimeout;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) {
        this.txTimeout = seconds;
        return true;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares instanceof XASessionImpl) {
            XASessionImpl xases = (XASessionImpl)xares;
            return XASessionImpl.stringsEqual(this.userId, xases.userId);
        }
        return false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.isAssociated()) {
            log.error("Resource already associated with a transaction.");
            throw new XAException(-6);
        }
        TransactionContext tx = (TransactionContext)txGlobal.get(xid);
        if (flags == 0) {
            if (tx != null) {
                throw new XAException(-8);
            }
            tx = this.createTransaction(xid);
        } else if (flags == 0x200000) {
            if (tx == null) {
                throw new XAException(-4);
            }
        } else if (flags == 0x8000000) {
            if (tx == null) {
                throw new XAException(-4);
            }
            if (!tx.isSuspended()) {
                log.error("Unable to resume: transaction not suspended.");
                throw new XAException(-6);
            }
            tx.setSuspended(false);
        } else {
            throw new XAException(-5);
        }
        this.associate(tx);
    }

    private TransactionContext createTransaction(Xid xid) {
        TransactionContext tx = new TransactionContext(this.txResources, this.getTransactionTimeout());
        txGlobal.put(xid, tx);
        return tx;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        TransactionContext tx = (TransactionContext)txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        if (flags == 0x2000000) {
            if (!this.isAssociated()) {
                log.error("Resource not associated with a transaction.");
                throw new XAException(-6);
            }
            this.associate(null);
            tx.setSuspended(true);
        } else if (flags == 0x20000000 || flags == 0x4000000) {
            if (!tx.isSuspended()) {
                if (!this.isAssociated()) {
                    log.error("Resource not associated with a transaction.");
                    throw new XAException(-6);
                }
                this.associate(null);
            } else {
                tx.setSuspended(false);
            }
        } else {
            throw new XAException(-5);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        TransactionContext tx = (TransactionContext)txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        tx.prepare();
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        TransactionContext tx = (TransactionContext)txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        if (onePhase) {
            tx.prepare();
        }
        tx.commit();
        txGlobal.remove(xid);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        TransactionContext tx = (TransactionContext)txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        tx.rollback();
        txGlobal.remove(xid);
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        return new Xid[0];
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    public synchronized void associate(TransactionContext tx) {
        this.tx = tx;
        for (int i = 0; i < this.txResources.length; ++i) {
            InternalXAResource txResource = this.txResources[i];
            txResource.associate(tx);
        }
    }

    private boolean isAssociated() {
        return this.tx != null;
    }

    @Override
    public synchronized void logout() {
        super.logout();
        try {
            ((XAVersionManager)this.versionMgr).close();
        }
        catch (Exception e) {
            log.warn("error while closing XAVersionManager", (Throwable)e);
        }
    }

    private static boolean stringsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }
}

