/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.compact.CompactNodeTypeDefReader;
import org.apache.jackrabbit.core.nodetype.compact.CompactNodeTypeDefWriter;
import org.apache.jackrabbit.core.nodetype.compact.ParseException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.uuid.UUID;

public abstract class AbstractRecord
implements Record {
    private static final byte UUID_LITERAL = 76;
    private static final byte UUID_INDEX = 73;
    private final ArrayList uuidIndex = new ArrayList();
    protected final NamespaceResolver nsResolver;
    protected final NamePathResolver resolver;

    public AbstractRecord(NamespaceResolver nsResolver, NamePathResolver resolver) {
        this.nsResolver = nsResolver;
        this.resolver = resolver;
    }

    @Override
    public void writeQName(Name name) throws JournalException {
        try {
            this.writeString(this.resolver.getJCRName(name));
        }
        catch (NamespaceException e) {
            String msg = "Undeclared prefix error while writing name.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void writePathElement(Path.Element element) throws JournalException {
        this.writeQName(element.getName());
        this.writeInt(element.getIndex());
    }

    @Override
    public void writePath(Path path) throws JournalException {
        try {
            this.writeString(this.resolver.getJCRPath(path));
        }
        catch (NamespaceException e) {
            String msg = "Undeclared prefix error while writing path.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void writeNodeId(NodeId nodeId) throws JournalException {
        if (nodeId == null) {
            this.writeByte(73);
            this.writeInt(-1);
        } else {
            int index = this.getOrCreateIndex(nodeId);
            if (index != -1) {
                this.writeByte(73);
                this.writeInt(index);
            } else {
                this.writeByte(76);
                this.write(nodeId.getUUID().getRawBytes());
            }
        }
    }

    @Override
    public void writePropertyId(PropertyId propertyId) throws JournalException {
        this.writeNodeId(propertyId.getParentId());
        this.writeQName(propertyId.getName());
    }

    @Override
    public void writeNodeTypeDef(NodeTypeDef ntd) throws JournalException {
        try {
            StringWriter sw = new StringWriter();
            CompactNodeTypeDefWriter writer = new CompactNodeTypeDefWriter(sw, this.nsResolver, this.resolver, true);
            writer.write(ntd);
            writer.close();
            this.writeString(sw.toString());
        }
        catch (IOException e) {
            String msg = "I/O error while writing node type definition.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public Name readQName() throws JournalException {
        try {
            return this.resolver.getQName(this.readString());
        }
        catch (NameException e) {
            String msg = "Unknown prefix error while reading name.";
            throw new JournalException(msg, (Throwable)((Object)e));
        }
        catch (NamespaceException e) {
            String msg = "Illegal name error while reading name.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public Path.Element readPathElement() throws JournalException {
        try {
            Name name = this.resolver.getQName(this.readString());
            int index = this.readInt();
            if (index != 0) {
                return PathFactoryImpl.getInstance().createElement(name, index);
            }
            return PathFactoryImpl.getInstance().createElement(name);
        }
        catch (NameException e) {
            String msg = "Unknown prefix error while reading path element.";
            throw new JournalException(msg, (Throwable)((Object)e));
        }
        catch (NamespaceException e) {
            String msg = "Illegal name error while reading path element.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public Path readPath() throws JournalException {
        try {
            return this.resolver.getQPath(this.readString());
        }
        catch (MalformedPathException e) {
            String msg = "Malformed path error while reading path.";
            throw new JournalException(msg, (Throwable)((Object)e));
        }
        catch (NamespaceException e) {
            String msg = "Malformed path error while reading path.";
            throw new JournalException(msg, e);
        }
        catch (NameException e) {
            String msg = "Malformed path error while reading path.";
            throw new JournalException(msg, (Throwable)((Object)e));
        }
    }

    @Override
    public NodeId readNodeId() throws JournalException {
        byte uuidType = this.readByte();
        if (uuidType == 73) {
            int index = this.readInt();
            if (index == -1) {
                return null;
            }
            return (NodeId)this.uuidIndex.get(index);
        }
        if (uuidType == 76) {
            byte[] b = new byte[16];
            this.readFully(b);
            NodeId nodeId = new NodeId(new UUID(b));
            this.uuidIndex.add(nodeId);
            return nodeId;
        }
        String msg = "Unknown UUID type found: " + uuidType;
        throw new JournalException(msg);
    }

    @Override
    public PropertyId readPropertyId() throws JournalException {
        return new PropertyId(this.readNodeId(), this.readQName());
    }

    @Override
    public NodeTypeDef readNodeTypeDef() throws JournalException {
        try {
            StringReader sr = new StringReader(this.readString());
            CompactNodeTypeDefReader reader = new CompactNodeTypeDefReader(sr, "(internal)");
            List ntds = reader.getNodeTypeDefs();
            if (ntds.size() != 1) {
                throw new JournalException("Expected one node type definition: got " + ntds.size());
            }
            return (NodeTypeDef)ntds.get(0);
        }
        catch (ParseException e) {
            String msg = "Parse error while reading node type definition.";
            throw new JournalException(msg, e);
        }
    }

    private int getOrCreateIndex(NodeId nodeId) {
        int index = this.uuidIndex.indexOf(nodeId);
        if (index == -1) {
            this.uuidIndex.add(nodeId);
        }
        return index;
    }
}

