/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.lock.AbstractLockInfo;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.lock.XAEnvironment;
import org.apache.jackrabbit.core.lock.XALock;
import org.apache.jackrabbit.spi.Path;

public class XALockManager
implements LockManager,
InternalXAResource {
    private static final String XA_ENV_ATTRIBUTE_NAME = "XALockManager.XAEnv";
    private final LockManagerImpl lockMgr;
    private XAEnvironment xaEnv;

    public XALockManager(LockManagerImpl lockMgr) {
        this.lockMgr = lockMgr;
    }

    @Override
    public Lock lock(NodeImpl node, boolean isDeep, boolean isSessionScoped) throws LockException, RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.lock(node, isDeep, isSessionScoped) : this.lockMgr.internalLock(node, isDeep, isSessionScoped);
        return new XALock(this, info, node);
    }

    @Override
    public Lock getLock(NodeImpl node) throws LockException, RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        if (info == null) {
            throw new LockException("Node not locked: " + node.safeGetJCRPath());
        }
        SessionImpl session = (SessionImpl)node.getSession();
        NodeImpl holder = (NodeImpl)session.getItemManager().getItem(info.getId());
        return new XALock(this, info, holder);
    }

    @Override
    public Lock[] getLocks(SessionImpl session) throws RepositoryException {
        AbstractLockInfo[] infos = this.isInXA() ? this.xaEnv.getLockInfos(session) : this.lockMgr.getLockInfos(session);
        Lock[] locks = new XALock[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            AbstractLockInfo info = infos[i];
            NodeImpl holder = (NodeImpl)session.getItemManager().getItem(info.getId());
            locks[i] = new XALock(this, info, holder);
        }
        return locks;
    }

    @Override
    public void unlock(NodeImpl node) throws LockException, RepositoryException {
        if (this.isInXA()) {
            this.xaEnv.unlock(node);
        } else {
            this.lockMgr.unlock(node);
        }
    }

    @Override
    public boolean holdsLock(NodeImpl node) throws RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        return info != null && info.getId().equals(node.getId());
    }

    @Override
    public boolean isLockHolder(Session session, NodeImpl node) throws RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        return info != null && info.getId().equals(node.getId()) && info.getLockHolder() == session;
    }

    @Override
    public boolean isLocked(NodeImpl node) throws RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        return info != null;
    }

    @Override
    public void checkLock(NodeImpl node) throws LockException, RepositoryException {
        AbstractLockInfo info = this.isInXA() ? this.xaEnv.getLockInfo(node) : this.lockMgr.getLockInfo(node.getNodeId());
        if (info != null && info.getLockHolder() != node.getSession()) {
            throw new LockException("Node locked.");
        }
    }

    @Override
    public void checkLock(Path path, Session session) throws LockException, RepositoryException {
        SessionImpl sessionImpl = (SessionImpl)session;
        this.checkLock(sessionImpl.getItemManager().getNode(path));
    }

    @Override
    public void lockTokenAdded(SessionImpl session, String lt) {
        if (this.isInXA()) {
            this.xaEnv.addLockToken(lt);
        } else {
            this.lockMgr.lockTokenAdded(session, lt);
        }
    }

    @Override
    public void lockTokenRemoved(SessionImpl session, String lt) {
        if (this.isInXA()) {
            this.xaEnv.removeLockToken(lt);
        } else {
            this.lockMgr.lockTokenRemoved(session, lt);
        }
    }

    @Override
    public void associate(TransactionContext tx) {
        XAEnvironment xaEnv = null;
        if (tx != null && (xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME)) == null) {
            xaEnv = new XAEnvironment(this.lockMgr);
            tx.setAttribute(XA_ENV_ATTRIBUTE_NAME, xaEnv);
        }
        this.xaEnv = xaEnv;
    }

    @Override
    public void beforeOperation(TransactionContext tx) {
    }

    @Override
    public void prepare(TransactionContext tx) throws TransactionException {
        XAEnvironment xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME);
        if (xaEnv != null) {
            xaEnv.prepare();
        }
    }

    @Override
    public void commit(TransactionContext tx) {
        XAEnvironment xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME);
        if (xaEnv != null) {
            xaEnv.commit();
        }
    }

    @Override
    public void rollback(TransactionContext tx) {
        XAEnvironment xaEnv = (XAEnvironment)tx.getAttribute(XA_ENV_ATTRIBUTE_NAME);
        if (xaEnv != null) {
            xaEnv.rollback();
        }
    }

    @Override
    public void afterOperation(TransactionContext tx) {
    }

    public boolean differentXAEnv(AbstractLockInfo info) {
        if (this.isInXA()) {
            return this.xaEnv.differentXAEnv(info);
        }
        return info instanceof XAEnvironment.LockInfo;
    }

    private boolean isInXA() {
        return this.xaEnv != null;
    }
}

