/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.ReferenceConstraint;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class NodeTypeDef
implements Cloneable {
    private Name name = null;
    private Name[] supertypes;
    private boolean mixin = false;
    private boolean orderableChildNodes = false;
    private boolean abstractStatus = false;
    private Name primaryItemName = null;
    private HashSet propDefs;
    private HashSet nodeDefs = new HashSet();
    private Set dependencies = null;

    public NodeTypeDef() {
        this.propDefs = new HashSet();
        this.supertypes = Name.EMPTY_ARRAY;
    }

    public Collection getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HashSet();
            this.dependencies.addAll(Arrays.asList(this.supertypes));
            for (NodeDef nd : this.nodeDefs) {
                Name ntName = nd.getDefaultPrimaryType();
                if (ntName != null && !this.name.equals(ntName)) {
                    this.dependencies.add(ntName);
                }
                Name[] ntNames = nd.getRequiredPrimaryTypes();
                for (int j = 0; j < ntNames.length; ++j) {
                    if (ntNames[j] == null || this.name.equals(ntNames[j])) continue;
                    this.dependencies.add(ntNames[j]);
                }
            }
            for (PropDef pd : this.propDefs) {
                ValueConstraint[] ca;
                if (pd.getRequiredType() != 9 || (ca = pd.getValueConstraints()) == null) continue;
                for (int j = 0; j < ca.length; ++j) {
                    ReferenceConstraint rc = (ReferenceConstraint)ca[j];
                    if (this.name.equals(rc.getNodeTypeName())) continue;
                    this.dependencies.add(rc.getNodeTypeName());
                }
            }
        }
        return this.dependencies;
    }

    private void resetDependencies() {
        this.dependencies = null;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public void setSupertypes(Name[] names) {
        this.resetDependencies();
        if (names.length == 0) {
            this.supertypes = Name.EMPTY_ARRAY;
        } else if (names.length == 1) {
            this.supertypes = new Name[]{names[0]};
        } else {
            TreeSet<Name> types = new TreeSet<Name>();
            types.addAll(Arrays.asList(names));
            this.supertypes = types.toArray(new Name[types.size()]);
        }
    }

    public void setMixin(boolean mixin) {
        this.mixin = mixin;
    }

    public void setOrderableChildNodes(boolean orderableChildNodes) {
        this.orderableChildNodes = orderableChildNodes;
    }

    public void setAbstract(boolean abstractStatus) {
        this.abstractStatus = abstractStatus;
    }

    public void setPrimaryItemName(Name primaryItemName) {
        this.primaryItemName = primaryItemName;
    }

    public void setPropertyDefs(PropDef[] defs) {
        this.resetDependencies();
        this.propDefs.clear();
        this.propDefs.addAll(Arrays.asList(defs));
    }

    public void setChildNodeDefs(NodeDef[] defs) {
        this.resetDependencies();
        this.nodeDefs.clear();
        this.nodeDefs.addAll(Arrays.asList(defs));
    }

    public Name getName() {
        return this.name;
    }

    public Name[] getSupertypes() {
        if (this.supertypes.length > 0 || this.isMixin() || NameConstants.NT_BASE.equals(this.getName())) {
            return this.supertypes;
        }
        return new Name[]{NameConstants.NT_BASE};
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public boolean isAbstract() {
        return this.abstractStatus;
    }

    public Name getPrimaryItemName() {
        return this.primaryItemName;
    }

    public PropDef[] getPropertyDefs() {
        if (this.propDefs.isEmpty()) {
            return PropDef.EMPTY_ARRAY;
        }
        return this.propDefs.toArray(new PropDef[this.propDefs.size()]);
    }

    public NodeDef[] getChildNodeDefs() {
        if (this.nodeDefs.isEmpty()) {
            return NodeDef.EMPTY_ARRAY;
        }
        return this.nodeDefs.toArray(new NodeDef[this.nodeDefs.size()]);
    }

    public Object clone() {
        NodeTypeDef clone = new NodeTypeDef();
        clone.name = this.name;
        clone.primaryItemName = this.primaryItemName;
        clone.supertypes = this.supertypes;
        clone.mixin = this.mixin;
        clone.orderableChildNodes = this.orderableChildNodes;
        clone.nodeDefs = (HashSet)this.nodeDefs.clone();
        clone.propDefs = (HashSet)this.propDefs.clone();
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeTypeDef) {
            NodeTypeDef other = (NodeTypeDef)obj;
            return (this.name == null ? other.name == null : this.name.equals(other.name)) && (this.primaryItemName == null ? other.primaryItemName == null : this.primaryItemName.equals(other.primaryItemName)) && Arrays.equals(this.getSupertypes(), other.getSupertypes()) && this.mixin == other.mixin && this.orderableChildNodes == other.orderableChildNodes && this.propDefs.equals(other.propDefs) && this.nodeDefs.equals(other.nodeDefs);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

