/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeIdIterator;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.fs.BasedFileSystem;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.bundle.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.bundle.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.bundle.util.TrackingInputStream;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;

public class BundleFsPersistenceManager
extends AbstractBundlePersistenceManager {
    static final String CVS_ID = "$URL: http://svn.apache.org/repos/asf/jackrabbit/tags/1.4/jackrabbit-core/src/main/java/org/apache/jackrabbit/core/persistence/bundle/BundleFsPersistenceManager.java $ $Rev: 604211 $ $Date: 2007-12-14 17:23:58 +0200 (Fri, 14 Dec 2007) $";
    private static Logger log = CommonSLF4JLogger.getLogger(BundleFsPersistenceManager.class);
    protected boolean initialized = false;
    protected CloseableBLOBStore blobStore;
    private int blobFSBlockSize = 0;
    private int minBlobSize = 4096;
    private FileSystem itemFs;
    protected ErrorHandling errorHandling = new ErrorHandling();
    protected BundleBinding binding;
    private String name = super.toString();

    public String getBlobFSBlockSize() {
        return String.valueOf(this.blobFSBlockSize);
    }

    public void setBlobFSBlockSize(String size) {
        this.blobFSBlockSize = Integer.decode(size);
    }

    public boolean useLocalFsBlobStore() {
        return this.blobFSBlockSize == 0;
    }

    public int getMinBlobSize() {
        return this.minBlobSize;
    }

    public void setMinBlobSize(String minBlobSize) {
        this.minBlobSize = Integer.decode(minBlobSize);
    }

    public void setErrorHandling(String errorHandling) {
        this.errorHandling = new ErrorHandling(errorHandling);
    }

    public String getErrorHandling() {
        return this.errorHandling.toString();
    }

    @Override
    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        super.init(context);
        this.name = context.getHomeDir().getName();
        this.itemFs = new BasedFileSystem(context.getFileSystem(), "items");
        if (this.useLocalFsBlobStore()) {
            LocalFileSystem blobFS = new LocalFileSystem();
            blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
            blobFS.init();
            this.blobStore = new FSBlobStore(blobFS);
        } else {
            this.blobStore = new FSBlobStore(this.itemFs);
        }
        this.binding = new BundleBinding(this.errorHandling, this.blobStore, this.getNsIndex(), this.getNameIndex(), context.getDataStore());
        this.binding.setMinBlobSize(this.minBlobSize);
        this.initialized = true;
    }

    @Override
    protected BundleBinding getBinding() {
        return this.binding;
    }

    @Override
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            this.blobStore.close();
            this.blobStore = null;
            this.itemFs.close();
            this.itemFs = null;
        }
        finally {
            this.initialized = false;
        }
    }

    @Override
    protected synchronized NodePropBundle loadBundle(NodeId id) throws ItemStateException {
        DataInputStream din = null;
        try {
            String path = this.buildNodeFilePath(null, id).toString();
            if (!this.itemFs.exists(path)) {
                NodePropBundle nodePropBundle = null;
                return nodePropBundle;
            }
            InputStream in = this.itemFs.getInputStream(path);
            TrackingInputStream cin = new TrackingInputStream(in);
            din = new DataInputStream(cin);
            NodePropBundle bundle = this.binding.readBundle(din, id);
            bundle.setSize(cin.getPosition());
            NodePropBundle nodePropBundle = bundle;
            this.closeStream(din);
            return nodePropBundle;
        }
        catch (Exception e) {
            String msg = "failed to read bundle: " + id + ": " + e;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
        finally {
            this.closeStream(din);
        }
    }

    @Override
    protected synchronized boolean existsBundle(NodeId id) throws ItemStateException {
        try {
            StringBuffer buf = this.buildNodeFilePath(null, id);
            return this.itemFs.exists(buf.toString());
        }
        catch (Exception e) {
            String msg = "failed to check existence of bundle: " + id;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    protected StringBuffer buildNodeFilePath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id);
        buf.append('.');
        buf.append("n");
        return buf;
    }

    @Override
    protected StringBuffer buildNodeReferencesFilePath(StringBuffer buf, NodeReferencesId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id.getTargetId());
        buf.append('.');
        buf.append("r");
        return buf;
    }

    @Override
    protected synchronized void storeBundle(NodePropBundle bundle) throws ItemStateException {
        OutputStream out = null;
        try {
            StringBuffer buf = this.buildNodeFolderPath(null, bundle.getId());
            buf.append('.');
            buf.append("n");
            String fileName = buf.toString();
            String dir = fileName.substring(0, fileName.lastIndexOf(47));
            if (!this.itemFs.exists(dir)) {
                this.itemFs.createFolder(dir);
            }
            out = this.itemFs.getOutputStream(fileName);
            DataOutputStream dout = new DataOutputStream(out);
            this.binding.writeBundle(dout, bundle);
            dout.flush();
        }
        catch (Exception e) {
            try {
                String msg = "failed to write bundle: " + bundle.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{out});
    }

    @Override
    protected synchronized void destroyBundle(NodePropBundle bundle) throws ItemStateException {
        try {
            StringBuffer buf = this.buildNodeFilePath(null, bundle.getId());
            this.itemFs.deleteFile(buf.toString());
        }
        catch (Exception e) {
            if (e instanceof NoSuchItemStateException) {
                throw (NoSuchItemStateException)e;
            }
            String msg = "failed to delete bundle: " + bundle.getId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized NodeReferences load(NodeReferencesId targetId) throws NoSuchItemStateException, ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        InputStream in = null;
        try {
            String path = this.buildNodeReferencesFilePath(null, targetId).toString();
            if (!this.itemFs.exists(path)) {
                throw new NoSuchItemStateException(targetId.toString());
            }
            in = this.itemFs.getInputStream(path);
            NodeReferences refs = new NodeReferences(targetId);
            Serializer.deserialize(refs, in);
            NodeReferences nodeReferences = refs;
            this.closeStream(in);
            return nodeReferences;
        }
        catch (NoSuchItemStateException e) {
            try {
                throw e;
                catch (Exception e2) {
                    String msg = "failed to read references: " + targetId;
                    log.error(msg, (Throwable)e2);
                    throw new ItemStateException(msg, e2);
                }
            }
            catch (Throwable throwable) {
                this.closeStream(in);
                throw throwable;
            }
        }
    }

    @Override
    public synchronized void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        OutputStream out = null;
        try {
            StringBuffer buf = this.buildNodeFolderPath(null, refs.getTargetId());
            buf.append('.');
            buf.append("r");
            String fileName = buf.toString();
            String dir = fileName.substring(0, fileName.lastIndexOf(47));
            if (!this.itemFs.exists(dir)) {
                this.itemFs.createFolder(dir);
            }
            out = this.itemFs.getOutputStream(fileName);
            Serializer.serialize(refs, out);
            out.flush();
        }
        catch (Exception e) {
            String msg = "failed to write property state: " + refs.getTargetId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized void destroy(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            StringBuffer buf = this.buildNodeReferencesFilePath(null, refs.getId());
            this.itemFs.deleteFile(buf.toString());
        }
        catch (Exception e) {
            if (e instanceof NoSuchItemStateException) {
                throw (NoSuchItemStateException)e;
            }
            String msg = "failed to delete references: " + refs.getTargetId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    public synchronized boolean exists(NodeReferencesId targetId) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            StringBuffer buf = this.buildNodeReferencesFilePath(null, targetId);
            return this.itemFs.exists(buf.toString());
        }
        catch (Exception e) {
            String msg = "failed to check existence of node references: " + targetId;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
    }

    protected void closeStream(InputStream ins) {
        if (ins != null) {
            try {
                ins.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void logException(String message, SQLException se) {
        if (message != null) {
            log.error(message);
        }
        log.error("       Reason: " + se.getMessage());
        log.error("   State/Code: " + se.getSQLState() + "/" + se.getErrorCode());
        log.debug("   dump:", (Throwable)se);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public NodeIdIterator getAllNodeIds(NodeId bigger, int maxCount) throws ItemStateException {
        ArrayList list = new ArrayList();
        try {
            this.getListRecursive(list, "", bigger == null ? null : bigger.getUUID(), maxCount);
            return new FileNodeIdIterator(list);
        }
        catch (FileSystemException e) {
            String msg = "failed to read node list: " + bigger + ": " + e;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    protected UUID getUUIDFromFileName(String fileName) {
        char c;
        StringBuffer buff = new StringBuffer(35);
        if (!fileName.endsWith(".n")) {
            return null;
        }
        for (int i = 0; i < fileName.length() && (c = fileName.charAt(i)) != '.'; ++i) {
            if (c == '/') continue;
            buff.append(c);
            int len = buff.length();
            if (len != 8 && len != 13 && len != 18 && len != 23) continue;
            buff.append('-');
        }
        String u = buff.toString();
        return new UUID(u);
    }

    private void getListRecursive(ArrayList list, String path, UUID bigger, int maxCount) throws FileSystemException {
        if (maxCount > 0 && list.size() >= maxCount) {
            return;
        }
        Object[] files = this.itemFs.listFiles(path);
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            Object f = files[i];
            UUID u = this.getUUIDFromFileName(path + "/" + (String)f);
            if (u == null || bigger != null && bigger.toString().compareTo(u.toString()) < 0) continue;
            NodeId n = new NodeId(u);
            list.add(n);
            if (maxCount <= 0 || list.size() < maxCount) continue;
            return;
        }
        Object[] dirs = this.itemFs.listFolders(path);
        Arrays.sort(dirs);
        for (int i = 0; i < dirs.length; ++i) {
            this.getListRecursive(list, path + "/" + (String)dirs[i], bigger, maxCount);
        }
    }

    private static class FileNodeIdIterator
    implements NodeIdIterator {
        private final ArrayList list;
        private int pos;

        FileNodeIdIterator(ArrayList list) {
            this.list = list;
        }

        @Override
        public NodeId nextNodeId() throws NoSuchElementException {
            if (this.pos < this.list.size()) {
                return (NodeId)this.list.get(this.pos++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.list.size();
        }

        public Object next() {
            return this.nextNodeId();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class FSBlobStore
    extends FileSystemBLOBStore
    implements CloseableBLOBStore {
        private FileSystem fs;

        public FSBlobStore(FileSystem fs) {
            super(fs);
            this.fs = fs;
        }

        @Override
        public String createId(PropertyId id, int index) {
            return BundleFsPersistenceManager.this.buildBlobFilePath(null, id, index).toString();
        }

        @Override
        public void close() {
            try {
                this.fs.close();
                this.fs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static interface CloseableBLOBStore
    extends BLOBStore {
        public void close();
    }
}

