/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.DataInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.util.DbNameIndex;
import org.apache.jackrabbit.core.persistence.bundle.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.bundle.util.PostgreSQLNameIndex;
import org.apache.jackrabbit.core.persistence.bundle.util.TrackingInputStream;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.slf4j.Logger;

public class PostgreSQLPersistenceManager
extends BundleDbPersistenceManager {
    private static Logger log = CommonSLF4JLogger.getLogger(PostgreSQLPersistenceManager.class);

    @Override
    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("org.postgresql.Driver");
        }
        if (this.getSchema() == null) {
            this.setSchema("postgresql");
        }
        super.init(context);
    }

    @Override
    protected DbNameIndex createDbNameIndex() throws SQLException {
        return new PostgreSQLNameIndex(this.connectionManager, this.schemaObjectPrefix);
    }

    @Override
    public int getStorageModel() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized NodePropBundle loadBundle(NodeId id) throws ItemStateException {
        try {
            PreparedStatement stmt = this.connectionManager.executeStmt(this.bundleSelectSQL, this.getKey(id.getUUID()));
            try (ResultSet rs = stmt.getResultSet();){
                if (rs.next()) {
                    try (InputStream input = rs.getBinaryStream(1);){
                        TrackingInputStream cin = new TrackingInputStream(input);
                        DataInputStream din = new DataInputStream(cin);
                        NodePropBundle bundle = this.binding.readBundle(din, id);
                        bundle.setSize(cin.getPosition());
                        NodePropBundle nodePropBundle = bundle;
                        return nodePropBundle;
                    }
                }
                NodePropBundle nodePropBundle = null;
                return nodePropBundle;
            }
        }
        catch (Exception e) {
            String msg = "failed to read bundle: " + id + ": " + e;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }
}

