/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class IndexInfos {
    private int counter = 0;
    private boolean dirty = false;
    private List indexes = new ArrayList();
    private Set names = new HashSet();
    private final String name;

    IndexInfos(String fileName) {
        this.name = fileName;
    }

    boolean exists(File dir) {
        return new File(dir, this.name).exists();
    }

    String getFileName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(File dir) throws IOException {
        try (FileInputStream in = new FileInputStream(new File(dir, this.name));){
            DataInputStream di = new DataInputStream(in);
            this.counter = di.readInt();
            for (int i = di.readInt(); i > 0; --i) {
                String indexName = di.readUTF();
                this.indexes.add(indexName);
                this.names.add(indexName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(File dir) throws IOException {
        if (!this.dirty) {
            return;
        }
        File nu = new File(dir, this.name + ".new");
        try (FileOutputStream out = new FileOutputStream(nu);){
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(this.counter);
            dataOut.writeInt(this.indexes.size());
            for (int i = 0; i < this.indexes.size(); ++i) {
                dataOut.writeUTF(this.getName(i));
            }
        }
        File old = new File(dir, this.name);
        if (old.exists() && !old.delete()) {
            throw new IOException("Unable to delete file: " + old.getAbsolutePath());
        }
        if (!nu.renameTo(old)) {
            throw new IOException("Unable to rename file: " + nu.getAbsolutePath());
        }
        this.dirty = false;
    }

    String getName(int i) {
        return (String)this.indexes.get(i);
    }

    int size() {
        return this.indexes.size();
    }

    void addName(String name) {
        if (this.names.contains(name)) {
            throw new IllegalArgumentException("already contains: " + name);
        }
        this.indexes.add(name);
        this.names.add(name);
        this.dirty = true;
    }

    void removeName(String name) {
        this.indexes.remove(name);
        this.names.remove(name);
        this.dirty = true;
    }

    void removeName(int i) {
        Object name = this.indexes.remove(i);
        this.names.remove(name);
        this.dirty = true;
    }

    boolean contains(String name) {
        return this.names.contains(name);
    }

    String newName() {
        this.dirty = true;
        return "_" + Integer.toString(this.counter++, 36);
    }
}

