/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.analysis.Analyzer;
import com.kingdee.bos.ctrl.lucene.analysis.TokenStream;
import com.kingdee.bos.ctrl.lucene.analysis.standard.StandardAnalyzer;
import java.io.Reader;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;

public class JackrabbitAnalyzer
extends Analyzer {
    private Analyzer defaultAnalyzer = new StandardAnalyzer(new String[0]);
    private IndexingConfiguration indexingConfig;

    protected void setIndexingConfig(IndexingConfiguration indexingConfig) {
        this.indexingConfig = indexingConfig;
    }

    protected void setDefaultAnalyzer(Analyzer analyzer) {
        this.defaultAnalyzer = analyzer;
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer propertyAnalyzer;
        if (this.indexingConfig != null && (propertyAnalyzer = this.indexingConfig.getPropertyAnalyzer(fieldName)) != null) {
            return propertyAnalyzer.tokenStream(fieldName, reader);
        }
        return this.defaultAnalyzer.tokenStream(fieldName, reader);
    }
}

