/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.AbstractWeight;
import org.apache.jackrabbit.core.query.lucene.MatchAllScorer;

class MatchAllWeight
extends AbstractWeight {
    private final String field;
    private final Query query;
    private float value;
    private float idf;
    private float queryWeight;

    MatchAllWeight(Query query, Searcher searcher, String field) {
        super(searcher);
        this.query = query;
        this.field = field;
    }

    @Override
    protected Scorer createScorer(IndexReader reader) throws IOException {
        return new MatchAllScorer(reader, this.field);
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public float sumOfSquaredWeights() throws IOException {
        this.idf = this.searcher.getSimilarity().idf(this.searcher.maxDoc(), this.searcher.maxDoc());
        this.queryWeight = this.idf * 1.0f;
        return this.queryWeight * this.queryWeight;
    }

    @Override
    public void normalize(float queryNorm) {
        this.queryWeight *= queryNorm;
        this.value = this.queryWeight * this.idf;
    }

    @Override
    public Explanation explain(IndexReader reader, int doc) throws IOException {
        return new Explanation(Similarity.getDefault().idf(reader.maxDoc(), reader.maxDoc()), "matchAll");
    }
}

