/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.extractor.TextExtractor;

public class TextExtractorFilter
implements TextFilter {
    private final TextExtractor extractor;

    public TextExtractorFilter(TextExtractor extractor) {
        this.extractor = extractor;
    }

    @Override
    public boolean canFilter(String mimeType) {
        mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        String[] types = this.extractor.getContentTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map doFilter(PropertyState data, String encoding) throws RepositoryException {
        InternalValue[] values = data.getValues();
        if (values.length == 1) {
            try {
                String type = "application/octet-stream";
                String[] types = this.extractor.getContentTypes();
                if (types.length > 0) {
                    type = types[0];
                }
                BLOBFileValue blob = values[0].getBLOBFileValue();
                Reader reader = this.extractor.extractText(blob.getStream(), type, encoding);
                HashMap<String, Reader> result = new HashMap<String, Reader>();
                result.put(FieldNames.FULLTEXT, reader);
                return result;
            }
            catch (IOException e) {
                throw new RepositoryException("Text extraction error", (Throwable)e);
            }
        }
        throw new RepositoryException("Multi-valued binary properties not supported.");
    }
}

