/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import com.kingdee.bos.ctrl.lucene.document.Document;
import com.kingdee.bos.ctrl.lucene.document.Field;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.jackrabbit.core.query.lucene.TextExtractorReader;
import org.slf4j.Logger;

public class Util {
    private static final Logger log = CommonSLF4JLogger.getLogger(Util.class);

    public static void disposeDocument(Document old) {
        Enumeration e = old.fields();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            if (f.readerValue() == null) continue;
            try {
                f.readerValue().close();
            }
            catch (IOException ex) {
                log.warn("Exception while disposing index document: " + ex);
            }
        }
    }

    public static boolean isDocumentReady(Document doc) {
        Enumeration fields = doc.fields();
        while (fields.hasMoreElements()) {
            TextExtractorReader r;
            Field f = (Field)fields.nextElement();
            if (!(f.readerValue() instanceof TextExtractorReader) || (r = (TextExtractorReader)f.readerValue()).isExtractorFinished()) continue;
            return false;
        }
        return true;
    }
}

