/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.slf4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

abstract class AbstractSAXEventGenerator {
    private static Logger log = CommonSLF4JLogger.getLogger(AbstractSAXEventGenerator.class);
    protected final Session session;
    protected final NamespaceResolver nsResolver;
    protected final NamePathResolver resolver;
    protected final ContentHandler contentHandler;
    protected final Node startNode;
    protected final boolean skipBinary;
    protected final boolean noRecurse;
    protected NamespaceStack namespaces;
    protected final String jcrPrimaryType;
    protected final String jcrMixinTypes;
    protected final String jcrUUID;
    protected final String jcrRoot;
    protected final String jcrXMLText;
    protected final String jcrXMLCharacters;

    protected AbstractSAXEventGenerator(Node node, boolean noRecurse, boolean skipBinary, ContentHandler contentHandler) throws RepositoryException {
        this.startNode = node;
        this.session = node.getSession();
        this.nsResolver = new SessionNamespaceResolver(this.session);
        this.contentHandler = contentHandler;
        this.skipBinary = skipBinary;
        this.noRecurse = noRecurse;
        this.namespaces = new NamespaceStack(null);
        this.resolver = new DefaultNamePathResolver(this.nsResolver);
        try {
            this.jcrPrimaryType = this.resolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
            this.jcrMixinTypes = this.resolver.getJCRName(NameConstants.JCR_MIXINTYPES);
            this.jcrUUID = this.resolver.getJCRName(NameConstants.JCR_UUID);
            this.jcrRoot = this.resolver.getJCRName(NameConstants.JCR_ROOT);
            this.jcrXMLText = this.resolver.getJCRName(NameConstants.JCR_XMLTEXT);
            this.jcrXMLCharacters = this.resolver.getJCRName(NameConstants.JCR_XMLCHARACTERS);
        }
        catch (NamespaceException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public void serialize() throws RepositoryException, SAXException {
        this.contentHandler.startDocument();
        this.startNamespaceDeclarations();
        this.process(this.startNode, 0);
        this.endNamespaceDeclarations();
        this.contentHandler.endDocument();
    }

    protected void startNamespaceDeclarations() throws RepositoryException, SAXException {
        String[] prefixes = this.session.getNamespacePrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            String prefix = prefixes[i];
            if ("xml".equals(prefix)) continue;
            String uri = this.session.getNamespaceURI(prefix);
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    protected void endNamespaceDeclarations() throws RepositoryException, SAXException {
        String[] prefixes = this.session.getNamespacePrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            String prefix = prefixes[i];
            if ("xml".equals(prefix)) continue;
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    protected void addNamespacePrefixes(int level, AttributesImpl attributes) throws RepositoryException {
        String[] prefixes = this.session.getNamespacePrefixes();
        NamespaceStack newNamespaces = null;
        for (int i = 0; i < prefixes.length; ++i) {
            String mappedToNs;
            String uri;
            String prefix = prefixes[i];
            if (prefix.length() <= 0 || "xml".equals(prefix) || (uri = this.session.getNamespaceURI(prefix)).equals(mappedToNs = this.namespaces.getNamespaceURI(prefix))) continue;
            attributes.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, "CDATA", uri);
            if (newNamespaces == null) {
                this.namespaces = newNamespaces = new NamespaceStack(this.namespaces);
            }
            newNamespaces.setNamespacePrefix(prefix, uri);
        }
    }

    protected void process(Node node, int level) throws RepositoryException, SAXException {
        this.entering(node, level);
        this.enteringProperties(node, level);
        TreeMap<String, Property> properties = new TreeMap<String, Property>();
        PropertyIterator propIter = node.getProperties();
        while (propIter.hasNext()) {
            Property property = propIter.nextProperty();
            properties.put(property.getName(), property);
        }
        if (!properties.containsKey(this.jcrPrimaryType)) {
            throw new RepositoryException("Missing jcr:primaryType property: " + node.getPath());
        }
        this.process((Property)properties.remove(this.jcrPrimaryType), level + 1);
        if (properties.containsKey(this.jcrMixinTypes)) {
            this.process((Property)properties.remove(this.jcrMixinTypes), level + 1);
        }
        if (properties.containsKey(this.jcrUUID)) {
            this.process((Property)properties.remove(this.jcrUUID), level + 1);
        }
        Iterator iterator = properties.values().iterator();
        while (iterator.hasNext()) {
            this.process((Property)iterator.next(), level + 1);
        }
        this.leavingProperties(node, level);
        if (!this.noRecurse) {
            NodeIterator nodeIter = node.getNodes();
            while (nodeIter.hasNext()) {
                Node childNode = nodeIter.nextNode();
                NamespaceStack previousNamespaces = this.namespaces;
                this.process(childNode, level + 1);
                this.namespaces = previousNamespaces;
            }
        }
        this.leaving(node, level);
    }

    protected void process(Property prop, int level) throws RepositoryException, SAXException {
        this.entering(prop, level);
        this.leaving(prop, level);
    }

    protected abstract void entering(Node var1, int var2) throws RepositoryException, SAXException;

    protected abstract void enteringProperties(Node var1, int var2) throws RepositoryException, SAXException;

    protected abstract void leavingProperties(Node var1, int var2) throws RepositoryException, SAXException;

    protected abstract void leaving(Node var1, int var2) throws RepositoryException, SAXException;

    protected abstract void entering(Property var1, int var2) throws RepositoryException, SAXException;

    protected abstract void leaving(Property var1, int var2) throws RepositoryException, SAXException;

    private static class NamespaceStack {
        private final NamespaceStack parent;
        private final Map namespaces;

        public NamespaceStack(NamespaceStack parent) {
            this.parent = parent;
            this.namespaces = new HashMap();
        }

        public String getNamespaceURI(String prefix) {
            String namespace = (String)this.namespaces.get(prefix);
            if (namespace != null) {
                return namespace;
            }
            if (this.parent != null) {
                return this.parent.getNamespaceURI(prefix);
            }
            return null;
        }

        public void setNamespacePrefix(String prefix, String uri) {
            this.namespaces.put(prefix, uri);
        }
    }
}

