/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.identifier;

import java.io.Serializable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;

public abstract class AbstractIdFactory
implements IdFactory {
    protected abstract PathFactory getPathFactory();

    @Override
    public NodeId createNodeId(NodeId parentId, Path path) {
        try {
            return new NodeIdImpl(parentId, path);
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public NodeId createNodeId(String uniqueID, Path path) {
        return new NodeIdImpl(uniqueID, path);
    }

    @Override
    public NodeId createNodeId(String uniqueID) {
        return new NodeIdImpl(uniqueID);
    }

    @Override
    public PropertyId createPropertyId(NodeId parentId, Name propertyName) {
        try {
            return new PropertyIdImpl(parentId, propertyName);
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private class PropertyIdImpl
    extends ItemIdImpl
    implements PropertyId {
        private final NodeId parentId;

        private PropertyIdImpl(NodeId parentId, Name name) throws RepositoryException {
            super(parentId, name);
            this.parentId = parentId;
        }

        @Override
        public boolean denotesNode() {
            return false;
        }

        @Override
        public NodeId getParentId() {
            return this.parentId;
        }

        @Override
        public Name getName() {
            return this.getPath().getNameElement().getName();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PropertyId) {
                return super.equals((PropertyId)obj);
            }
            return false;
        }
    }

    private class NodeIdImpl
    extends ItemIdImpl
    implements NodeId {
        public NodeIdImpl(String uniqueID) {
            super(uniqueID, null);
        }

        public NodeIdImpl(String uniqueID, Path path) {
            super(uniqueID, path);
        }

        public NodeIdImpl(NodeId parentId, Path path) throws RepositoryException {
            super(parentId.getUniqueID(), parentId.getPath() != null ? AbstractIdFactory.this.getPathFactory().create(parentId.getPath(), path, true) : path);
        }

        @Override
        public boolean denotesNode() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NodeId) {
                return super.equals((NodeId)obj);
            }
            return false;
        }
    }

    private abstract class ItemIdImpl
    implements ItemId,
    Serializable {
        private final String uniqueID;
        private final Path path;
        private transient int hashCode = 0;

        private ItemIdImpl(String uniqueID, Path path) {
            if (uniqueID == null && path == null) {
                throw new IllegalArgumentException("Only uniqueID or relative path might be null.");
            }
            this.uniqueID = uniqueID;
            this.path = path;
        }

        private ItemIdImpl(NodeId parentId, Name name) throws RepositoryException {
            if (parentId == null || name == null) {
                throw new IllegalArgumentException("Invalid ItemIdImpl: parentId and name must not be null.");
            }
            this.uniqueID = parentId.getUniqueID();
            Path parentPath = parentId.getPath();
            this.path = parentPath != null ? AbstractIdFactory.this.getPathFactory().create(parentPath, name, true) : AbstractIdFactory.this.getPathFactory().create(name);
        }

        @Override
        public abstract boolean denotesNode();

        @Override
        public String getUniqueID() {
            return this.uniqueID;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ItemId) {
                ItemId other = (ItemId)obj;
                return this.equals(other);
            }
            return false;
        }

        boolean equals(ItemId other) {
            return (this.uniqueID == null ? other.getUniqueID() == null : this.uniqueID.equals(other.getUniqueID())) && (this.path == null ? other.getPath() == null : this.path.equals(other.getPath()));
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.toString().hashCode();
            }
            return this.hashCode;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            if (this.uniqueID != null) {
                b.append(this.uniqueID);
            }
            if (this.path != null) {
                b.append(this.path.toString());
            }
            return b.toString();
        }
    }
}

