/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.CellMatcher;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.ICellUserObjectReplacer;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellFinder;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.HashMap;

final class CellReplacer
implements CellFinder.ICellReplacer {
    private StyleAttributes _sa;
    private String _replaceValue;
    private CellMatcher _cellMatcher;
    private HashMap _uoReplacers;

    CellReplacer() {
    }

    void addUserObjectMatcher(Object serMode, ICellUserObjectReplacer replacer) {
        if (this._uoReplacers == null) {
            this._uoReplacers = new HashMap();
        }
        if (replacer == null) {
            this._uoReplacers.remove(serMode);
        } else {
            this._uoReplacers.put(serMode, replacer);
        }
    }

    StyleAttributes getReplaceSA() {
        return this._sa;
    }

    String getReplaceValue() {
        return this._replaceValue;
    }

    void setCellMatcher(CellMatcher cellMatcher) {
        this._cellMatcher = cellMatcher;
    }

    void setSA(StyleAttributes sa) {
        this._sa = sa;
    }

    void setReplaceValue(String value) {
        this._replaceValue = value;
    }

    @Override
    public StyleAttributes getSA(Cell cell) {
        if (this._sa == null) {
            return null;
        }
        long l = this._sa.sameBits((ShareStyleAttributes)cell.getStyle(), 0, ShareStyleAttributes.ATTRS_COUNT);
        if (l <= 0L) {
            return this._sa;
        }
        if (this._sa.getAttrsBits() == l) {
            return null;
        }
        StyleAttributes sa = Styles.getSA((StyleAttributes)this._sa);
        sa.clearAttributes(l);
        return sa;
    }

    @Override
    public String getFormula(Cell cell) {
        return StringUtil.replace((String)cell.getDisplayFormula(), (String)this._cellMatcher.getValue(), (String)this._replaceValue, (boolean)this._cellMatcher.isMatchFull(), (boolean)this._cellMatcher.isMatchCase());
    }

    @Override
    public boolean canReplaceStyle() {
        return this._sa != null;
    }

    @Override
    public boolean canReplaceFormula() {
        Object serMode = this._cellMatcher.getSerMode();
        if (serMode != CellMatcher.FIND_FORMULA) {
            return false;
        }
        return !StringUtil.isEmptyString((String)this._replaceValue) || !StringUtil.isEmptyString((String)this._cellMatcher.getValue());
    }

    @Override
    public UserObject getUseObject(Cell cell) {
        Object o;
        Object serMode = this._cellMatcher.getSerMode();
        if (serMode == CellMatcher.FIND_FORMULA) {
            return null;
        }
        if (this._uoReplacers != null && (o = this._uoReplacers.get(serMode)) != null) {
            return ((ICellUserObjectReplacer)o).getUseObject(cell, serMode, this._cellMatcher.getValue(), this._replaceValue, this._cellMatcher.isMatchFull(), this._cellMatcher.isMatchCase());
        }
        return null;
    }

    @Override
    public boolean canReplaceUseObject() {
        Object o;
        Object serMode = this._cellMatcher.getSerMode();
        if (serMode == CellMatcher.FIND_FORMULA) {
            return false;
        }
        if (this._uoReplacers != null && (o = this._uoReplacers.get(serMode)) != null) {
            return ((ICellUserObjectReplacer)o).canReplaceUseObject();
        }
        return false;
    }
}

