/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.expr;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.common.variant.WeakHashSet;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;

public class ExprConst
implements IExprNode {
    public static final ExprConst TRUE = new ExprConst(Variant.trueVariant);
    public static final ExprConst FALSE = new ExprConst(Variant.falseVariant);
    public static final ExprConst NULL = new ExprConst(Variant.nullVariant);
    public static final ExprConst BADID = new ExprConst(new Variant((Object)new SyntaxErrorException(131072L), 16));
    public static final ExprConst DEFAULT_PARAM = new ExprConst(Variant.nullVariant);
    private Variant _value;
    private int _hashCode;

    public static ExprConst getExprConst(WeakHashSet set, Variant value) {
        ExprConst out;
        ExprConst in = new ExprConst(value);
        Object obj = set.get((Object)in);
        if (obj == null) {
            set.add((Object)in);
            out = in;
        } else {
            out = (ExprConst)obj;
        }
        return out;
    }

    private ExprConst(Variant value) {
        this._value = value;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = this._value.isNull() || this._value.isEmpty() ? Integer.MAX_VALUE : this._value.hashCode();
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExprConst) {
            Variant cmpValue = ((ExprConst)obj)._value;
            if (this._value.getVt() != cmpValue.getVt()) {
                return false;
            }
            return this._value.equals(cmpValue);
        }
        return false;
    }

    public Variant getValue() {
        return this._value;
    }

    public String toString() {
        return this._value.toString();
    }

    @Override
    public int getExprType() {
        return 2;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) {
        ctx.getCurrentExprStack().push(this._value);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        Object obj = this._value.getValue();
        if (obj instanceof Cell) {
            return "";
        }
        if (obj instanceof CellBlockNode) {
            return ((CellBlockNode)obj).decode(ctx, exprOwner);
        }
        if (this._value.getVt() == 11) {
            String orgStr = this._value.toString();
            StringBuffer sb = new StringBuffer(orgStr.length() + 2);
            sb.append('\"');
            int end = orgStr.length();
            for (int i = 0; i < end; ++i) {
                char ch = orgStr.charAt(i);
                if (ch == '\"') {
                    sb.append('\\');
                }
                sb.append(ch);
            }
            sb.append('\"');
            return sb.toString();
        }
        return this._value.toString();
    }
}

