/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.ExceptionHandler;
import com.kingdee.bos.ctrl.excel.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.excel.model.expr.ExprUID;
import com.kingdee.bos.ctrl.excel.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.INeedSheetInfo;
import com.kingdee.bos.ctrl.excel.model.struct.IPackageQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.QueryPackage;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class QueryManager
implements Serializable {
    private static final long serialVersionUID = 1182942963564351454L;
    private transient HashMap _providers;
    private transient IPackageQuery _packageListener;
    private transient Parameter _currentParameter;
    private HashMap _values = new HashMap();
    private HashMap _invokeQueries;
    private HashMap _batchQueries;

    QueryManager(HashMap batchQueries, HashMap invokeQueries) {
        this._batchQueries = batchQueries != null ? batchQueries : new HashMap();
        this._invokeQueries = invokeQueries != null ? invokeQueries : new HashMap();
        this._providers = new HashMap();
    }

    public void clear() {
        this._providers.clear();
        this._values.clear();
        this._batchQueries.clear();
        this._invokeQueries.clear();
    }

    public boolean isEmpty() {
        return this._batchQueries.isEmpty() && this._invokeQueries.isEmpty();
    }

    public void setPackageListener(IPackageQuery packageListener) {
        this._packageListener = packageListener;
    }

    public Parameter getCurrentParameter() {
        return this._currentParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean query(FunctionManager fm) {
        if (this._batchQueries.isEmpty() && this._invokeQueries.isEmpty()) {
            return false;
        }
        boolean ret = false;
        if (this._packageListener != null) {
            QueryPackage pkg = new QueryPackage(this);
            ret = this._packageListener.batchQuery(pkg);
            pkg.getQueryManager().gainValues();
            this.copyValuesFrom(pkg.getQueryManager());
            this._batchQueries.clear();
            this._invokeQueries.clear();
        } else {
            if (!this._batchQueries.isEmpty()) {
                Iterator i = this._batchQueries.entrySet().iterator();
                if (i.hasNext()) {
                    ret = true;
                    while (i.hasNext()) {
                        Map.Entry e2 = i.next();
                        HashMap bag = (HashMap)e2.getValue();
                        IMethodBatchQuery provider = (IMethodBatchQuery)this._providers.get(e2.getKey());
                        if (!this.queryBag(provider, bag)) continue;
                        this.gainBagValues(bag);
                    }
                }
                this._batchQueries.clear();
            }
            if (fm != null && !this._invokeQueries.isEmpty()) {
                ret = true;
                for (Map.Entry e2 : this._invokeQueries.entrySet()) {
                    Object provider = this._providers.get(e2.getKey());
                    INeedSheetInfo infoProvider = provider instanceof INeedSheetInfo ? (INeedSheetInfo)provider : null;
                    HashMap providerBag = (HashMap)e2.getValue();
                    for (Map.Entry e2 : providerBag.entrySet()) {
                        String methodName = (String)e2.getKey();
                        SortedParameterArray sa = (SortedParameterArray)((Object)e2.getValue());
                        for (int p = sa.size() - 1; p >= 0; --p) {
                            Parameter param;
                            this._currentParameter = param = sa.getParameter(p);
                            ExprMethod em = fm.getExprMethod(methodName, param.count());
                            try {
                                Object result;
                                if (infoProvider != null) {
                                    infoProvider.setSheetName(param.getSheetName());
                                }
                                if (!((result = em.getMethod().invoke(provider, em.getProperArgs(param.getArgs()))) instanceof Variant)) {
                                    result = new Variant(result);
                                }
                                param.setValue(result);
                                continue;
                            }
                            catch (Exception ex) {
                                Object obj = ExceptionHandler.handleInvokeException(ex, fm);
                                if (!(obj instanceof Variant)) {
                                    obj = new Variant((Object)new SyntaxErrorException(128L, obj), 16);
                                }
                                param.setValue(obj);
                                continue;
                            }
                            finally {
                                this._currentParameter = null;
                            }
                        }
                    }
                    this.gainBagValues(providerBag);
                }
                this._invokeQueries.clear();
            }
        }
        return ret;
    }

    private void gainValues() {
        for (Map.Entry e : this._batchQueries.entrySet()) {
            this.gainBagValues((HashMap)e.getValue());
        }
        for (Map.Entry e : this._invokeQueries.entrySet()) {
            this.gainBagValues((HashMap)e.getValue());
        }
    }

    private void gainBagValues(HashMap providerBag) {
        this.checkQueryBagValues(providerBag);
        Iterator bi = providerBag.entrySet().iterator();
        while (bi.hasNext()) {
            SortedParameterArray params = (SortedParameterArray)((Object)bi.next().getValue());
            for (int i = params.size() - 1; i >= 0; --i) {
                Parameter param = params.getParameter(i);
                this._values.put(param.getUID(), param);
            }
        }
    }

    private void checkQueryBagValues(HashMap bag) {
        for (Map.Entry e : bag.entrySet()) {
            SortedParameterArray params = (SortedParameterArray)((Object)e.getValue());
            for (int p = params.size() - 1; p >= 0; --p) {
                Parameter param = (Parameter)params.get(p);
                if (param.getValue() != null) continue;
                param.setValue((Object)SyntaxErrorException.BAD_QUERY);
            }
        }
    }

    public void copyValuesFrom(QueryManager qm) {
        this._values.putAll(qm._values);
    }

    private boolean queryBag(IMethodBatchQuery batchListener, HashMap bag) {
        if (batchListener == null) {
            return false;
        }
        try {
            batchListener.batchQuery(bag);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void putParameter(HashMap queries, ExprMethod em, String methodName, Parameter param, Variant uid) {
        SortedParameterArray params;
        HashMap<String, SortedParameterArray> bag = null;
        String providerName = em.getProviderName();
        bag = (HashMap<String, SortedParameterArray>)queries.get(providerName);
        if (bag == null) {
            bag = new HashMap<String, SortedParameterArray>();
            queries.put(providerName, bag);
            this._providers.put(providerName, em.getProviderInstance());
        }
        if ((params = (SortedParameterArray)((Object)bag.get(methodName))) == null) {
            params = new SortedParameterArray();
            params.insert(param);
            bag.put(methodName, params);
        } else {
            int pos = params.search(param);
            if (pos < 0) {
                params.insert(pos, param);
            } else {
                param = params.getParameter(pos);
                uid.setInteger(param.getUID());
            }
        }
    }

    public Object getValue(ExprMethod em, Object[] args, String sheetName, Variant varUID, boolean reQuery) {
        Integer uid = (Integer)varUID.getValue();
        Object ret = this._values.get(uid);
        if (ret == null) {
            if (reQuery) {
                Parameter param = new Parameter(args, sheetName, em.isNeedSheetInfo());
                param.setUID(uid);
                String methodName = em.getName();
                HashMap queries = em.isBatchMethod() ? this._batchQueries : this._invokeQueries;
                SortedParameterArray params = null;
                Object bag = queries.get(em.getProviderName());
                if (bag != null) {
                    params = (SortedParameterArray)((Object)((HashMap)bag).get(methodName));
                }
                if (params == null) {
                    this.putParameter(queries, em, methodName, param, varUID);
                } else {
                    int pos = params.search(param);
                    if (pos >= 0) {
                        Parameter p = params.getParameter(pos);
                        varUID.setObject((Object)p.getUID());
                        ret = p.getValue();
                    } else {
                        Integer newUid = new Integer(ExprUID.getUID());
                        param.setUID(newUid);
                        varUID.setInteger(newUid);
                        this.putParameter(queries, em, methodName, param, varUID);
                    }
                }
            }
        } else {
            ret = ((Parameter)ret).getValue();
        }
        return ret;
    }

    public Object getProvider(String providerName) {
        return this._providers == null ? null : this._providers.get(providerName);
    }

    public void resumeProviders(FunctionManager fm) {
        if (this._providers == null) {
            this._providers = new HashMap();
        }
        this.resumeProviders(this._batchQueries, fm);
        this.resumeProviders(this._invokeQueries, fm);
    }

    private void resumeProviders(HashMap queries, FunctionManager fm) {
        for (Map.Entry e : queries.entrySet()) {
            String instName = (String)e.getKey();
            Object inst = null;
            HashMap bag = (HashMap)e.getValue();
            e = bag.entrySet().iterator().next();
            String methodName = (String)e.getKey();
            SortedParameterArray sa = (SortedParameterArray)((Object)e.getValue());
            int paramCount = sa.getParameter(0).count();
            inst = fm.getExprMethod(methodName, paramCount).getProviderInstance();
            this._providers.put(instName, inst);
        }
    }

    public HashMap getBatchQueries() {
        return this._batchQueries;
    }

    public HashMap getInvokeQueries() {
        return this._invokeQueries;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        HashMap map = this.getBatchQueries();
        this.ouput(buf, map, "BatchQuery");
        map = this.getInvokeQueries();
        this.ouput(buf, map, "InvokeQuery");
        return buf.toString();
    }

    private void ouput(StringBuffer buf, Map map, String title) {
        for (Map.Entry emap : map.entrySet()) {
            String className = (String)emap.getKey();
            buf.append(title);
            buf.append("***");
            buf.append(className);
            buf.append("\n");
            Map methods = (Map)emap.getValue();
            for (Map.Entry eMethod : methods.entrySet()) {
                String methodName = (String)eMethod.getKey();
                SortedParameterArray sa = (SortedParameterArray)((Object)eMethod.getValue());
                for (int p = sa.size() - 1; p >= 0; --p) {
                    buf.append("******");
                    buf.append(methodName);
                    buf.append("(");
                    Parameter param = sa.getParameter(p);
                    Object[] args = param.getArgs();
                    for (int i = 0; i < args.length; ++i) {
                        buf.append(args[i]);
                        if (i == args.length - 1) continue;
                        buf.append(",");
                    }
                    buf.append(")=");
                    buf.append(param.getValue());
                    buf.append("\n");
                }
            }
        }
    }
}

