/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.filter;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.swing.StringUtils;

public class CellValueModel
implements Comparable {
    private Variant value;
    private String text;

    public CellValueModel(Variant value, String text) {
        this.value = value;
        this.text = text;
    }

    public CellValueModel(Cell cell) {
        if (cell == null || cell.isEmptyContent2()) {
            this.value = Variant.emptyVariant;
            this.text = "";
        } else {
            this.value = cell.getValue();
            this.text = cell.getText();
        }
    }

    public Variant getValue() {
        return this.value;
    }

    public String getText() {
        return this.text;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        int result = 0;
        if (o instanceof CellValueModel) {
            CellValueModel o1 = (CellValueModel)o;
            if (StringUtils.isEmpty((String)this.text) && StringUtils.isEmpty((String)o1.text) && (this.value.equals(Variant.emptyVariant) || o1.value.equals(Variant.emptyVariant))) {
                return 0;
            }
            if (StringUtils.isEmpty((String)this.text) && (this.value.equals(Variant.emptyVariant) || o1.value.equals(Variant.emptyVariant))) {
                return -1;
            }
            try {
                return this.value.compareTo(o1.value);
            }
            catch (SyntaxErrorException e) {
                return -1;
            }
        }
        return result;
    }
}

