/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.filter;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AbstractAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.CellValueModel;
import com.kingdee.bos.ctrl.excel.model.struct.filter.ISheetAutoFilter;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import java.util.ArrayList;
import java.util.List;

public class SheetMultipleItemAutoFilter
extends AbstractAutoFilter {
    private SortedObjectArray cellValueModelArray = new SortedObjectArray();

    public SheetMultipleItemAutoFilter(Sheet sheet, int colIndex) {
        super(sheet, colIndex);
    }

    @Override
    public ISheetAutoFilter changedColIndex(int colIndex) {
        ArrayList<CellValueModel> list = new ArrayList<CellValueModel>();
        for (int index = 0; index < this.cellValueModelArray.size(); ++index) {
            list.add((CellValueModel)this.cellValueModelArray.get(index));
        }
        return new SheetMultipleItemAutoFilter(this.sheet, colIndex, list);
    }

    public SheetMultipleItemAutoFilter(Sheet sheet, int colIndex, List<CellValueModel> values) {
        super(sheet, colIndex);
        this.cellValueModelArray.appendAll(values.toArray());
    }

    @Override
    protected boolean matchFilter(Cell cell) {
        for (int i = 0; i < this.cellValueModelArray.size(); ++i) {
            CellValueModel cellModel = (CellValueModel)this.cellValueModelArray.get(i);
            if (!(cell != null && cell.getText() != null && cell.getText().length() != 0 || cellModel.getText() != null && cellModel.getText().length() != 0)) {
                return true;
            }
            if (cell == null || !cellModel.getText().equals(cell.getText())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getAutoFilterType() {
        return 4;
    }

    public SortedObjectArray getSelectedCellValueModels() {
        return this.cellValueModelArray;
    }

    public boolean containsCellValueModel(CellValueModel model) {
        for (int i = 0; i < this.cellValueModelArray.size(); ++i) {
            CellValueModel cellModel = (CellValueModel)this.cellValueModelArray.get(i);
            if (!cellModel.getText().equals(model.getText())) continue;
            return true;
        }
        return false;
    }

    public void addSelectedCellValueModel(CellValueModel model) {
        if (!this.containsCellValueModel(model)) {
            this.cellValueModelArray.append((Object)model);
        }
    }
}

