/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.util;

import java.util.Arrays;

public class SortedIntIndexArray {
    private static int MIN_SIZE = 2;
    protected int[] _ai = null;
    protected Object[] _ao = null;
    protected int _count = 0;

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        if (!this.isEmpty()) {
            for (int i = 0; i < this._count; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(this._ao[i].toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public int count() {
        return this._count;
    }

    public boolean isEmpty() {
        return this._ai == null || this._count == 0;
    }

    public void clear() {
        Arrays.fill(this._ai, 0, this._count, -1);
        Arrays.fill(this._ao, 0, this._count, null);
        this._count = 0;
    }

    public Object insert(int index, Object obj) {
        Object oldValue = null;
        if (this.isEmpty()) {
            if (this._ai == null) {
                this._ai = new int[MIN_SIZE];
                this._ao = new Object[MIN_SIZE];
            }
            this._ai[0] = index;
            this._ao[0] = obj;
            this._count = 1;
        } else if (this._ai[this._count - 1] < index) {
            this.append(index, obj);
        } else {
            int pos = this.search(index);
            if (pos >= 0) {
                oldValue = this._ao[pos];
                this._ao[pos] = obj;
                this._ai[pos] = index;
            } else {
                pos = -(pos + 1);
                if (this._count + 1 > this._ai.length) {
                    int[] newAI = new int[this._ai.length * 3 / 2 + 1];
                    System.arraycopy(this._ai, 0, newAI, 0, pos);
                    System.arraycopy(this._ai, pos, newAI, pos + 1, this._count - pos);
                    this._ai = newAI;
                    Object[] newAO = new Object[this._ai.length];
                    System.arraycopy(this._ao, 0, newAO, 0, pos);
                    System.arraycopy(this._ao, pos, newAO, pos + 1, this._count - pos);
                    this._ao = newAO;
                } else {
                    System.arraycopy(this._ai, pos, this._ai, pos + 1, this._count - pos);
                    System.arraycopy(this._ao, pos, this._ao, pos + 1, this._count - pos);
                }
                this._ai[pos] = index;
                this._ao[pos] = obj;
                ++this._count;
            }
        }
        return oldValue;
    }

    private void append(int index, Object obj) {
        if (this._count + 1 > this._ai.length) {
            int[] newAI = new int[this._ai.length * 3 / 2 + 1];
            System.arraycopy(this._ai, 0, newAI, 0, this._count);
            this._ai = newAI;
            Object[] newAO = new Object[this._ai.length];
            System.arraycopy(this._ao, 0, newAO, 0, this._count);
            this._ao = newAO;
        }
        this._ai[this._count] = index;
        this._ao[this._count] = obj;
        ++this._count;
    }

    public int search(int index) {
        if (this.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = this._count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = this._ai[mid];
            if (midVal < index) {
                low = mid + 1;
                continue;
            }
            if (midVal > index) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public Object remove(int index) {
        return this.removeByPos(this.search(index));
    }

    private Object removeByPos(int pos) {
        if (pos < 0 || pos >= this._count) {
            return null;
        }
        Object oldValue = this._ao[pos];
        int remain = this._count - (pos + 1);
        System.arraycopy(this._ao, pos + 1, this._ao, pos, remain);
        System.arraycopy(this._ai, pos + 1, this._ai, pos, remain);
        this._ai[this._count - 1] = -1;
        this._ao[--this._count] = null;
        return oldValue;
    }

    public int putAll(SortedIntIndexArray from) {
        int count = 0;
        return count;
    }
}

